/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.local;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.TaskConfig$;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.container.TaskName;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.coordinator.JobModelManager$;
import org.apache.samza.coordinator.stream.CoordinatorStreamManager;
import org.apache.samza.job.CommandBuilder;
import org.apache.samza.job.ShellCommandBuilder;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.StreamJobFactory;
import org.apache.samza.job.local.ProcessJob;
import org.apache.samza.job.local.ProcessJobFactory$;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.storage.ChangelogStreamManager;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.apache.samza.util.Util$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u001b\t\t\u0002K]8dKN\u001c(j\u001c2GC\u000e$xN]=\u000b\u0005\r!\u0011!\u00027pG\u0006d'BA\u0003\u0007\u0003\rQwN\u0019\u0006\u0003\u000f!\tQa]1nu\u0006T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011\u0001c\u0015;sK\u0006l'j\u001c2GC\u000e$xN]=\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011\u0001B;uS2L!a\b\u000f\u0003\u000f1{wmZ5oO\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011A\u0001\u0005\u0006M\u0001!\taJ\u0001\u0007O\u0016$(j\u001c2\u0015\u0005!Z\u0003CA\f*\u0013\tQCAA\u0005TiJ,\u0017-\u001c&pE\")A&\na\u0001[\u000511m\u001c8gS\u001e\u0004\"A\f\u0019\u000e\u0003=R!\u0001\f\u0004\n\u0005Ez#AB\"p]\u001aLw\r")
public class ProcessJobFactory
implements StreamJobFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProcessJobFactory processJobFactory = this;
        synchronized (processJobFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        ProcessJobFactory processJobFactory = this;
        synchronized (processJobFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public StreamJob getJob(Config config) {
        ShellCommandBuilder shellCommandBuilder;
        int containerCount = JobConfig$.MODULE$.Config2Job(config).getContainerCount();
        if (containerCount > 1) {
            throw new SamzaException("Container count larger than 1 is not supported for ProcessJobFactory");
        }
        MetricsRegistryMap metricsRegistry = new MetricsRegistryMap();
        CoordinatorStreamManager coordinatorStreamManager = new CoordinatorStreamManager(config, (MetricsRegistry)metricsRegistry);
        coordinatorStreamManager.register(this.getClass().getSimpleName());
        coordinatorStreamManager.start();
        coordinatorStreamManager.bootstrap();
        ChangelogStreamManager changelogStreamManager = new ChangelogStreamManager(coordinatorStreamManager);
        JobModelManager coordinator = JobModelManager$.MODULE$.apply(coordinatorStreamManager.getConfig(), changelogStreamManager.readPartitionMapping());
        JobModel jobModel = coordinator.jobModel();
        HashMap<TaskName, Integer> taskPartitionMappings = new HashMap<TaskName, Integer>();
        JavaConversions$.MODULE$.collectionAsScalaIterable(jobModel.getContainers().values()).foreach((Function1)new Serializable(this, taskPartitionMappings){
            public static final long serialVersionUID = 0L;
            public final Map taskPartitionMappings$1;

            public final void apply(ContainerModel containerModel) {
                JavaConversions$.MODULE$.collectionAsScalaIterable(containerModel.getTasks().values()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getJob$1 $outer;

                    public final Integer apply(TaskModel taskModel) {
                        return this.$outer.taskPartitionMappings$1.put(taskModel.getTaskName(), Predef$.MODULE$.int2Integer(taskModel.getChangelogPartition().getPartitionId()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.taskPartitionMappings$1 = taskPartitionMappings$1;
            }
        });
        changelogStreamManager.writePartitionMapping(taskPartitionMappings);
        coordinatorStreamManager.stop();
        CheckpointManager checkpointManager = new TaskConfigJava(jobModel.getConfig()).getCheckpointManager((MetricsRegistry)metricsRegistry);
        if (checkpointManager != null) {
            checkpointManager.createResources();
        }
        ChangelogStreamManager.createChangelogStreams(jobModel.getConfig(), jobModel.maxChangeLogStreamPartitions);
        ContainerModel containerModel = coordinator.jobModel().getContainers().get(BoxesRunTime.boxToInteger((int)0));
        String fwkPath = JobConfig$.MODULE$.getFwkPath(config);
        this.info((Function0<Object>)new Serializable(this, fwkPath){
            public static final long serialVersionUID = 0L;
            private final String fwkPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Process job. using fwkPath = ").append((Object)this.fwkPath$1).toString();
            }
            {
                this.fwkPath$1 = fwkPath$1;
            }
        });
        Option<String> option = TaskConfig$.MODULE$.Config2Task(config).getCommandClass();
        if (option instanceof Some) {
            Some some = (Some)option;
            String cmdBuilderClassName = (String)some.x();
            shellCommandBuilder = Util$.MODULE$.getObj(cmdBuilderClassName, CommandBuilder.class);
        } else {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Defaulting to ShellCommandBuilder";
                }
            });
            shellCommandBuilder = new ShellCommandBuilder();
        }
        ShellCommandBuilder commandBuilder = shellCommandBuilder;
        coordinator.start();
        commandBuilder.setConfig(config).setId("0").setUrl(coordinator.server().getUrl()).setCommandPath(fwkPath);
        return new ProcessJob(commandBuilder, coordinator);
    }

    public ProcessJobFactory() {
        Logging$class.$init$(this);
    }
}

