/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.local;

import java.util.concurrent.CountDownLatch;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.CommandBuilder;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.local.ProcessJob$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uq!B\u0001\u0003\u0011\u0003i\u0011A\u0003)s_\u000e,7o\u001d&pE*\u00111\u0001B\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\t1A[8c\u0015\t9\u0001\"A\u0003tC6T\u0018M\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u000b!J|7-Z:t\u0015>\u00147CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u00069=!I!H\u0001\u0015GJ,\u0017\r^3Qe>\u001cWm]:Ck&dG-\u001a:\u0015\u0005y1\u0003CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u000f!J|7-Z:t\u0005VLG\u000eZ3s\u0011\u001593\u00041\u0001)\u00039\u0019w.\\7b]\u0012\u0014U/\u001b7eKJ\u0004\"!\u000b\u0016\u000e\u0003\u0011I!a\u000b\u0003\u0003\u001d\r{W.\\1oI\n+\u0018\u000e\u001c3fe\u001a!\u0001C\u0001\u0001.'\u0011ac&\r\u001b\u0011\u0005}y\u0013B\u0001\u0019!\u0005\u0019y%M[3diB\u0011\u0011FM\u0005\u0003g\u0011\u0011\u0011b\u0015;sK\u0006l'j\u001c2\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]2\u0011\u0001B;uS2L!!\u000f\u001c\u0003\u000f1{wmZ5oO\"Aq\u0005\fB\u0001B\u0003%\u0001\u0006\u0003\u0005=Y\t\u0015\r\u0011\"\u0001>\u0003=QwNY'pI\u0016dW*\u00198bO\u0016\u0014X#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u00053\u0011aC2p_J$\u0017N\\1u_JL!a\u0011!\u0003\u001f){'-T8eK2l\u0015M\\1hKJD\u0001\"\u0012\u0017\u0003\u0002\u0003\u0006IAP\u0001\u0011U>\u0014Wj\u001c3fY6\u000bg.Y4fe\u0002BQ!\u0007\u0017\u0005\u0002\u001d#2\u0001S%K!\tqA\u0006C\u0003(\r\u0002\u0007\u0001\u0006C\u0003=\r\u0002\u0007a\bC\u0004MY\t\u0007I\u0011A'\u0002\t1|7m[\u000b\u0002]!1q\n\fQ\u0001\n9\nQ\u0001\\8dW\u0002Bq!\u0015\u0017C\u0002\u0013\u0005!+\u0001\bqe>\u001cWm]:Ck&dG-\u001a:\u0016\u0003yAa\u0001\u0016\u0017!\u0002\u0013q\u0012a\u00049s_\u000e,7o\u001d\"vS2$WM\u001d\u0011\t\u000fYc\u0003\u0019!C\u0001/\u0006I!n\u001c2Ti\u0006$Xo]\u000b\u00021B\u0011\u0011&W\u0005\u00035\u0012\u0011\u0011#\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0011\u001daF\u00061A\u0005\u0002u\u000bQB[8c'R\fG/^:`I\u0015\fHC\u00010b!\t\u0019r,\u0003\u0002a)\t!QK\\5u\u0011\u001d\u00117,!AA\u0002a\u000b1\u0001\u001f\u00132\u0011\u0019!G\u0006)Q\u00051\u0006Q!n\u001c2Ti\u0006$Xo\u001d\u0011\t\u000f\u0019d\u0003\u0019!C\u0001O\u0006i\u0001O]8dKN\u001cH\u000b\u001b:fC\u0012,\u0012\u0001\u001b\t\u0004'%\\\u0017B\u00016\u0015\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0004\\\u0005\u0003[\u0002\u0012a\u0001\u00165sK\u0006$\u0007bB8-\u0001\u0004%\t\u0001]\u0001\u0012aJ|7-Z:t)\"\u0014X-\u00193`I\u0015\fHC\u00010r\u0011\u001d\u0011g.!AA\u0002!Daa\u001d\u0017!B\u0013A\u0017A\u00049s_\u000e,7o\u001d+ie\u0016\fG\r\t\u0005\u0006k2\"\tA^\u0001\u0007gV\u0014W.\u001b;\u0015\u0003EBQ\u0001\u001f\u0017\u0005\u0002Y\fAa[5mY\")!\u0010\fC\u0001w\u0006iq/Y5u\r>\u0014h)\u001b8jg\"$\"\u0001\u0017?\t\u000buL\b\u0019\u0001@\u0002\u0013QLW.Z8vi6\u001b\bCA\n\u0000\u0013\r\t\t\u0001\u0006\u0002\u0005\u0019>tw\rC\u0004\u0002\u00061\"\t!a\u0002\u0002\u001b]\f\u0017\u000e\u001e$peN#\u0018\r^;t)\u0015A\u0016\u0011BA\u0007\u0011\u001d\tY!a\u0001A\u0002a\u000baa\u001d;biV\u001c\bBB?\u0002\u0004\u0001\u0007a\u0010C\u0004\u0002\u00121\"\t!a\u0005\u0002\u0013\u001d,Go\u0015;biV\u001cH#\u0001-\t\u000f\u0005]A\u0006\"\u0003\u0002\u001a\u0005I1/\u001a;Ti\u0006$Xo\u001d\u000b\u0004=\u0006m\u0001bBA\u0006\u0003+\u0001\r\u0001\u0017")
public class ProcessJob
implements StreamJob,
Logging {
    private final JobModelManager jobModelManager;
    private final Object lock;
    private final ProcessBuilder processBuilder;
    private ApplicationStatus jobStatus;
    private Option<Thread> processThread;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProcessJob processJob = this;
        synchronized (processJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        ProcessJob processJob = this;
        synchronized (processJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public JobModelManager jobModelManager() {
        return this.jobModelManager;
    }

    public Object lock() {
        return this.lock;
    }

    public ProcessBuilder processBuilder() {
        return this.processBuilder;
    }

    public ApplicationStatus jobStatus() {
        return this.jobStatus;
    }

    public void jobStatus_$eq(ApplicationStatus x$1) {
        this.jobStatus = x$1;
    }

    public Option<Thread> processThread() {
        return this.processThread;
    }

    public void processThread_$eq(Option<Thread> x$1) {
        this.processThread = x$1;
    }

    public StreamJob submit() {
        CountDownLatch threadStartCountDownLatch = new CountDownLatch(1);
        this.processThread_$eq((Option<Thread>)new Some((Object)new Thread(this, threadStartCountDownLatch){
            private final /* synthetic */ ProcessJob $outer;
            private final CountDownLatch threadStartCountDownLatch$1;

            public void run() {
                int processExitCode = -1;
                None$ process2 = None$.MODULE$;
                this.$outer.org$apache$samza$job$local$ProcessJob$$setStatus(ApplicationStatus.Running);
                try {
                    try {
                        this.threadStartCountDownLatch$1.countDown();
                        process2 = new Some((Object)this.$outer.processBuilder().start());
                        processExitCode = ((Process)process2.get()).waitFor();
                    }
                    catch (Exception exception) {
                        this.$outer.error((Function0<Object>)new Serializable(this, exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception e$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Encountered an error during job start: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                            }
                            {
                                this.e$1 = e$1;
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        process2.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Process apply(Process p) {
                                return p.destroyForcibly();
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.jobModelManager().stop();
                    this.$outer.org$apache$samza$job$local$ProcessJob$$setStatus(processExitCode == 0 ? ApplicationStatus.SuccessfulFinish : ApplicationStatus.UnsuccessfulFinish);
                    throw throwable;
                }
                this.$outer.jobModelManager().stop();
                this.$outer.org$apache$samza$job$local$ProcessJob$$setStatus(processExitCode == 0 ? ApplicationStatus.SuccessfulFinish : ApplicationStatus.UnsuccessfulFinish);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadStartCountDownLatch$1 = threadStartCountDownLatch$1;
            }
        }));
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting process job";
            }
        });
        ((Thread)this.processThread().get()).start();
        threadStartCountDownLatch.await();
        return this;
    }

    public StreamJob kill() {
        ApplicationStatus applicationStatus = this.getStatus();
        ApplicationStatus applicationStatus2 = ApplicationStatus.Running;
        ApplicationStatus applicationStatus3 = applicationStatus;
        if (!(applicationStatus2 != null ? !applicationStatus2.equals(applicationStatus3) : applicationStatus3 != null)) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Attempting to kill running process job";
                }
            });
            this.processThread().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProcessJob $outer;

                public final void apply(Thread thread) {
                    thread.interrupt();
                    thread.join();
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Process job killed successfully";
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.warn((Function0<Object>)new Serializable(this, applicationStatus){
                public static final long serialVersionUID = 0L;
                private final ApplicationStatus x1$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Ignoring attempt to kill a process job that is not running. Job status is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public ApplicationStatus waitForFinish(long timeoutMs) {
        Predef$.MODULE$.require(timeoutMs >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timeout values must be non-negative";
            }
        });
        this.processThread().foreach((Function1)new Serializable(this, timeoutMs){
            public static final long serialVersionUID = 0L;
            private final long timeoutMs$1;

            public final void apply(Thread thread) {
                thread.join(this.timeoutMs$1);
            }
            {
                this.timeoutMs$1 = timeoutMs$1;
            }
        });
        return this.getStatus();
    }

    public ApplicationStatus waitForStatus(ApplicationStatus status, long timeoutMs) {
        Object object = this.lock();
        synchronized (object) {
            block7: {
                Predef$.MODULE$.require(timeoutMs >= 0L, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Timeout values must be non-negative";
                    }
                });
                long l = timeoutMs;
                if (0L == l) {
                    this.info((Function0<Object>)new Serializable(this, status){
                        public static final long serialVersionUID = 0L;
                        private final ApplicationStatus status$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Waiting for application status %s indefinitely")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$2}));
                        }
                        {
                            this.status$2 = status$2;
                        }
                    });
                    while (true) {
                        ApplicationStatus applicationStatus = this.getStatus();
                        ApplicationStatus applicationStatus2 = status;
                        if (!(applicationStatus != null ? !applicationStatus.equals(applicationStatus2) : applicationStatus2 != null)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        this.lock().wait(0L);
                    }
                }
                this.info((Function0<Object>)new Serializable(this, status, timeoutMs){
                    public static final long serialVersionUID = 0L;
                    private final ApplicationStatus status$2;
                    private final long timeoutMs$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Waiting for application status %s for %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$2, BoxesRunTime.boxToLong((long)this.timeoutMs$2)}));
                    }
                    {
                        this.status$2 = status$2;
                        this.timeoutMs$2 = timeoutMs$2;
                    }
                });
                long startTimeMs = System.currentTimeMillis();
                long remainingTimeoutMs = timeoutMs;
                while (true) {
                    ApplicationStatus applicationStatus = this.getStatus();
                    ApplicationStatus applicationStatus3 = status;
                    if (!(applicationStatus == null ? applicationStatus3 != null : !applicationStatus.equals(applicationStatus3)) || remainingTimeoutMs <= 0L) break;
                    this.lock().wait(remainingTimeoutMs);
                    long elapsedWaitTimeMs = System.currentTimeMillis() - startTimeMs;
                    remainingTimeoutMs = timeoutMs - elapsedWaitTimeMs;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ApplicationStatus applicationStatus = this.getStatus();
            return applicationStatus;
        }
    }

    public ApplicationStatus getStatus() {
        Object object = this.lock();
        synchronized (object) {
            ApplicationStatus applicationStatus = this.jobStatus();
            return applicationStatus;
        }
    }

    public void org$apache$samza$job$local$ProcessJob$$setStatus(ApplicationStatus status) {
        Object object = this.lock();
        synchronized (object) {
            this.info((Function0<Object>)new Serializable(this, status){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProcessJob $outer;
                private final ApplicationStatus status$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Changing process job status from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobStatus(), this.status$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.status$1 = status$1;
                }
            });
            this.jobStatus_$eq(status);
            this.lock().notify();
            return;
        }
    }

    public ProcessJob(CommandBuilder commandBuilder, JobModelManager jobModelManager) {
        this.jobModelManager = jobModelManager;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.processBuilder = ProcessJob$.MODULE$.org$apache$samza$job$local$ProcessJob$$createProcessBuilder(commandBuilder);
        this.jobStatus = ApplicationStatus.New;
        this.processThread = None$.MODULE$;
    }
}

