/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job;

import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MetricsConfig;
import org.apache.samza.config.MetricsConfig$;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemConsumer;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemProducer;
import org.apache.samza.coordinator.stream.messages.Delete;
import org.apache.samza.coordinator.stream.messages.SetConfig;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.JobRunner$;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.StreamJobFactory;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.runtime.ApplicationRunnerOperation;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.CoordinatorStreamUtil$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.apache.samza.util.StreamUtil;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001y<Q!\u0001\u0002\t\u0002-\t\u0011BS8c%Vtg.\u001a:\u000b\u0005\r!\u0011a\u00016pE*\u0011QAB\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u0013){'MU;o]\u0016\u00148cA\u0007\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\tU$\u0018\u000e\\\u0005\u00037a\u0011q\u0001T8hO&tw\rC\u0003\u001e\u001b\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9\u0001%\u0004b\u0001\n\u0003\t\u0013AB*P+J\u001bU)F\u0001#!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u0015;sS:<\u0007BB\u0016\u000eA\u0003%!%A\u0004T\u001fV\u00136)\u0012\u0011\t\u000b5jA\u0011\u0001\u0018\u0002\t5\f\u0017N\u001c\u000b\u0003_I\u0002\"!\u0005\u0019\n\u0005E\u0012\"\u0001B+oSRDQa\r\u0017A\u0002Q\nA!\u0019:hgB\u0019\u0011#N\u001c\n\u0005Y\u0012\"!B!se\u0006L\bC\u0001\u001d<\u001d\t\t\u0012(\u0003\u0002;%\u00051\u0001K]3eK\u001aL!!\u000b\u001f\u000b\u0005i\u0012\u0002\"\u0002 \u000e\t\u0003y\u0014a\u00033p\u001fB,'/\u0019;j_:$2a\f!w\u0011\u0015\tU\b1\u0001C\u0003\u0019\u0011XO\u001c8feB\u0011Ab\u0011\u0004\u0005\u001d\t\u0001AiE\u0002D!YA\u0001BR\"\u0003\u0002\u0003\u0006IaR\u0001\u0007G>tg-[4\u0011\u0005!SU\"A%\u000b\u0005\u0019#\u0011BA&J\u0005\u0019\u0019uN\u001c4jO\")Qd\u0011C\u0001\u001bR\u0011!I\u0014\u0005\u0006\r2\u0003\ra\u0012\u0005\u0006!\u000e#\t!U\u0001\u0004eVtGC\u0001*V!\ta1+\u0003\u0002U\u0005\tI1\u000b\u001e:fC6TuN\u0019\u0005\b->\u0003\n\u00111\u0001X\u00039\u0011Xm]3u\u0015>\u00147i\u001c8gS\u001e\u0004\"!\u0005-\n\u0005e\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\u00067\u000e#\t\u0001X\u0001\u0005W&dG\u000eF\u00010\u0011\u0015q6\t\"\u0001`\u0003\u0019\u0019H/\u0019;vgR\t\u0001\r\u0005\u0002\rC&\u0011!M\u0001\u0002\u0012\u0003B\u0004H.[2bi&|gn\u0015;biV\u001c\b\"\u00023D\t\u0013)\u0017!D4fi*{'MR1di>\u0014\u00180F\u0001g!\taq-\u0003\u0002i\u0005\t\u00012\u000b\u001e:fC6TuN\u0019$bGR|'/\u001f\u0005\bU\u000e\u000b\n\u0011\"\u0001l\u00035\u0011XO\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\tAN\u000b\u0002X[.\na\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003gJ\t!\"\u00198o_R\fG/[8o\u0013\t)\bOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQa^\u001fA\u0002a\f\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u0005edX\"\u0001>\u000b\u0005m$\u0011a\u0002:v]RLW.Z\u0005\u0003{j\u0014!$\u00119qY&\u001c\u0017\r^5p]J+hN\\3s\u001fB,'/\u0019;j_:\u0004")
public class JobRunner
implements Logging {
    public final Config org$apache$samza$job$JobRunner$$config;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static void doOperation(JobRunner jobRunner, ApplicationRunnerOperation applicationRunnerOperation) {
        JobRunner$.MODULE$.doOperation(jobRunner, applicationRunnerOperation);
    }

    public static void main(String[] stringArray) {
        JobRunner$.MODULE$.main(stringArray);
    }

    public static String SOURCE() {
        return JobRunner$.MODULE$.SOURCE();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public StreamJob run(boolean resetJobConfig) {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobRunner $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("config: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$samza$job$JobRunner$$config}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        StreamJobFactory jobFactory = this.getJobFactory();
        CoordinatorStreamSystemConsumer coordinatorSystemConsumer = new CoordinatorStreamSystemConsumer(this.org$apache$samza$job$JobRunner$$config, (MetricsRegistry)new MetricsRegistryMap());
        CoordinatorStreamSystemProducer coordinatorSystemProducer = new CoordinatorStreamSystemProducer(this.org$apache$samza$job$JobRunner$$config, (MetricsRegistry)new MetricsRegistryMap());
        SystemAdmins systemAdmins = new SystemAdmins(this.org$apache$samza$job$JobRunner$$config);
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating coordinator stream";
            }
        });
        SystemStream coordinatorSystemStream = CoordinatorStreamUtil$.MODULE$.getCoordinatorSystemStream(this.org$apache$samza$job$JobRunner$$config);
        SystemAdmin coordinatorSystemAdmin = systemAdmins.getSystemAdmin(coordinatorSystemStream.getSystem());
        String streamName = coordinatorSystemStream.getStream();
        StreamSpec coordinatorSpec = StreamSpec.createCoordinatorStreamSpec((String)streamName, (String)coordinatorSystemStream.getSystem());
        coordinatorSystemAdmin.start();
        if (coordinatorSystemAdmin.createStream(coordinatorSpec)) {
            this.info((Function0<Object>)new Serializable(this, streamName){
                public static final long serialVersionUID = 0L;
                private final String streamName$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Created coordinator stream %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamName$1}));
                }
                {
                    this.streamName$1 = streamName$1;
                }
            });
        } else {
            this.info((Function0<Object>)new Serializable(this, streamName){
                public static final long serialVersionUID = 0L;
                private final String streamName$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Coordinator stream %s already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamName$1}));
                }
                {
                    this.streamName$1 = streamName$1;
                }
            });
        }
        coordinatorSystemAdmin.stop();
        if (resetJobConfig) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Storing config in coordinator stream.";
                }
            });
            coordinatorSystemProducer.register(JobRunner$.MODULE$.SOURCE());
            coordinatorSystemProducer.start();
            coordinatorSystemProducer.writeConfig(JobRunner$.MODULE$.SOURCE(), this.org$apache$samza$job$JobRunner$$config);
        }
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Loading old config from coordinator stream.";
            }
        });
        coordinatorSystemConsumer.register();
        coordinatorSystemConsumer.start();
        coordinatorSystemConsumer.bootstrap();
        coordinatorSystemConsumer.stop();
        Config oldConfig = coordinatorSystemConsumer.getConfig();
        if (resetJobConfig) {
            Set keysToRemove = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(oldConfig.keySet()).asScala()).toSet().diff((GenSet)JavaConverters$.MODULE$.asScalaSetConverter(this.org$apache$samza$job$JobRunner$$config.keySet()).asScala());
            this.info((Function0<Object>)new Serializable(this, keysToRemove){
                public static final long serialVersionUID = 0L;
                private final Set keysToRemove$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deleting old configs that are no longer defined: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keysToRemove$1}));
                }
                {
                    this.keysToRemove$1 = keysToRemove$1;
                }
            });
            keysToRemove.foreach((Function1)new Serializable(this, coordinatorSystemProducer){
                public static final long serialVersionUID = 0L;
                private final CoordinatorStreamSystemProducer coordinatorSystemProducer$1;

                public final void apply(String key) {
                    this.coordinatorSystemProducer$1.send(new Delete(JobRunner$.MODULE$.SOURCE(), key, SetConfig.TYPE));
                }
                {
                    this.coordinatorSystemProducer$1 = coordinatorSystemProducer$1;
                }
            });
        }
        coordinatorSystemProducer.stop();
        if (new JobConfig(this.org$apache$samza$job$JobRunner$$config).getDiagnosticsEnabled()) {
            String DIAGNOSTICS_STREAM_ID = "samza-diagnostics-stream-id";
            String diagnosticsSystemStreamName = (String)new MetricsConfig(this.org$apache$samza$job$JobRunner$$config).getMetricsSnapshotReporterStream(MetricsConfig$.MODULE$.METRICS_SNAPSHOT_REPORTER_NAME_FOR_DIAGNOSTICS()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new ConfigException(new StringBuilder().append((Object)"Missing required config: ").append((Object)String.format(MetricsConfig$.MODULE$.METRICS_SNAPSHOT_REPORTER_STREAM(), MetricsConfig$.MODULE$.METRICS_SNAPSHOT_REPORTER_NAME_FOR_DIAGNOSTICS())).toString());
                }
            });
            SystemStream diagnosticsSystemStream = StreamUtil.getSystemStreamFromNames(diagnosticsSystemStreamName);
            SystemAdmin diagnosticsSysAdmin = systemAdmins.getSystemAdmin(diagnosticsSystemStream.getSystem());
            StreamSpec diagnosticsStreamSpec = new StreamSpec(DIAGNOSTICS_STREAM_ID, diagnosticsSystemStream.getStream(), diagnosticsSystemStream.getSystem(), (Map)new StreamConfig(this.org$apache$samza$job$JobRunner$$config).getStreamProperties(DIAGNOSTICS_STREAM_ID));
            this.info((Function0<Object>)new Serializable(this, diagnosticsSystemStream){
                public static final long serialVersionUID = 0L;
                private final SystemStream diagnosticsSystemStream$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Creating diagnostics stream %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.diagnosticsSystemStream$1.getStream()}));
                }
                {
                    this.diagnosticsSystemStream$1 = diagnosticsSystemStream$1;
                }
            });
            diagnosticsSysAdmin.start();
            if (diagnosticsSysAdmin.createStream(diagnosticsStreamSpec)) {
                this.info((Function0<Object>)new Serializable(this, diagnosticsSystemStream){
                    public static final long serialVersionUID = 0L;
                    private final SystemStream diagnosticsSystemStream$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Created diagnostics stream %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.diagnosticsSystemStream$1.getStream()}));
                    }
                    {
                        this.diagnosticsSystemStream$1 = diagnosticsSystemStream$1;
                    }
                });
            } else {
                this.info((Function0<Object>)new Serializable(this, diagnosticsSystemStream){
                    public static final long serialVersionUID = 0L;
                    private final SystemStream diagnosticsSystemStream$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Diagnostics stream %s already exists")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.diagnosticsSystemStream$1.getStream()}));
                    }
                    {
                        this.diagnosticsSystemStream$1 = diagnosticsSystemStream$1;
                    }
                });
            }
            diagnosticsSysAdmin.stop();
        }
        StreamJob job = jobFactory.getJob(this.org$apache$samza$job$JobRunner$$config);
        job.submit();
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Job submitted. Check status to determine when it is running.";
            }
        });
        return job;
    }

    public boolean run$default$1() {
        return true;
    }

    public void kill() {
        StreamJobFactory jobFactory = this.getJobFactory();
        StreamJob job = jobFactory.getJob(this.org$apache$samza$job$JobRunner$$config).kill();
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kill command executed. Check status to determine when it is terminated.";
            }
        });
    }

    public ApplicationStatus status() {
        StreamJobFactory jobFactory = this.getJobFactory();
        return jobFactory.getJob(this.org$apache$samza$job$JobRunner$$config).getStatus();
    }

    private StreamJobFactory getJobFactory() {
        Option<String> option = JobConfig$.MODULE$.Config2Job(this.org$apache$samza$job$JobRunner$$config).getStreamJobFactoryClass();
        if (option instanceof Some) {
            String factoryClass;
            String string;
            Some some = (Some)option;
            String jobFactoryClass = string = (factoryClass = (String)some.x());
            StreamJobFactory jobFactory = (StreamJobFactory)Class.forName(jobFactoryClass).newInstance();
            this.info((Function0<Object>)new Serializable(this, jobFactoryClass){
                public static final long serialVersionUID = 0L;
                private final String jobFactoryClass$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("job factory: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobFactoryClass$1}));
                }
                {
                    this.jobFactoryClass$1 = jobFactoryClass$1;
                }
            });
            return jobFactory;
        }
        throw new SamzaException("no job factory class defined");
    }

    public JobRunner(Config config) {
        this.org$apache$samza$job$JobRunner$$config = config;
        Logging$class.$init$(this);
    }
}

