/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.executors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class KeyBasedExecutorService
extends AbstractExecutorService {
    final String threadPoolNamePrefix;
    final ExecutorService[] executors;
    final Random rand = new Random();
    final int numThreads;

    public KeyBasedExecutorService(int numThreads) {
        this("KeyBasedExecutor", numThreads);
    }

    public KeyBasedExecutorService(String threadPoolNamePrefix, int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("numThreads has to be greater than 0 in KeyBasedExecutor!");
        }
        this.numThreads = numThreads;
        this.threadPoolNamePrefix = threadPoolNamePrefix;
        this.executors = new ExecutorService[numThreads];
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        for (int i = 0; i < numThreads; ++i) {
            ExecutorService threadPoolExecutorPerQueue;
            this.executors[i] = threadPoolExecutorPerQueue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setThreadFactory(defaultThreadFactory).setNameFormat(this.threadPoolNamePrefix + "-" + i + "-%d").build());
        }
    }

    protected ExecutorService chooseRandomExecutor() {
        if (this.executors.length == 1) {
            return this.executors[0];
        }
        return this.executors[this.rand.nextInt(this.executors.length)];
    }

    protected ExecutorService chooseExecutor(Object object) {
        if (this.executors.length == 1) {
            return this.executors[0];
        }
        return this.executors[KeyBasedExecutorService.signSafeMod(object.hashCode(), this.executors.length)];
    }

    private static int signSafeMod(long dividend, int divisor) {
        int mod = (int)(dividend % (long)divisor);
        if (mod < 0) {
            mod += divisor;
        }
        return mod;
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i].shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> unexecutedRunnables = new ArrayList<Runnable>();
        for (int i = 0; i < this.executors.length; ++i) {
            List<Runnable> unexecutedRunnablesPerQueue = this.executors[i].shutdownNow();
            if (unexecutedRunnablesPerQueue == null || unexecutedRunnablesPerQueue.size() <= 0) continue;
            unexecutedRunnables.addAll(unexecutedRunnablesPerQueue);
        }
        return unexecutedRunnables;
    }

    @Override
    public boolean isShutdown() {
        boolean ret = true;
        for (int i = 0; i < this.executors.length; ++i) {
            ret = ret && this.executors[i].isShutdown();
        }
        return ret;
    }

    @Override
    public boolean isTerminated() {
        boolean ret = true;
        for (int i = 0; i < this.executors.length; ++i) {
            ret = ret && this.executors[i].isTerminated();
        }
        return ret;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = true;
        for (int i = 0; i < this.executors.length; ++i) {
            ret = ret && this.executors[i].awaitTermination(timeout, unit);
        }
        return ret;
    }

    public Future<?> submitOrdered(Object key, Runnable task) {
        return this.chooseExecutor(key).submit(task);
    }

    @Override
    public void execute(Runnable command) {
        this.chooseRandomExecutor().execute(command);
    }
}

