/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.CheckpointManagerFactory;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.ScalaJavaUtil;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;

public class StreamManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamManager.class);
    private final SystemAdmins systemAdmins;

    public StreamManager(Config config) {
        this(new SystemAdmins(config));
    }

    @VisibleForTesting
    StreamManager(SystemAdmins systemAdmins) {
        this.systemAdmins = systemAdmins;
    }

    public void createStreams(List<StreamSpec> streams) {
        HashMultimap streamsGroupedBySystem = HashMultimap.create();
        streams.forEach(arg_0 -> StreamManager.lambda$createStreams$0((Multimap)streamsGroupedBySystem, arg_0));
        for (Map.Entry entry : streamsGroupedBySystem.asMap().entrySet()) {
            String systemName = (String)entry.getKey();
            SystemAdmin systemAdmin = this.systemAdmins.getSystemAdmin(systemName);
            for (StreamSpec stream : (Collection)entry.getValue()) {
                LOGGER.info("Creating stream {} with partitions {} on system {}", new Object[]{stream.getPhysicalName(), stream.getPartitionCount(), systemName});
                systemAdmin.createStream(stream);
            }
        }
    }

    public void start() {
        this.systemAdmins.start();
    }

    public void stop() {
        this.systemAdmins.stop();
    }

    Map<String, Integer> getStreamPartitionCounts(String systemName, Set<String> streamNames) {
        HashMap<String, Integer> streamToPartitionCount = new HashMap<String, Integer>();
        SystemAdmin systemAdmin = this.systemAdmins.getSystemAdmin(systemName);
        if (systemAdmin == null) {
            throw new SamzaException(String.format("System %s does not exist.", systemName));
        }
        Map streamToMetadata = systemAdmin.getSystemStreamMetadata(streamNames);
        streamToMetadata.forEach((stream, data) -> streamToPartitionCount.put((String)stream, data.getSystemStreamPartitionMetadata().size()));
        return streamToPartitionCount;
    }

    public void clearStreamsFromPreviousRun(Config prevConfig) {
        try {
            ApplicationConfig appConfig = new ApplicationConfig(prevConfig);
            LOGGER.info("run.id from previous run is {}", (Object)appConfig.getRunId());
            StreamConfig streamConfig = new StreamConfig(prevConfig);
            Set<StreamSpec> intStreams = JavaConversions.asJavaCollection(streamConfig.getStreamIds()).stream().filter(streamConfig::getIsIntermediateStream).map(id -> new StreamSpec(id, streamConfig.getPhysicalName((String)id), streamConfig.getSystem((String)id))).collect(Collectors.toSet());
            intStreams.forEach(stream -> {
                LOGGER.info("Clear intermediate stream {} in system {}", (Object)stream.getPhysicalName(), (Object)stream.getSystemName());
                this.systemAdmins.getSystemAdmin(stream.getSystemName()).clearStream(stream);
            });
            TaskConfig taskConfig = new TaskConfig(prevConfig);
            String checkpointManagerFactoryClassName = (String)taskConfig.getCheckpointManagerFactory().getOrElse(ScalaJavaUtil.defaultValue(null));
            if (checkpointManagerFactoryClassName != null) {
                CheckpointManager checkpointManager = Util.getObj(checkpointManagerFactoryClassName, CheckpointManagerFactory.class).getCheckpointManager(prevConfig, (MetricsRegistry)new MetricsRegistryMap());
                checkpointManager.clearCheckpoints();
            }
            StorageConfig storageConfig = new StorageConfig(prevConfig);
            for (String store : JavaConversions.asJavaCollection(storageConfig.getStoreNames())) {
                String changelog = (String)storageConfig.getChangelogStream(store).getOrElse(ScalaJavaUtil.defaultValue(null));
                if (changelog == null) continue;
                LOGGER.info("Clear store {} changelog {}", (Object)store, (Object)changelog);
                SystemStream systemStream = StreamUtil.getSystemStreamFromNames(changelog);
                StreamSpec spec = StreamSpec.createChangeLogStreamSpec((String)systemStream.getStream(), (String)systemStream.getSystem(), (int)1);
                this.systemAdmins.getSystemAdmin(spec.getSystemName()).clearStream(spec);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Fail to clear internal streams from previous run. Please clean up manually.", (Throwable)e);
        }
    }

    public static String createUniqueNameForBatch(String stream, Config config) {
        ApplicationConfig appConfig = new ApplicationConfig(config);
        if (appConfig.getAppMode() == ApplicationConfig.ApplicationMode.BATCH && appConfig.getRunId() != null) {
            return stream + "-" + appConfig.getRunId();
        }
        return stream;
    }

    private static /* synthetic */ void lambda$createStreams$0(Multimap streamsGroupedBySystem, StreamSpec streamSpec) {
        streamsGroupedBySystem.put((Object)streamSpec.getSystemName(), (Object)streamSpec);
    }
}

