/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.execution.JobNode;
import org.apache.samza.execution.StreamManager;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.StreamUtil;

public class StreamEdge {
    public static final int PARTITIONS_UNKNOWN = -1;
    private final StreamSpec streamSpec;
    private final boolean isBroadcast;
    private final boolean isIntermediate;
    private final List<JobNode> sourceNodes = new ArrayList<JobNode>();
    private final List<JobNode> targetNodes = new ArrayList<JobNode>();
    private final Config config;
    private final String name;
    private int partitions = -1;

    StreamEdge(StreamSpec streamSpec, boolean isIntermediate, boolean isBroadcast, Config config) {
        this.streamSpec = streamSpec;
        this.isIntermediate = isIntermediate;
        this.isBroadcast = isBroadcast;
        this.config = config;
        if (isBroadcast) {
            this.partitions = 1;
        }
        this.name = StreamUtil.getNameFromSystemStream(this.getSystemStream());
    }

    void addSourceNode(JobNode sourceNode) {
        this.sourceNodes.add(sourceNode);
    }

    void addTargetNode(JobNode targetNode) {
        this.targetNodes.add(targetNode);
    }

    StreamSpec getStreamSpec() {
        String physicalName;
        StreamSpec spec;
        StreamSpec streamSpec = spec = this.partitions == -1 ? this.streamSpec : this.streamSpec.copyWithPartitionCount(this.partitions);
        if (this.isIntermediate && !(physicalName = StreamManager.createUniqueNameForBatch(spec.getPhysicalName(), this.config)).equals(spec.getPhysicalName())) {
            spec = spec.copyWithPhysicalName(physicalName);
        }
        return spec;
    }

    SystemStream getSystemStream() {
        return this.getStreamSpec().toSystemStream();
    }

    List<JobNode> getSourceNodes() {
        return this.sourceNodes;
    }

    List<JobNode> getTargetNodes() {
        return this.targetNodes;
    }

    int getPartitionCount() {
        return this.partitions;
    }

    void setPartitionCount(int partitions) {
        this.partitions = partitions;
    }

    String getName() {
        return this.name;
    }

    boolean isIntermediate() {
        return this.isIntermediate;
    }

    Config generateConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        StreamSpec spec = this.getStreamSpec();
        config.put(String.format(StreamConfig.SYSTEM_FOR_STREAM_ID(), spec.getId()), spec.getSystemName());
        config.put(String.format(StreamConfig.PHYSICAL_NAME_FOR_STREAM_ID(), spec.getId()), spec.getPhysicalName());
        if (this.isIntermediate()) {
            config.put(String.format(StreamConfig.IS_INTERMEDIATE_FOR_STREAM_ID(), spec.getId()), "true");
            config.put(String.format(StreamConfig.DELETE_COMMITTED_MESSAGES_FOR_STREAM_ID(), spec.getId()), "true");
            config.put(String.format(StreamConfig.CONSUMER_OFFSET_DEFAULT_FOR_STREAM_ID(), spec.getId()), "oldest");
            config.put(String.format(StreamConfig.PRIORITY_FOR_STREAM_ID(), spec.getId()), String.valueOf(Integer.MAX_VALUE));
        }
        spec.getConfig().forEach((property, value) -> config.put(String.format(StreamConfig.STREAM_ID_PREFIX(), spec.getId()) + property, (String)value));
        return new MapConfig(config);
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }
}

