/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.util.List;
import java.util.UUID;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemConsumer;
import org.apache.samza.execution.ExecutionPlan;
import org.apache.samza.execution.JobPlanner;
import org.apache.samza.execution.StreamManager;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJobPlanner
extends JobPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteJobPlanner.class);

    public RemoteJobPlanner(ApplicationDescriptorImpl<? extends ApplicationDescriptor> descriptor) {
        super(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobConfig> prepareJobs() {
        String runId = String.valueOf(System.currentTimeMillis()) + "-" + UUID.randomUUID().toString().substring(0, 8);
        LOG.info("The run id for this run is {}", (Object)runId);
        ExecutionPlan plan = this.getExecutionPlan(runId);
        try {
            this.writePlanJsonFile(plan.getPlanAsJson());
        }
        catch (Exception e) {
            throw new SamzaException("Failed to create plan JSON.", (Throwable)e);
        }
        List<JobConfig> jobConfigs = plan.getJobConfigs();
        if (jobConfigs.isEmpty()) {
            throw new SamzaException("No jobs in the plan.");
        }
        JobConfig jobConfig = jobConfigs.get(0);
        StreamManager streamManager = null;
        try {
            streamManager = this.buildAndStartStreamManager((Config)jobConfig);
            if (plan.getApplicationConfig().getAppMode() == ApplicationConfig.ApplicationMode.BATCH) {
                streamManager.clearStreamsFromPreviousRun(this.getConfigFromPrevRun());
            }
            streamManager.createStreams(plan.getIntermediateStreams());
        }
        finally {
            if (streamManager != null) {
                streamManager.stop();
            }
        }
        return jobConfigs;
    }

    private Config getConfigFromPrevRun() {
        CoordinatorStreamSystemConsumer consumer = new CoordinatorStreamSystemConsumer(this.userConfig, (MetricsRegistry)new MetricsRegistryMap());
        consumer.register();
        consumer.start();
        consumer.bootstrap();
        consumer.stop();
        Config cfg = consumer.getConfig();
        LOG.info("Previous config is: " + cfg.toString());
        return cfg;
    }
}

