/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.SendToTableOperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.table.TableSpec;

class OperatorSpecGraphAnalyzer {
    OperatorSpecGraphAnalyzer() {
    }

    public static Multimap<OperatorSpec, InputOperatorSpec> getJoinToInputOperatorSpecs(Collection<InputOperatorSpec> inputOpSpecs) {
        HashMultimap joinToInputOpSpecs = HashMultimap.create();
        Function<OperatorSpec, Iterable<OperatorSpec>> getNextOpSpecs = OperatorSpecGraphAnalyzer.getCustomGetNextOpSpecs(inputOpSpecs);
        for (InputOperatorSpec inputOpSpec : inputOpSpecs) {
            JoinVisitor joinVisitor = new JoinVisitor();
            OperatorSpecGraphAnalyzer.traverse(inputOpSpec, joinVisitor, getNextOpSpecs);
            for (OperatorSpec joinOpSpec : joinVisitor.getJoins()) {
                joinToInputOpSpecs.put((Object)joinOpSpec, (Object)inputOpSpec);
            }
        }
        return joinToInputOpSpecs;
    }

    private static void traverse(OperatorSpec startOpSpec, Consumer<OperatorSpec> visitor, Function<OperatorSpec, Iterable<OperatorSpec>> getNextOpSpecs) {
        visitor.accept(startOpSpec);
        for (OperatorSpec nextOpSpec : getNextOpSpecs.apply(startOpSpec)) {
            OperatorSpecGraphAnalyzer.traverse(nextOpSpec, visitor, getNextOpSpecs);
        }
    }

    private static Function<OperatorSpec, Iterable<OperatorSpec>> getCustomGetNextOpSpecs(Iterable<InputOperatorSpec> inputOpSpecs) {
        TableJoinVisitor tableJoinVisitor = new TableJoinVisitor();
        for (InputOperatorSpec inputOpSpec : inputOpSpecs) {
            OperatorSpecGraphAnalyzer.traverse(inputOpSpec, tableJoinVisitor, opSpec -> opSpec.getRegisteredOperatorSpecs());
        }
        Multimap<SendToTableOperatorSpec, StreamTableJoinOperatorSpec> sendToTableOpSpecToStreamTableJoinOpSpecs = tableJoinVisitor.getSendToTableOpSpecToStreamTableJoinOpSpecs();
        return operatorSpec -> {
            if (operatorSpec instanceof SendToTableOperatorSpec) {
                SendToTableOperatorSpec sendToTableOperatorSpec = (SendToTableOperatorSpec)operatorSpec;
                return Collections.unmodifiableCollection(sendToTableOpSpecToStreamTableJoinOpSpecs.get((Object)sendToTableOperatorSpec));
            }
            return operatorSpec.getRegisteredOperatorSpecs();
        };
    }

    private static class TableJoinVisitor
    implements Consumer<OperatorSpec> {
        private final Multimap<TableSpec, SendToTableOperatorSpec> tableSpecToSendToTableOpSpecs = HashMultimap.create();
        private final Multimap<TableSpec, StreamTableJoinOperatorSpec> tableSpecToStreamTableJoinOpSpecs = HashMultimap.create();

        private TableJoinVisitor() {
        }

        @Override
        public void accept(OperatorSpec opSpec) {
            if (opSpec instanceof SendToTableOperatorSpec) {
                SendToTableOperatorSpec sendToTableOperatorSpec = (SendToTableOperatorSpec)opSpec;
                this.tableSpecToSendToTableOpSpecs.put((Object)sendToTableOperatorSpec.getTableSpec(), (Object)sendToTableOperatorSpec);
            } else if (opSpec instanceof StreamTableJoinOperatorSpec) {
                StreamTableJoinOperatorSpec streamTableJoinOpSpec = (StreamTableJoinOperatorSpec)opSpec;
                this.tableSpecToStreamTableJoinOpSpecs.put((Object)streamTableJoinOpSpec.getTableSpec(), (Object)streamTableJoinOpSpec);
            }
        }

        public Multimap<SendToTableOperatorSpec, StreamTableJoinOperatorSpec> getSendToTableOpSpecToStreamTableJoinOpSpecs() {
            HashMultimap sendToTableOpSpecToStreamTableJoinOpSpecs = HashMultimap.create();
            for (TableSpec tableSpec : this.tableSpecToSendToTableOpSpecs.keySet()) {
                Collection sendToTableOpSpecs = this.tableSpecToSendToTableOpSpecs.get((Object)tableSpec);
                Collection streamTableJoinOpSpecs = this.tableSpecToStreamTableJoinOpSpecs.get((Object)tableSpec);
                for (SendToTableOperatorSpec sendToTableOpSpec : sendToTableOpSpecs) {
                    sendToTableOpSpecToStreamTableJoinOpSpecs.putAll((Object)sendToTableOpSpec, (Iterable)streamTableJoinOpSpecs);
                }
            }
            return Multimaps.unmodifiableMultimap((Multimap)sendToTableOpSpecToStreamTableJoinOpSpecs);
        }
    }

    private static class JoinVisitor
    implements Consumer<OperatorSpec> {
        private Set<OperatorSpec> joinOpSpecs = new HashSet<OperatorSpec>();

        private JoinVisitor() {
        }

        @Override
        public void accept(OperatorSpec opSpec) {
            if (opSpec instanceof JoinOperatorSpec || opSpec instanceof StreamTableJoinOperatorSpec) {
                this.joinOpSpecs.add(opSpec);
            }
        }

        public Set<OperatorSpec> getJoins() {
            return Collections.unmodifiableSet(this.joinOpSpecs);
        }
    }
}

