/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.JobCoordinatorConfig;
import org.apache.samza.coordinator.CoordinationUtils;
import org.apache.samza.coordinator.DistributedLockWithState;
import org.apache.samza.execution.ExecutionPlan;
import org.apache.samza.execution.JobPlanner;
import org.apache.samza.execution.StreamManager;
import org.apache.samza.system.StreamSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJobPlanner
extends JobPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(LocalJobPlanner.class);
    private static final String APPLICATION_RUNNER_PATH_SUFFIX = "/ApplicationRunnerData";
    private final String uid = UUID.randomUUID().toString();

    public LocalJobPlanner(ApplicationDescriptorImpl<? extends ApplicationDescriptor> descriptor) {
        super(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobConfig> prepareJobs() {
        ExecutionPlan plan = this.getExecutionPlan();
        String executionPlanJson = "";
        try {
            executionPlanJson = plan.getPlanAsJson();
        }
        catch (Exception e) {
            throw new SamzaException("Failed to create plan JSON.", (Throwable)e);
        }
        this.writePlanJsonFile(executionPlanJson);
        LOG.info("Execution Plan: \n" + executionPlanJson);
        String planId = String.valueOf(executionPlanJson.hashCode());
        List<JobConfig> jobConfigs = plan.getJobConfigs();
        if (jobConfigs.isEmpty()) {
            throw new SamzaException("No jobs in the plan.");
        }
        JobConfig jobConfig = jobConfigs.get(0);
        StreamManager streamManager = null;
        try {
            streamManager = this.buildAndStartStreamManager((Config)jobConfig);
            this.createStreams(planId, plan.getIntermediateStreams(), streamManager);
        }
        finally {
            if (streamManager != null) {
                streamManager.stop();
            }
        }
        return jobConfigs;
    }

    private void createStreams(String planId, List<StreamSpec> intStreams, StreamManager streamManager) {
        if (intStreams.isEmpty()) {
            LOG.info("Set of intermediate streams is empty. Nothing to create.");
            return;
        }
        LOG.info("A single processor must create the intermediate streams. Processor {} will attempt to acquire the lock.", (Object)this.uid);
        JobCoordinatorConfig jcConfig = new JobCoordinatorConfig(this.userConfig);
        String coordinationId = new ApplicationConfig(this.userConfig).getGlobalAppId() + APPLICATION_RUNNER_PATH_SUFFIX;
        CoordinationUtils coordinationUtils = jcConfig.getCoordinationUtilsFactory().getCoordinationUtils(coordinationId, this.uid, this.userConfig);
        if (coordinationUtils == null) {
            LOG.warn("Processor {} failed to create utils. Each processor will attempt to create streams.", (Object)this.uid);
            streamManager.createStreams(intStreams);
            return;
        }
        DistributedLockWithState lockWithState = coordinationUtils.getLockWithState(planId);
        try {
            if (lockWithState.lockIfNotSet(1000L, TimeUnit.MILLISECONDS)) {
                LOG.info("lock acquired for streams creation by " + this.uid);
                streamManager.createStreams(intStreams);
                lockWithState.unlockAndSet();
            } else {
                LOG.info("Processor {} did not obtain the lock for streams creation. They must've been created by another processor.", (Object)this.uid);
            }
        }
        catch (TimeoutException e) {
            String msg = String.format("Processor {} failed to get the lock for stream initialization", this.uid);
            throw new SamzaException(msg, (Throwable)e);
        }
        finally {
            coordinationUtils.close();
        }
    }
}

