/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.application.LegacyTaskApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.execution.ExecutionPlan;
import org.apache.samza.execution.ExecutionPlanner;
import org.apache.samza.execution.JobNodeConfigurationGenerator;
import org.apache.samza.execution.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(JobPlanner.class);
    protected final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;
    protected final Config userConfig;

    JobPlanner(ApplicationDescriptorImpl<? extends ApplicationDescriptor> descriptor) {
        this.appDesc = descriptor;
        this.userConfig = descriptor.getConfig();
    }

    public abstract List<JobConfig> prepareJobs();

    StreamManager buildAndStartStreamManager(Config config) {
        StreamManager streamManager = new StreamManager(config);
        streamManager.start();
        return streamManager;
    }

    ExecutionPlan getExecutionPlan() {
        return this.getExecutionPlan(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionPlan getExecutionPlan(String runId) {
        HashMap<String, String> allowedUserConfig = new HashMap<String, String>((Map<String, String>)this.userConfig);
        HashMap<String, String> generatedConfig = new HashMap<String, String>();
        if (!LegacyTaskApplication.class.isAssignableFrom(this.appDesc.getAppClass())) {
            if (this.userConfig.containsKey((Object)TaskConfig.INPUT_STREAMS())) {
                LOG.warn("SamzaApplications should not specify task.inputs in configuration. Specify them using InputDescriptors instead. Ignoring configured task.inputs value of " + (String)this.userConfig.get((Object)TaskConfig.INPUT_STREAMS()));
                allowedUserConfig.remove(TaskConfig.INPUT_STREAMS());
            }
            generatedConfig.putAll(this.getGeneratedConfig(runId));
        }
        Config mergedConfig = JobNodeConfigurationGenerator.mergeConfig(allowedUserConfig, generatedConfig);
        StreamManager streamManager = this.buildAndStartStreamManager(mergedConfig);
        try {
            ExecutionPlanner planner = new ExecutionPlanner(mergedConfig, streamManager);
            ExecutionPlan executionPlan = planner.plan(this.appDesc);
            return executionPlan;
        }
        finally {
            streamManager.stop();
        }
    }

    final void writePlanJsonFile(String planJson) {
        try {
            String content = "plan='" + planJson + "'";
            String planPath = System.getenv(ShellCommandConfig.EXECUTION_PLAN_DIR());
            if (planPath != null && !planPath.isEmpty()) {
                File file = new File(planPath + "/plan.json");
                file.setReadable(true, false);
                PrintWriter writer = new PrintWriter(file, "UTF-8");
                writer.println(content);
                writer.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to write execution plan json to file", (Throwable)e);
        }
    }

    private Map<String, String> getGeneratedConfig(String runId) {
        HashMap<String, String> generatedConfig = new HashMap<String, String>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{runId})) {
            generatedConfig.put("app.run.id", runId);
        }
        StreamConfig streamConfig = new StreamConfig(this.userConfig);
        HashSet<String> inputStreamIds = new HashSet<String>(this.appDesc.getInputStreamIds());
        inputStreamIds.removeAll(this.appDesc.getOutputStreamIds());
        ApplicationConfig.ApplicationMode mode = inputStreamIds.stream().allMatch(streamConfig::getIsBounded) ? ApplicationConfig.ApplicationMode.BATCH : ApplicationConfig.ApplicationMode.STREAM;
        generatedConfig.put("app.mode", mode.name());
        Map<String, String> systemStreamConfigs = this.generateSystemStreamConfigs(this.appDesc);
        generatedConfig.putAll(systemStreamConfigs);
        if (!LegacyTaskApplication.class.getName().equals(this.appDesc.getAppClass().getName())) {
            generatedConfig.put("app.class", this.appDesc.getAppClass().getName());
        }
        return generatedConfig;
    }

    private Map<String, String> generateSystemStreamConfigs(ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc) {
        HashMap<String, String> systemStreamConfigs = new HashMap<String, String>();
        appDesc.getInputDescriptors().forEach((key, value) -> systemStreamConfigs.putAll(value.toConfig()));
        appDesc.getOutputDescriptors().forEach((key, value) -> systemStreamConfigs.putAll(value.toConfig()));
        appDesc.getSystemDescriptors().forEach(sd -> systemStreamConfigs.putAll(sd.toConfig()));
        appDesc.getDefaultSystemDescriptor().ifPresent(dsd -> systemStreamConfigs.put(JobConfig.JOB_DEFAULT_SYSTEM(), dsd.getSystemName()));
        return systemStreamConfigs;
    }
}

