/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaTableConfig;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.SerializerConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.execution.JobNode;
import org.apache.samza.execution.StreamEdge;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StatefulOperatorSpec;
import org.apache.samza.operators.spec.StoreDescriptor;
import org.apache.samza.operators.spec.WindowOperatorSpec;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerializableSerde;
import org.apache.samza.table.TableConfigGenerator;
import org.apache.samza.table.TableSpec;
import org.apache.samza.util.MathUtil;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobNodeConfigurationGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JobNodeConfigurationGenerator.class);
    static final String CONFIG_INTERNAL_EXECUTION_PLAN = "samza.internal.execution.plan";

    JobNodeConfigurationGenerator() {
    }

    static Config mergeConfig(Map<String, String> originalConfig, Map<String, String> generatedConfig) {
        HashMap<String, String> mergedConfig = new HashMap<String, String>(generatedConfig);
        originalConfig.forEach((k, v) -> {
            if (generatedConfig.containsKey(k) && !Objects.equals(generatedConfig.get(k), v)) {
                LOG.info("Replacing generated config for key: {} value: {} with original config value: {}", new Object[]{k, generatedConfig.get(k), v});
            }
            mergedConfig.put((String)k, (String)v);
        });
        return Util.rewriteConfig((Config)new MapConfig(mergedConfig));
    }

    JobConfig generateJobConfig(JobNode jobNode, String executionPlanJson) {
        if (jobNode.isLegacyTaskApplication()) {
            return new JobConfig(jobNode.getConfig());
        }
        HashMap<String, String> generatedConfig = new HashMap<String, String>();
        generatedConfig.put(JobConfig.JOB_NAME(), jobNode.getJobName());
        generatedConfig.put(JobConfig.JOB_ID(), jobNode.getJobId());
        Map<String, StreamEdge> inEdges = jobNode.getInEdges();
        Map<String, StreamEdge> outEdges = jobNode.getOutEdges();
        Collection<OperatorSpec> reachableOperators = jobNode.getReachableOperators();
        List<StoreDescriptor> stores = this.getStoreDescriptors(reachableOperators);
        Map<String, TableSpec> reachableTables = this.getReachableTables(reachableOperators, jobNode);
        Config originalConfig = jobNode.getConfig();
        HashSet<String> inputs = new HashSet<String>();
        HashSet<String> broadcastInputs = new HashSet<String>();
        for (StreamEdge inEdge : inEdges.values()) {
            String formattedSystemStream = inEdge.getName();
            if (inEdge.isBroadcast()) {
                broadcastInputs.add(formattedSystemStream + "#0");
                continue;
            }
            inputs.add(formattedSystemStream);
        }
        this.configureBroadcastInputs(generatedConfig, originalConfig, broadcastInputs);
        this.configureWindowInterval(generatedConfig, originalConfig, reachableOperators);
        stores.forEach(sd -> generatedConfig.putAll((Map<String, String>)((Object)sd.getStorageConfigs())));
        generatedConfig.put(CONFIG_INTERNAL_EXECUTION_PLAN, executionPlanJson);
        inEdges.values().stream().filter(StreamEdge::isIntermediate).forEach(intermediateEdge -> generatedConfig.putAll((Map<String, String>)intermediateEdge.generateConfig()));
        this.configureSerdes(generatedConfig, inEdges, outEdges, stores, reachableTables.keySet(), jobNode);
        this.configureTables(generatedConfig, originalConfig, reachableTables, inputs);
        generatedConfig.put(TaskConfig.INPUT_STREAMS(), Joiner.on((char)',').join(inputs));
        LOG.info("Job {} has generated configs {}", (Object)jobNode.getJobNameAndId(), generatedConfig);
        return new JobConfig(JobNodeConfigurationGenerator.mergeConfig((Map<String, String>)originalConfig, generatedConfig));
    }

    private Map<String, TableSpec> getReachableTables(Collection<OperatorSpec> reachableOperators, JobNode jobNode) {
        return jobNode.getTables();
    }

    private void configureBroadcastInputs(Map<String, String> configs, Config config, Set<String> broadcastStreams) {
        if (broadcastStreams.isEmpty()) {
            return;
        }
        String broadcastInputs = (String)config.get((Object)"task.broadcast.inputs");
        if (StringUtils.isNotBlank((CharSequence)broadcastInputs)) {
            broadcastStreams.add(broadcastInputs);
        }
        configs.put("task.broadcast.inputs", Joiner.on((char)',').join(broadcastStreams));
    }

    private void configureWindowInterval(Map<String, String> configs, Config config, Collection<OperatorSpec> reachableOperators) {
        if (!reachableOperators.stream().anyMatch(op -> op.getOpCode() == OperatorSpec.OpCode.WINDOW || op.getOpCode() == OperatorSpec.OpCode.JOIN)) {
            return;
        }
        long triggerInterval = this.computeTriggerInterval(reachableOperators);
        LOG.info("Using triggering interval: {}", (Object)triggerInterval);
        configs.put(TaskConfig.WINDOW_MS(), String.valueOf(triggerInterval));
    }

    private long computeTriggerInterval(Collection<OperatorSpec> reachableOperators) {
        List windowTimerIntervals = reachableOperators.stream().filter(spec -> spec.getOpCode() == OperatorSpec.OpCode.WINDOW).map(spec -> ((WindowOperatorSpec)spec).getDefaultTriggerMs()).collect(Collectors.toList());
        List joinTtlIntervals = reachableOperators.stream().filter(spec -> spec instanceof JoinOperatorSpec).map(spec -> ((JoinOperatorSpec)spec).getTtlMs()).collect(Collectors.toList());
        ArrayList<Long> candidateTimerIntervals = new ArrayList<Long>(joinTtlIntervals);
        candidateTimerIntervals.addAll(windowTimerIntervals);
        if (candidateTimerIntervals.isEmpty()) {
            return -1L;
        }
        return MathUtil.gcd(candidateTimerIntervals);
    }

    private List<StoreDescriptor> getStoreDescriptors(Collection<OperatorSpec> reachableOperators) {
        return reachableOperators.stream().filter(operatorSpec -> operatorSpec instanceof StatefulOperatorSpec).map(operatorSpec -> ((StatefulOperatorSpec)((Object)operatorSpec)).getStoreDescriptors()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void configureTables(Map<String, String> generatedConfig, Config originalConfig, Map<String, TableSpec> tables, Set<String> inputs) {
        generatedConfig.putAll(TableConfigGenerator.generateConfigsForTableSpecs((Config)new MapConfig(generatedConfig), new ArrayList<TableSpec>(tables.values())));
        tables.values().forEach(tableSpec -> {
            List sideInputs = tableSpec.getSideInputs();
            if (sideInputs != null && !sideInputs.isEmpty()) {
                sideInputs.stream().map(sideInput -> StreamUtil.getSystemStreamFromNameOrId(originalConfig, sideInput)).forEach(systemStream -> {
                    inputs.add(StreamUtil.getNameFromSystemStream(systemStream));
                    generatedConfig.put(String.format(StreamConfig.STREAM_PREFIX() + StreamConfig.BOOTSTRAP(), systemStream.getSystem(), systemStream.getStream()), "true");
                });
            }
        });
    }

    private void configureSerdes(Map<String, String> configs, Map<String, StreamEdge> inEdges, Map<String, StreamEdge> outEdges, List<StoreDescriptor> stores, Collection<String> tables, JobNode jobNode) {
        HashMap<String, Serde> streamKeySerdes = new HashMap<String, Serde>();
        HashMap<String, Serde> streamMsgSerdes = new HashMap<String, Serde>();
        inEdges.keySet().forEach(streamId -> this.addSerdes(jobNode.getInputSerdes((String)streamId), (String)streamId, (Map<String, Serde>)streamKeySerdes, (Map<String, Serde>)streamMsgSerdes));
        outEdges.keySet().forEach(streamId -> this.addSerdes(jobNode.getOutputSerde((String)streamId), (String)streamId, (Map<String, Serde>)streamKeySerdes, (Map<String, Serde>)streamMsgSerdes));
        HashMap<String, Serde> storeKeySerdes = new HashMap<String, Serde>();
        HashMap<String, Serde> storeMsgSerdes = new HashMap<String, Serde>();
        stores.forEach(storeDescriptor -> {
            storeKeySerdes.put(storeDescriptor.getStoreName(), storeDescriptor.getKeySerde());
            storeMsgSerdes.put(storeDescriptor.getStoreName(), storeDescriptor.getMsgSerde());
        });
        HashMap<String, Serde> tableKeySerdes = new HashMap<String, Serde>();
        HashMap<String, Serde> tableMsgSerdes = new HashMap<String, Serde>();
        tables.forEach(tableId -> this.addSerdes(jobNode.getTableSerdes((String)tableId), (String)tableId, (Map<String, Serde>)tableKeySerdes, (Map<String, Serde>)tableMsgSerdes));
        HashSet serdes = new HashSet(streamKeySerdes.values());
        serdes.addAll(streamMsgSerdes.values());
        serdes.addAll(storeKeySerdes.values());
        serdes.addAll(storeMsgSerdes.values());
        serdes.addAll(tableKeySerdes.values());
        serdes.addAll(tableMsgSerdes.values());
        SerializableSerde serializableSerde = new SerializableSerde();
        Base64.Encoder base64Encoder = Base64.getEncoder();
        HashMap serdeUUIDs = new HashMap();
        serdes.forEach(serde -> {
            String serdeName = serdeUUIDs.computeIfAbsent(serde, s -> serde.getClass().getSimpleName() + "-" + UUID.randomUUID().toString());
            configs.putIfAbsent(String.format(SerializerConfig.SERDE_SERIALIZED_INSTANCE(), serdeName), base64Encoder.encodeToString(serializableSerde.toBytes((Serializable)serde)));
        });
        streamKeySerdes.forEach((streamId, serde) -> {
            String streamIdPrefix = String.format(StreamConfig.STREAM_ID_PREFIX(), streamId);
            String keySerdeConfigKey = streamIdPrefix + StreamConfig.KEY_SERDE();
            configs.put(keySerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
        streamMsgSerdes.forEach((streamId, serde) -> {
            String streamIdPrefix = String.format(StreamConfig.STREAM_ID_PREFIX(), streamId);
            String valueSerdeConfigKey = streamIdPrefix + StreamConfig.MSG_SERDE();
            configs.put(valueSerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
        storeKeySerdes.forEach((storeName, serde) -> {
            String keySerdeConfigKey = String.format(StorageConfig.KEY_SERDE(), storeName);
            configs.put(keySerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
        storeMsgSerdes.forEach((storeName, serde) -> {
            String msgSerdeConfigKey = String.format(StorageConfig.MSG_SERDE(), storeName);
            configs.put(msgSerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
        tableKeySerdes.forEach((tableId, serde) -> {
            String keySerdeConfigKey = String.format(JavaTableConfig.TABLE_KEY_SERDE, tableId);
            configs.put(keySerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
        tableMsgSerdes.forEach((tableId, serde) -> {
            String valueSerdeConfigKey = String.format(JavaTableConfig.TABLE_VALUE_SERDE, tableId);
            configs.put(valueSerdeConfigKey, (String)serdeUUIDs.get(serde));
        });
    }

    private void addSerdes(KV<Serde, Serde> serdes, String streamId, Map<String, Serde> keySerdeMap, Map<String, Serde> msgSerdeMap) {
        if (serdes != null) {
            if (serdes.getKey() != null && !(serdes.getKey() instanceof NoOpSerde)) {
                keySerdeMap.put(streamId, (Serde)serdes.getKey());
            }
            if (serdes.getValue() != null && !(serdes.getValue() instanceof NoOpSerde)) {
                msgSerdeMap.put(streamId, (Serde)serdes.getValue());
            }
        }
    }
}

