/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.application.LegacyTaskApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.execution.JobNodeConfigurationGenerator;
import org.apache.samza.execution.StreamEdge;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.TableSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobNode {
    private static final Logger log = LoggerFactory.getLogger(JobNode.class);
    private final String jobName;
    private final String jobId;
    private final String jobNameAndId;
    private final Config config;
    private final JobNodeConfigurationGenerator configGenerator;
    private final Map<String, StreamEdge> inEdges = new HashMap<String, StreamEdge>();
    private final Map<String, StreamEdge> outEdges = new HashMap<String, StreamEdge>();
    private final Map<String, TableSpec> tables = new HashMap<String, TableSpec>();
    private final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;

    JobNode(String jobName, String jobId, Config config, ApplicationDescriptorImpl appDesc, JobNodeConfigurationGenerator configureGenerator) {
        this.jobName = jobName;
        this.jobId = jobId;
        this.jobNameAndId = JobNode.createJobNameAndId(jobName, jobId);
        this.config = config;
        this.appDesc = appDesc;
        this.configGenerator = configureGenerator;
    }

    static String createJobNameAndId(String jobName, String jobId) {
        return String.format("%s-%s", jobName, jobId);
    }

    String getJobNameAndId() {
        return this.jobNameAndId;
    }

    String getJobName() {
        return this.jobName;
    }

    String getJobId() {
        return this.jobId;
    }

    Config getConfig() {
        return this.config;
    }

    void addInEdge(StreamEdge in) {
        this.inEdges.put(in.getStreamSpec().getId(), in);
    }

    void addOutEdge(StreamEdge out) {
        this.outEdges.put(out.getStreamSpec().getId(), out);
    }

    void addTable(TableSpec tableSpec) {
        this.tables.put(tableSpec.getId(), tableSpec);
    }

    Map<String, StreamEdge> getInEdges() {
        return this.inEdges;
    }

    Map<String, StreamEdge> getOutEdges() {
        return this.outEdges;
    }

    Map<String, TableSpec> getTables() {
        return this.tables;
    }

    JobConfig generateConfig(String executionPlanJson) {
        return this.configGenerator.generateJobConfig(this, executionPlanJson);
    }

    KV<Serde, Serde> getInputSerdes(String streamId) {
        if (!this.inEdges.containsKey(streamId)) {
            return null;
        }
        return this.appDesc.getStreamSerdes(streamId);
    }

    KV<Serde, Serde> getOutputSerde(String streamId) {
        if (!this.outEdges.containsKey(streamId)) {
            return null;
        }
        return this.appDesc.getStreamSerdes(streamId);
    }

    Collection<OperatorSpec> getReachableOperators() {
        Set<OperatorSpec> inputOperatorsInJobNode = this.inEdges.values().stream().map(inEdge -> this.appDesc.getInputOperators().get(inEdge.getStreamSpec().getId())).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<OperatorSpec> reachableOperators = new HashSet<OperatorSpec>();
        this.findReachableOperators(inputOperatorsInJobNode, reachableOperators);
        return reachableOperators;
    }

    Set<String> getNextOperatorIds(String streamId) {
        if (!this.appDesc.getInputOperators().containsKey(streamId) || !this.inEdges.containsKey(streamId)) {
            return new HashSet<String>();
        }
        return this.appDesc.getInputOperators().get(streamId).getRegisteredOperatorSpecs().stream().map(op -> op.getOpId()).collect(Collectors.toSet());
    }

    InputOperatorSpec getInputOperator(String inputStreamId) {
        if (!this.inEdges.containsKey(inputStreamId)) {
            return null;
        }
        return this.appDesc.getInputOperators().get(inputStreamId);
    }

    boolean isLegacyTaskApplication() {
        return LegacyTaskApplication.class.isAssignableFrom(this.appDesc.getAppClass());
    }

    KV<Serde, Serde> getTableSerdes(String tableId) {
        return this.appDesc.getTableSerdes(tableId);
    }

    private void findReachableOperators(Collection<OperatorSpec> inputOperatorsInJobNode, Set<OperatorSpec> reachableOperators) {
        inputOperatorsInJobNode.forEach(op -> {
            if (reachableOperators.contains(op)) {
                return;
            }
            reachableOperators.add((OperatorSpec)op);
            this.findReachableOperators(op.getRegisteredOperatorSpecs(), reachableOperators);
        });
    }
}

