/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.execution.JobGraph;
import org.apache.samza.execution.JobNode;
import org.apache.samza.execution.StreamEdge;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputOperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.operators.spec.PartitionByOperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.table.TableSpec;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

class JobGraphJsonGenerator {
    JobGraphJsonGenerator() {
    }

    String toJson(JobGraph jobGraph) throws Exception {
        JobGraphJson jobGraphJson = new JobGraphJson();
        ApplicationConfig appConfig = jobGraph.getApplicationConfig();
        jobGraphJson.applicationName = appConfig.getAppName();
        jobGraphJson.applicationId = appConfig.getAppId();
        jobGraphJson.sourceStreams = new HashMap<String, StreamEdgeJson>();
        jobGraphJson.sinkStreams = new HashMap<String, StreamEdgeJson>();
        jobGraphJson.intermediateStreams = new HashMap<String, StreamEdgeJson>();
        jobGraphJson.tables = new HashMap<String, TableSpecJson>();
        jobGraph.getInputStreams().forEach(e -> this.buildStreamEdgeJson((StreamEdge)e, jobGraphJson.sourceStreams));
        jobGraph.getOutputStreams().forEach(e -> this.buildStreamEdgeJson((StreamEdge)e, jobGraphJson.sinkStreams));
        jobGraph.getIntermediateStreamEdges().forEach(e -> this.buildStreamEdgeJson((StreamEdge)e, jobGraphJson.intermediateStreams));
        jobGraph.getTables().forEach(t -> this.buildTableJson((TableSpec)t, jobGraphJson.tables));
        jobGraphJson.jobs = jobGraph.getJobNodes().stream().map(this::buildJobNodeJson).collect(Collectors.toList());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)out, (Object)jobGraphJson);
        return new String(out.toByteArray());
    }

    private void updateOperatorGraphJson(OperatorSpec operatorSpec, OperatorGraphJson opGraph) {
        if (operatorSpec == null) {
            return;
        }
        if (operatorSpec.getOpCode() != OperatorSpec.OpCode.INPUT) {
            opGraph.operators.put(operatorSpec.getOpId(), this.operatorToMap(operatorSpec));
        }
        Collection specs = operatorSpec.getRegisteredOperatorSpecs();
        specs.forEach(opSpec -> this.updateOperatorGraphJson((OperatorSpec)opSpec, opGraph));
    }

    private Map<String, Object> operatorToMap(OperatorSpec spec) {
        TableSpec tableSpec;
        OutputStreamImpl<Object> outputStream;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opCode", spec.getOpCode().name());
        map.put("opId", spec.getOpId());
        map.put("sourceLocation", spec.getSourceLocation());
        Collection nextOperators = spec.getRegisteredOperatorSpecs();
        map.put("nextOperatorIds", nextOperators.stream().map(OperatorSpec::getOpId).collect(Collectors.toSet()));
        if (spec instanceof OutputOperatorSpec) {
            outputStream = ((OutputOperatorSpec)spec).getOutputStream();
            map.put("outputStreamId", outputStream.getStreamId());
        } else if (spec instanceof PartitionByOperatorSpec) {
            outputStream = ((PartitionByOperatorSpec)spec).getOutputStream();
            map.put("outputStreamId", outputStream.getStreamId());
        }
        if (spec instanceof StreamTableJoinOperatorSpec) {
            tableSpec = ((StreamTableJoinOperatorSpec)spec).getTableSpec();
            map.put("tableId", tableSpec.getId());
        }
        if (spec instanceof StreamTableJoinOperatorSpec) {
            tableSpec = ((StreamTableJoinOperatorSpec)spec).getTableSpec();
            map.put("tableId", tableSpec.getId());
        }
        if (spec instanceof JoinOperatorSpec) {
            map.put("ttlMs", ((JoinOperatorSpec)spec).getTtlMs());
        }
        return map;
    }

    private JobNodeJson buildJobNodeJson(JobNode jobNode) {
        JobNodeJson job = new JobNodeJson();
        job.jobName = jobNode.getJobName();
        job.jobId = jobNode.getJobId();
        job.operatorGraph = this.buildOperatorGraphJson(jobNode);
        return job;
    }

    private OperatorGraphJson buildOperatorGraphJson(JobNode jobNode) {
        OperatorGraphJson opGraph = new OperatorGraphJson();
        opGraph.inputStreams = new ArrayList<StreamJson>();
        jobNode.getInEdges().values().forEach(inStream -> {
            StreamJson inputJson = new StreamJson();
            opGraph.inputStreams.add(inputJson);
            inputJson.streamId = inStream.getStreamSpec().getId();
            inputJson.nextOperatorIds = jobNode.getNextOperatorIds(inputJson.streamId);
            this.updateOperatorGraphJson(jobNode.getInputOperator(inputJson.streamId), opGraph);
        });
        opGraph.outputStreams = new ArrayList<StreamJson>();
        jobNode.getOutEdges().values().forEach(outStream -> {
            StreamJson outputJson = new StreamJson();
            outputJson.streamId = outStream.getStreamSpec().getId();
            opGraph.outputStreams.add(outputJson);
        });
        return opGraph;
    }

    private StreamEdgeJson buildStreamEdgeJson(StreamEdge edge, Map<String, StreamEdgeJson> streamEdges) {
        String streamId = edge.getStreamSpec().getId();
        StreamEdgeJson edgeJson = streamEdges.get(streamId);
        if (edgeJson == null) {
            edgeJson = new StreamEdgeJson();
            StreamSpecJson streamSpecJson = new StreamSpecJson();
            streamSpecJson.id = streamId;
            streamSpecJson.systemName = edge.getStreamSpec().getSystemName();
            streamSpecJson.physicalName = edge.getStreamSpec().getPhysicalName();
            streamSpecJson.partitionCount = edge.getPartitionCount();
            edgeJson.streamSpec = streamSpecJson;
            ArrayList<String> sourceJobs = new ArrayList<String>();
            edge.getSourceNodes().forEach(jobNode -> sourceJobs.add(jobNode.getJobName()));
            edgeJson.sourceJobs = sourceJobs;
            ArrayList<String> targetJobs = new ArrayList<String>();
            edge.getTargetNodes().forEach(jobNode -> targetJobs.add(jobNode.getJobName()));
            edgeJson.targetJobs = targetJobs;
            streamEdges.put(streamId, edgeJson);
        }
        return edgeJson;
    }

    private TableSpecJson buildTableJson(TableSpec tableSpec, Map<String, TableSpecJson> tableSpecs) {
        String tableId = tableSpec.getId();
        return tableSpecs.computeIfAbsent(tableId, k -> this.buildTableJson(tableSpec));
    }

    private TableSpecJson buildTableJson(TableSpec tableSpec) {
        TableSpecJson tableSpecJson = new TableSpecJson();
        tableSpecJson.id = tableSpec.getId();
        tableSpecJson.tableProviderFactory = tableSpec.getTableProviderFactoryClassName();
        tableSpecJson.config = tableSpec.getConfig();
        return tableSpecJson;
    }

    static final class JobGraphJson {
        @JsonProperty(value="jobs")
        List<JobNodeJson> jobs;
        @JsonProperty(value="sourceStreams")
        Map<String, StreamEdgeJson> sourceStreams;
        @JsonProperty(value="sinkStreams")
        Map<String, StreamEdgeJson> sinkStreams;
        @JsonProperty(value="intermediateStreams")
        Map<String, StreamEdgeJson> intermediateStreams;
        @JsonProperty(value="tables")
        Map<String, TableSpecJson> tables;
        @JsonProperty(value="applicationName")
        String applicationName;
        @JsonProperty(value="applicationId")
        String applicationId;

        JobGraphJson() {
        }
    }

    static final class JobNodeJson {
        @JsonProperty(value="jobName")
        String jobName;
        @JsonProperty(value="jobId")
        String jobId;
        @JsonProperty(value="operatorGraph")
        OperatorGraphJson operatorGraph;

        JobNodeJson() {
        }
    }

    static final class StreamJson {
        @JsonProperty(value="streamId")
        String streamId;
        @JsonProperty(value="nextOperatorIds")
        Set<String> nextOperatorIds = new HashSet<String>();

        StreamJson() {
        }
    }

    static final class OperatorGraphJson {
        @JsonProperty(value="inputStreams")
        List<StreamJson> inputStreams;
        @JsonProperty(value="outputStreams")
        List<StreamJson> outputStreams;
        @JsonProperty(value="operators")
        Map<String, Map<String, Object>> operators = new HashMap<String, Map<String, Object>>();

        OperatorGraphJson() {
        }
    }

    static final class StreamEdgeJson {
        @JsonProperty(value="streamSpec")
        StreamSpecJson streamSpec;
        @JsonProperty(value="sourceJobs")
        List<String> sourceJobs;
        @JsonProperty(value="targetJobs")
        List<String> targetJobs;

        StreamEdgeJson() {
        }
    }

    static final class TableSpecJson {
        @JsonProperty(value="id")
        String id;
        @JsonProperty(value="tableProviderFactory")
        String tableProviderFactory;
        @JsonProperty(value="config")
        Map<String, String> config;

        TableSpecJson() {
        }
    }

    static final class StreamSpecJson {
        @JsonProperty(value="id")
        String id;
        @JsonProperty(value="systemName")
        String systemName;
        @JsonProperty(value="physicalName")
        String physicalName;
        @JsonProperty(value="partitionCount")
        int partitionCount;

        StreamSpecJson() {
        }
    }
}

