/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.execution;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.execution.ExecutionPlan;
import org.apache.samza.execution.JobGraphJsonGenerator;
import org.apache.samza.execution.JobNode;
import org.apache.samza.execution.JobNodeConfigurationGenerator;
import org.apache.samza.execution.StreamEdge;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.table.TableSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobGraph
implements ExecutionPlan {
    private static final Logger log = LoggerFactory.getLogger(JobGraph.class);
    private final Map<String, JobNode> nodes = new HashMap<String, JobNode>();
    private final Map<String, StreamEdge> edges = new HashMap<String, StreamEdge>();
    private final Set<StreamEdge> inputStreams = new HashSet<StreamEdge>();
    private final Set<StreamEdge> outputStreams = new HashSet<StreamEdge>();
    private final Set<StreamEdge> intermediateStreams = new HashSet<StreamEdge>();
    private final Set<StreamEdge> sideInputStreams = new HashSet<StreamEdge>();
    private final Set<TableSpec> tables = new HashSet<TableSpec>();
    private final Config config;
    private final JobGraphJsonGenerator jsonGenerator;
    private final JobNodeConfigurationGenerator configGenerator;
    private final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;

    JobGraph(Config config, ApplicationDescriptorImpl appDesc) {
        this.config = config;
        this.appDesc = appDesc;
        this.jsonGenerator = new JobGraphJsonGenerator();
        this.configGenerator = new JobNodeConfigurationGenerator();
    }

    @Override
    public List<JobConfig> getJobConfigs() {
        String json = "";
        try {
            json = this.getPlanAsJson();
        }
        catch (Exception e) {
            log.warn("Failed to generate plan JSON", (Throwable)e);
        }
        String planJson = json;
        return this.getJobNodes().stream().map(n -> n.generateConfig(planJson)).collect(Collectors.toList());
    }

    @Override
    public List<StreamSpec> getIntermediateStreams() {
        return this.getIntermediateStreamEdges().stream().map(StreamEdge::getStreamSpec).collect(Collectors.toList());
    }

    @Override
    public String getPlanAsJson() throws Exception {
        return this.jsonGenerator.toJson(this);
    }

    @Override
    public ApplicationConfig getApplicationConfig() {
        return new ApplicationConfig(this.config);
    }

    void addInputStream(StreamSpec streamSpec, JobNode node) {
        StreamEdge edge = this.getOrCreateStreamEdge(streamSpec);
        edge.addTargetNode(node);
        node.addInEdge(edge);
        this.inputStreams.add(edge);
    }

    void addOutputStream(StreamSpec streamSpec, JobNode node) {
        StreamEdge edge = this.getOrCreateStreamEdge(streamSpec);
        edge.addSourceNode(node);
        node.addOutEdge(edge);
        this.outputStreams.add(edge);
    }

    void addIntermediateStream(StreamSpec streamSpec, JobNode from, JobNode to) {
        StreamEdge edge = this.getOrCreateStreamEdge(streamSpec, true);
        edge.addSourceNode(from);
        edge.addTargetNode(to);
        from.addOutEdge(edge);
        to.addInEdge(edge);
        this.intermediateStreams.add(edge);
    }

    void addTable(TableSpec tableSpec, JobNode node) {
        this.tables.add(tableSpec);
        node.addTable(tableSpec);
    }

    void addSideInputStream(StreamSpec streamSpec) {
        StreamEdge edge = this.getOrCreateStreamEdge(streamSpec, false);
        this.sideInputStreams.add(edge);
    }

    JobNode getOrCreateJobNode(String jobName, String jobId) {
        String nodeId = JobNode.createJobNameAndId(jobName, jobId);
        return this.nodes.computeIfAbsent(nodeId, k -> new JobNode(jobName, jobId, this.config, this.appDesc, this.configGenerator));
    }

    StreamEdge getOrCreateStreamEdge(StreamSpec streamSpec) {
        return this.getOrCreateStreamEdge(streamSpec, false);
    }

    ApplicationDescriptorImpl<? extends ApplicationDescriptor> getApplicationDescriptorImpl() {
        return this.appDesc;
    }

    StreamEdge getStreamEdge(String streamId) {
        return this.edges.get(streamId);
    }

    List<JobNode> getJobNodes() {
        List<JobNode> sortedNodes = this.topologicalSort();
        return Collections.unmodifiableList(sortedNodes);
    }

    Set<StreamEdge> getInputStreams() {
        return Collections.unmodifiableSet(this.inputStreams);
    }

    Set<StreamEdge> getSideInputStreams() {
        return Collections.unmodifiableSet(this.sideInputStreams);
    }

    Set<StreamEdge> getOutputStreams() {
        return Collections.unmodifiableSet(this.outputStreams);
    }

    Set<TableSpec> getTables() {
        return Collections.unmodifiableSet(this.tables);
    }

    Set<StreamEdge> getIntermediateStreamEdges() {
        return Collections.unmodifiableSet(this.intermediateStreams);
    }

    void validate() {
        this.validateInputStreams();
        this.validateOutputStreams();
        this.validateInternalStreams();
        this.validateReachability();
    }

    private StreamEdge getOrCreateStreamEdge(StreamSpec streamSpec, boolean isIntermediate) {
        String streamId = streamSpec.getId();
        StreamEdge edge = this.edges.get(streamId);
        if (edge == null) {
            boolean isBroadcast = this.appDesc.getIntermediateBroadcastStreamIds().contains(streamId);
            edge = new StreamEdge(streamSpec, isIntermediate, isBroadcast, this.config);
            this.edges.put(streamId, edge);
        }
        return edge;
    }

    private void validateInputStreams() {
        this.inputStreams.forEach(edge -> {
            if (!edge.getSourceNodes().isEmpty()) {
                throw new IllegalArgumentException(String.format("Source stream %s should not have producers.", edge.getName()));
            }
            if (edge.getTargetNodes().isEmpty()) {
                throw new IllegalArgumentException(String.format("Source stream %s should have consumers.", edge.getName()));
            }
        });
    }

    private void validateOutputStreams() {
        this.outputStreams.forEach(edge -> {
            if (!edge.getTargetNodes().isEmpty()) {
                throw new IllegalArgumentException(String.format("Sink stream %s should not have consumers", edge.getName()));
            }
            if (edge.getSourceNodes().isEmpty()) {
                throw new IllegalArgumentException(String.format("Sink stream %s should have producers", edge.getName()));
            }
        });
    }

    private void validateInternalStreams() {
        HashSet<StreamEdge> internalEdges = new HashSet<StreamEdge>(this.edges.values());
        internalEdges.removeAll(this.inputStreams);
        internalEdges.removeAll(this.sideInputStreams);
        internalEdges.removeAll(this.outputStreams);
        internalEdges.forEach(edge -> {
            if (edge.getSourceNodes().isEmpty() || edge.getTargetNodes().isEmpty()) {
                throw new IllegalArgumentException(String.format("Internal stream %s should have both producers and consumers", edge.getName()));
            }
        });
    }

    private void validateReachability() {
        Set<JobNode> reachable = this.findReachable();
        if (reachable.size() != this.nodes.size()) {
            HashSet<JobNode> unreachable = new HashSet<JobNode>(this.nodes.values());
            unreachable.removeAll(reachable);
            throw new IllegalArgumentException(String.format("Jobs %s cannot be reached from Sources.", String.join((CharSequence)", ", unreachable.stream().map(JobNode::getJobNameAndId).collect(Collectors.toList()))));
        }
    }

    Set<JobNode> findReachable() {
        ArrayDeque queue = new ArrayDeque();
        HashSet<JobNode> visited = new HashSet<JobNode>();
        this.inputStreams.forEach(input -> {
            List<JobNode> next = input.getTargetNodes();
            queue.addAll(next);
            visited.addAll(next);
        });
        while (!queue.isEmpty()) {
            JobNode node = (JobNode)queue.poll();
            node.getOutEdges().values().stream().flatMap(edge -> edge.getTargetNodes().stream()).forEach(target -> {
                if (!visited.contains(target)) {
                    visited.add((JobNode)target);
                    queue.offer(target);
                }
            });
        }
        return visited;
    }

    List<JobNode> topologicalSort() {
        Collection<JobNode> pnodes = this.nodes.values();
        if (pnodes.size() == 1) {
            return new ArrayList<JobNode>(pnodes);
        }
        ArrayDeque<JobNode> q = new ArrayDeque<JobNode>();
        HashMap indegree = new HashMap();
        HashSet<JobNode> visited = new HashSet<JobNode>();
        pnodes.forEach(node -> {
            String nid = node.getJobNameAndId();
            long degree = node.getInEdges().values().stream().filter(e -> !this.inputStreams.contains(e)).count();
            indegree.put(nid, degree);
            if (degree == 0L) {
                q.add((JobNode)node);
                visited.add((JobNode)node);
            }
        });
        ArrayList<JobNode> sortedNodes = new ArrayList<JobNode>();
        HashSet reachable = new HashSet();
        while (sortedNodes.size() < pnodes.size()) {
            while (!q.isEmpty()) {
                JobNode node2 = (JobNode)q.poll();
                sortedNodes.add(node2);
                node2.getOutEdges().values().stream().flatMap(edge -> edge.getTargetNodes().stream()).forEach(n -> {
                    String nid = n.getJobNameAndId();
                    Long degree = (Long)indegree.get(nid) - 1L;
                    indegree.put(nid, degree);
                    if (degree == 0L && !visited.contains(n)) {
                        q.add((JobNode)n);
                        visited.add((JobNode)n);
                    }
                    reachable.add(n);
                });
            }
            if (sortedNodes.size() >= pnodes.size()) continue;
            reachable.removeAll(sortedNodes);
            if (!reachable.isEmpty()) {
                long min = Long.MAX_VALUE;
                JobNode minNode = null;
                for (JobNode node3 : reachable) {
                    Long degree = (Long)indegree.get(node3.getJobNameAndId());
                    if (degree >= min) continue;
                    min = degree;
                    minNode = node3;
                }
                q.add(minNode);
                visited.add(minNode);
                continue;
            }
            JobNode nextNode = this.inputStreams.stream().flatMap(input -> input.getTargetNodes().stream()).filter(node -> !visited.contains(node)).findAny().get();
            q.add(nextNode);
            visited.add(nextNode);
        }
        return sortedNodes;
    }
}

