/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.diagnostics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DiagnosticsExceptionEvent {
    private long timestamp;
    private String exceptionType;
    private String exceptionMessage;
    private String compactExceptionStackTrace;
    private Map mdcMap;

    public DiagnosticsExceptionEvent() {
    }

    public DiagnosticsExceptionEvent(long timestampMillis, Throwable throwable, Map mdcMap) {
        this.exceptionType = throwable.getClass().getName();
        this.exceptionMessage = throwable.getMessage();
        this.compactExceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        this.timestamp = timestampMillis;
        this.mdcMap = new HashMap(mdcMap);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public Map getMdcMap() {
        return this.mdcMap;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getCompactExceptionStackTrace() {
        return this.compactExceptionStackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticsExceptionEvent that = (DiagnosticsExceptionEvent)o;
        return this.timestamp == that.timestamp && Objects.equals(this.exceptionType, that.exceptionType) && Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.compactExceptionStackTrace, that.compactExceptionStackTrace) && Objects.equals(this.mdcMap, that.mdcMap);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.exceptionType, this.exceptionMessage, this.compactExceptionStackTrace, this.mdcMap);
    }
}

