/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamMessage {
    public static final int VERSION_INDEX = 0;
    public static final int TYPE_INDEX = 1;
    public static final int KEY_INDEX = 2;
    private static final Logger log = LoggerFactory.getLogger(CoordinatorStreamMessage.class);
    public static final int VERSION = 1;
    private final Object[] keyArray;
    private final Map<String, Object> messageMap;
    private boolean isDelete;

    public CoordinatorStreamMessage(CoordinatorStreamMessage message) {
        this(message.getKeyArray(), message.getMessageMap());
    }

    public CoordinatorStreamMessage(Object[] keyArray, Map<String, Object> messageMap) {
        this.keyArray = keyArray;
        this.messageMap = messageMap;
        this.isDelete = messageMap == null;
    }

    public CoordinatorStreamMessage(String source) {
        this(source, new Object[]{1, null, null}, new HashMap<String, Object>());
    }

    public CoordinatorStreamMessage(String source, Object[] keyArray, Map<String, Object> messageMap) {
        this(keyArray, messageMap);
        if (!this.isDelete) {
            this.messageMap.put("values", new HashMap());
            this.setSource(source);
            this.setUsername(System.getProperty("user.name"));
            this.setTimestamp(System.currentTimeMillis());
            try {
                this.setHost(Util.getLocalHost().getHostAddress());
            }
            catch (Exception e) {
                log.warn("Unable to retrieve host for current machine. Setting coordinator stream message host field to an empty string.");
                this.setHost("");
            }
        }
        this.setVersion(1);
    }

    protected void setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    protected void setHost(String host) {
        this.messageMap.put("host", host);
    }

    protected void setUsername(String username) {
        this.messageMap.put("username", username);
    }

    protected void setSource(String source) {
        this.messageMap.put("source", source);
    }

    protected void setTimestamp(long timestamp) {
        this.messageMap.put("timestamp", timestamp);
    }

    protected void setVersion(int version) {
        this.keyArray[0] = version;
    }

    protected void setType(String type) {
        this.keyArray[1] = type;
    }

    protected void setKey(String key) {
        this.keyArray[2] = key;
    }

    protected Map<String, String> getMessageValues() {
        return (Map)this.messageMap.get("values");
    }

    protected String getMessageValue(String key) {
        return this.getMessageValues().get(key);
    }

    protected void putMessageValue(String key, String value) {
        this.getMessageValues().put(key, value);
    }

    public String getType() {
        return (String)this.keyArray[1];
    }

    public Object[] getKeyArray() {
        return this.keyArray;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public String getUsername() {
        return (String)this.messageMap.get("username");
    }

    public long getTimestamp() {
        return (Long)this.messageMap.get("timestamp");
    }

    public Map<String, Object> getMessageMap() {
        if (!this.isDelete) {
            HashMap<String, Object> immutableMap = new HashMap<String, Object>(this.messageMap);
            immutableMap.put("values", Collections.unmodifiableMap(this.getMessageValues()));
            return Collections.unmodifiableMap(immutableMap);
        }
        return null;
    }

    public String getSource() {
        return (String)this.messageMap.get("source");
    }

    public int getVersion() {
        return (Integer)this.keyArray[0];
    }

    public String getKey() {
        return (String)this.keyArray[2];
    }

    public String toString() {
        return "CoordinatorStreamMessage [keyArray=" + Arrays.toString(this.keyArray) + ", messageMap=" + this.messageMap + ", isDelete=" + this.isDelete + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isDelete ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.keyArray);
        result = 31 * result + (this.messageMap == null ? 0 : (this.getMessageValues() == null ? 0 : this.getMessageValues().hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoordinatorStreamMessage)) {
            return false;
        }
        CoordinatorStreamMessage other = (CoordinatorStreamMessage)obj;
        if (this.isDelete != other.isDelete) {
            return false;
        }
        if (!Arrays.equals(this.keyArray, other.keyArray)) {
            return false;
        }
        return !(this.messageMap == null ? other.messageMap != null : !this.getMessageValues().equals(other.getMessageValues()));
    }
}

