/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream;

import joptsimple.OptionSet;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemProducer;
import org.apache.samza.coordinator.stream.CoordinatorStreamWriterCommandLine;
import org.apache.samza.coordinator.stream.messages.SetConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamWriter {
    private static final Logger log = LoggerFactory.getLogger(CoordinatorStreamWriter.class);
    public static final String SOURCE = "coordinator-stream-writer";
    public static final String SET_CONFIG_TYPE = "set-config";
    private CoordinatorStreamSystemProducer coordinatorStreamSystemProducer;

    public CoordinatorStreamWriter(Config config) {
        this.coordinatorStreamSystemProducer = new CoordinatorStreamSystemProducer(config, (MetricsRegistry)new MetricsRegistryMap());
    }

    public void start() {
        this.coordinatorStreamSystemProducer.register(SOURCE);
        this.coordinatorStreamSystemProducer.start();
        log.info("Started coordinator stream writer.");
    }

    public void stop() {
        log.info("Stopping the coordinator stream producer.");
        this.coordinatorStreamSystemProducer.stop();
    }

    public void sendMessage(String type, String key, String value) {
        if (!type.equals(SET_CONFIG_TYPE)) {
            throw new IllegalArgumentException("Type is invalid. The possible values are {set-config}");
        }
        this.sendSetConfigMessage(key, value);
    }

    private void sendSetConfigMessage(String key, String value) {
        log.info("sent SetConfig message with key = " + key + " and value = " + value);
        this.coordinatorStreamSystemProducer.send(new SetConfig(SOURCE, key, value));
    }

    public static void main(String[] args) {
        CoordinatorStreamWriterCommandLine cmdline = new CoordinatorStreamWriterCommandLine();
        OptionSet options = cmdline.parser().parse(args);
        MapConfig config = cmdline.loadConfig(options);
        String type = cmdline.loadType(options);
        String key = cmdline.loadKey(options);
        String value = cmdline.loadValue(options);
        CoordinatorStreamWriter writer = new CoordinatorStreamWriter((Config)config);
        writer.start();
        writer.sendMessage(type, key, value);
        writer.stop();
    }
}

