/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.coordinator.stream.messages.SetChangelogMapping;
import org.apache.samza.coordinator.stream.messages.SetContainerHostMapping;
import org.apache.samza.coordinator.stream.messages.SetTaskContainerMapping;
import org.apache.samza.serializers.JsonSerde;
import org.apache.samza.serializers.Serde;

public class CoordinatorStreamValueSerde
implements Serde<String> {
    private static final String SOURCE = "SamzaContainer";
    private final String type;
    private final Serde<Map<String, Object>> messageSerde;

    public CoordinatorStreamValueSerde(String type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
        this.messageSerde = new JsonSerde<Map<String, Object>>();
    }

    public String fromBytes(byte[] bytes) {
        Map values = (Map)this.messageSerde.fromBytes(bytes);
        CoordinatorStreamMessage message = new CoordinatorStreamMessage(new Object[0], values);
        if (this.type.equalsIgnoreCase("set-container-host-assignment")) {
            SetContainerHostMapping hostMapping = new SetContainerHostMapping(message);
            return hostMapping.getHostLocality();
        }
        if (this.type.equalsIgnoreCase("set-task-container-assignment")) {
            SetTaskContainerMapping setTaskContainerMapping = new SetTaskContainerMapping(message);
            return setTaskContainerMapping.getTaskAssignment();
        }
        if (this.type.equalsIgnoreCase("set-changelog")) {
            SetChangelogMapping changelogMapping = new SetChangelogMapping(message);
            return String.valueOf(changelogMapping.getPartition());
        }
        throw new SamzaException(String.format("Unknown coordinator stream message type: %s", this.type));
    }

    public byte[] toBytes(String value) {
        if (this.type.equalsIgnoreCase("set-container-host-assignment")) {
            SetContainerHostMapping hostMapping = new SetContainerHostMapping(SOURCE, "", value, "", "");
            return this.messageSerde.toBytes(hostMapping.getMessageMap());
        }
        if (this.type.equalsIgnoreCase("set-task-container-assignment")) {
            SetTaskContainerMapping setTaskContainerMapping = new SetTaskContainerMapping(SOURCE, "", value);
            return this.messageSerde.toBytes(setTaskContainerMapping.getMessageMap());
        }
        if (this.type.equalsIgnoreCase("set-changelog")) {
            SetChangelogMapping changelogMapping = new SetChangelogMapping(SOURCE, "", Integer.valueOf(value));
            return this.messageSerde.toBytes(changelogMapping.getMessageMap());
        }
        throw new SamzaException(String.format("Unknown coordinator stream message type: %s", this.type));
    }
}

