/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.coordinator.stream.messages.SetConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.JsonSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.CoordinatorStreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamSystemProducer {
    private static final Logger log = LoggerFactory.getLogger(CoordinatorStreamSystemProducer.class);
    private final Serde<List<?>> keySerde;
    private final Serde<Map<String, Object>> messageSerde;
    private final SystemStream systemStream;
    private final SystemProducer systemProducer;
    private final SystemAdmin systemAdmin;
    private boolean isStarted;

    public CoordinatorStreamSystemProducer(Config config, MetricsRegistry registry) {
        SystemStream coordinatorSystemStream = CoordinatorStreamUtil.getCoordinatorSystemStream(config);
        SystemFactory systemFactory = CoordinatorStreamUtil.getCoordinatorSystemFactory(config);
        SystemAdmin systemAdmin = systemFactory.getAdmin(coordinatorSystemStream.getSystem(), config);
        SystemProducer systemProducer = systemFactory.getProducer(coordinatorSystemStream.getSystem(), config, registry);
        this.systemStream = coordinatorSystemStream;
        this.systemProducer = systemProducer;
        this.systemAdmin = systemAdmin;
        this.keySerde = new JsonSerde();
        this.messageSerde = new JsonSerde<Map<String, Object>>();
    }

    public CoordinatorStreamSystemProducer(SystemStream systemStream, SystemProducer systemProducer, SystemAdmin systemAdmin) {
        this.systemStream = systemStream;
        this.systemProducer = systemProducer;
        this.systemAdmin = systemAdmin;
        this.keySerde = new JsonSerde();
        this.messageSerde = new JsonSerde<Map<String, Object>>();
    }

    public void register(String source) {
        this.systemProducer.register(source);
    }

    public void start() {
        if (this.isStarted) {
            log.info("Coordinator stream producer already started");
            return;
        }
        log.info("Starting coordinator stream producer.");
        this.systemProducer.start();
        this.systemAdmin.start();
        this.isStarted = true;
    }

    public void stop() {
        log.info("Stopping coordinator stream producer.");
        this.systemProducer.stop();
        this.systemAdmin.stop();
        this.isStarted = false;
    }

    public void send(CoordinatorStreamMessage message) {
        log.debug("Sending {}", (Object)message);
        try {
            String source = message.getSource();
            byte[] key = this.keySerde.toBytes(Arrays.asList(message.getKeyArray()));
            byte[] value = null;
            if (!message.isDelete()) {
                value = this.messageSerde.toBytes(message.getMessageMap());
            }
            OutgoingMessageEnvelope envelope = new OutgoingMessageEnvelope(this.systemStream, (Object)0, (Object)key, (Object)value);
            this.systemProducer.send(source, envelope);
        }
        catch (Exception e) {
            throw new SamzaException((Throwable)e);
        }
    }

    public void writeConfig(String source, Config config) {
        log.debug("Writing config: {}", (Object)config);
        for (Map.Entry configPair : config.entrySet()) {
            this.send(new SetConfig(source, (String)configPair.getKey(), (String)configPair.getValue()));
        }
        this.systemProducer.flush(source);
    }

    @VisibleForTesting
    boolean isStarted() {
        return this.isStarted;
    }
}

