/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.coordinator.stream.messages.SetConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.JsonSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.SystemStreamPartitionIterator;
import org.apache.samza.util.CoordinatorStreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamSystemConsumer {
    private static final Logger log = LoggerFactory.getLogger(CoordinatorStreamSystemConsumer.class);
    private final Serde<List<?>> keySerde;
    private final Serde<Map<String, Object>> messageSerde;
    private final SystemStreamPartition coordinatorSystemStreamPartition;
    private final SystemConsumer systemConsumer;
    private final SystemAdmin systemAdmin;
    private final Map<String, String> configMap;
    private volatile boolean isStarted;
    private volatile boolean isBootstrapped;
    private final Object bootstrapLock = new Object();
    private volatile Set<CoordinatorStreamMessage> bootstrappedStreamSet = Collections.emptySet();

    public CoordinatorStreamSystemConsumer(Config config, MetricsRegistry registry) {
        SystemStream coordinatorSystemStream = CoordinatorStreamUtil.getCoordinatorSystemStream(config);
        SystemFactory systemFactory = CoordinatorStreamUtil.getCoordinatorSystemFactory(config);
        SystemAdmin systemAdmin = systemFactory.getAdmin(coordinatorSystemStream.getSystem(), config);
        SystemConsumer systemConsumer = systemFactory.getConsumer(coordinatorSystemStream.getSystem(), config, registry);
        this.coordinatorSystemStreamPartition = new SystemStreamPartition(coordinatorSystemStream, new Partition(0));
        this.systemConsumer = systemConsumer;
        this.systemAdmin = systemAdmin;
        this.configMap = new HashMap<String, String>();
        this.isBootstrapped = false;
        this.keySerde = new JsonSerde();
        this.messageSerde = new JsonSerde<Map<String, Object>>();
    }

    public CoordinatorStreamSystemConsumer(SystemStream coordinatorSystemStream, SystemConsumer systemConsumer, SystemAdmin systemAdmin) {
        this.coordinatorSystemStreamPartition = new SystemStreamPartition(coordinatorSystemStream, new Partition(0));
        this.systemConsumer = systemConsumer;
        this.systemAdmin = systemAdmin;
        this.configMap = new HashMap<String, String>();
        this.isBootstrapped = false;
        this.keySerde = new JsonSerde();
        this.messageSerde = new JsonSerde<Map<String, Object>>();
    }

    public void register() {
        if (this.isStarted) {
            log.info("Coordinator stream partition {} has already been registered. Skipping.", (Object)this.coordinatorSystemStreamPartition);
            return;
        }
        log.debug("Attempting to register: {}", (Object)this.coordinatorSystemStreamPartition);
        HashSet<String> streamNames = new HashSet<String>();
        String streamName = this.coordinatorSystemStreamPartition.getStream();
        streamNames.add(streamName);
        Map systemStreamMetadataMap = this.systemAdmin.getSystemStreamMetadata(streamNames);
        log.info(String.format("Got metadata %s", systemStreamMetadataMap.toString()));
        if (systemStreamMetadataMap == null) {
            throw new SamzaException("Received a null systemStreamMetadataMap from the systemAdmin. This is illegal.");
        }
        SystemStreamMetadata systemStreamMetadata = (SystemStreamMetadata)systemStreamMetadataMap.get(streamName);
        if (systemStreamMetadata == null) {
            throw new SamzaException("Expected " + streamName + " to be in system stream metadata.");
        }
        SystemStreamMetadata.SystemStreamPartitionMetadata systemStreamPartitionMetadata = (SystemStreamMetadata.SystemStreamPartitionMetadata)systemStreamMetadata.getSystemStreamPartitionMetadata().get(this.coordinatorSystemStreamPartition.getPartition());
        if (systemStreamPartitionMetadata == null) {
            throw new SamzaException("Expected metadata for " + this.coordinatorSystemStreamPartition + " to exist.");
        }
        String startingOffset = systemStreamPartitionMetadata.getOldestOffset();
        log.debug("Registering {} with offset {}", (Object)this.coordinatorSystemStreamPartition, (Object)startingOffset);
        this.systemConsumer.register(this.coordinatorSystemStreamPartition, startingOffset);
    }

    public void start() {
        if (this.isStarted) {
            log.info("Coordinator stream consumer already started");
            return;
        }
        log.info("Starting coordinator stream system consumer.");
        this.systemConsumer.start();
        this.systemAdmin.start();
        this.isStarted = true;
    }

    public void stop() {
        log.info("Stopping coordinator stream system consumer.");
        this.systemConsumer.stop();
        this.systemAdmin.stop();
        this.isStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            LinkedHashSet<CoordinatorStreamMessage> bootstrappedMessages = new LinkedHashSet<CoordinatorStreamMessage>(this.bootstrappedStreamSet);
            log.info("Bootstrapping configuration from coordinator stream.");
            SystemStreamPartitionIterator iterator = new SystemStreamPartitionIterator(this.systemConsumer, this.coordinatorSystemStreamPartition);
            try {
                while (iterator.hasNext()) {
                    IncomingMessageEnvelope envelope = iterator.next();
                    Object[] keyArray = ((List)this.keySerde.fromBytes((byte[])envelope.getKey())).toArray();
                    Map valueMap = null;
                    if (envelope.getMessage() != null) {
                        valueMap = (Map)this.messageSerde.fromBytes((byte[])envelope.getMessage());
                    }
                    CoordinatorStreamMessage coordinatorStreamMessage = new CoordinatorStreamMessage(keyArray, valueMap);
                    log.debug("Received coordinator stream message: {}", (Object)coordinatorStreamMessage);
                    if (bootstrappedMessages.remove(coordinatorStreamMessage)) {
                        log.debug("Removed duplicate message: {}", (Object)coordinatorStreamMessage);
                    }
                    bootstrappedMessages.add(coordinatorStreamMessage);
                    if (!"set-config".equals(coordinatorStreamMessage.getType())) continue;
                    String configKey = coordinatorStreamMessage.getKey();
                    if (coordinatorStreamMessage.isDelete()) {
                        this.configMap.remove(configKey);
                        continue;
                    }
                    String configValue = new SetConfig(coordinatorStreamMessage).getConfigValue();
                    this.configMap.put(configKey, configValue);
                }
                this.bootstrappedStreamSet = Collections.unmodifiableSet(bootstrappedMessages);
                log.debug("Bootstrapped configuration: {}", this.configMap);
                this.isBootstrapped = true;
            }
            catch (Exception e) {
                throw new SamzaException((Throwable)e);
            }
        }
    }

    public Set<CoordinatorStreamMessage> getBoostrappedStream() {
        log.info("Returning the bootstrapped data from the stream");
        if (!this.isBootstrapped) {
            this.bootstrap();
        }
        return this.bootstrappedStreamSet;
    }

    public Set<CoordinatorStreamMessage> getBootstrappedStream(String type) {
        log.debug("Bootstrapping coordinator stream for messages of type {}", (Object)type);
        this.bootstrap();
        LinkedHashSet<CoordinatorStreamMessage> bootstrappedStream = new LinkedHashSet<CoordinatorStreamMessage>();
        for (CoordinatorStreamMessage coordinatorStreamMessage : this.bootstrappedStreamSet) {
            log.trace("Considering message: {}", (Object)coordinatorStreamMessage);
            if (!type.equalsIgnoreCase(coordinatorStreamMessage.getType())) continue;
            log.trace("Adding message: {}", (Object)coordinatorStreamMessage);
            bootstrappedStream.add(coordinatorStreamMessage);
        }
        return bootstrappedStream;
    }

    public Config getConfig() {
        if (this.isBootstrapped) {
            return new MapConfig(this.configMap);
        }
        throw new SamzaException("Must call bootstrap before retrieving config.");
    }

    public SystemStreamPartitionIterator getStartIterator() {
        return new SystemStreamPartitionIterator(this.systemConsumer, this.coordinatorSystemStreamPartition);
    }

    public Set<CoordinatorStreamMessage> getUnreadMessages(SystemStreamPartitionIterator iterator) {
        return this.getUnreadMessages(iterator, null);
    }

    public Set<CoordinatorStreamMessage> getUnreadMessages(SystemStreamPartitionIterator iterator, String type) {
        LinkedHashSet<CoordinatorStreamMessage> messages = new LinkedHashSet<CoordinatorStreamMessage>();
        while (iterator.hasNext()) {
            IncomingMessageEnvelope envelope = iterator.next();
            Object[] keyArray = ((List)this.keySerde.fromBytes((byte[])envelope.getKey())).toArray();
            Map valueMap = null;
            if (envelope.getMessage() != null) {
                valueMap = (Map)this.messageSerde.fromBytes((byte[])envelope.getMessage());
            }
            CoordinatorStreamMessage coordinatorStreamMessage = new CoordinatorStreamMessage(keyArray, valueMap);
            if (type != null && !type.equals(coordinatorStreamMessage.getType())) continue;
            messages.add(coordinatorStreamMessage);
        }
        return messages;
    }

    public boolean hasNewMessages(SystemStreamPartitionIterator iterator) {
        if (iterator == null) {
            return false;
        }
        return iterator.hasNext();
    }

    @VisibleForTesting
    boolean isStarted() {
        return this.isStarted;
    }
}

