/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.stream;

import java.util.Set;
import org.apache.samza.config.Config;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemConsumer;
import org.apache.samza.coordinator.stream.CoordinatorStreamSystemProducer;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.metrics.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamManager {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorStreamManager.class);
    private final CoordinatorStreamSystemProducer coordinatorStreamProducer;
    private final CoordinatorStreamSystemConsumer coordinatorStreamConsumer;

    public CoordinatorStreamManager(CoordinatorStreamSystemConsumer coordinatorStreamConsumer) {
        this(null, coordinatorStreamConsumer);
    }

    public CoordinatorStreamManager(CoordinatorStreamSystemProducer coordinatorStreamProducer) {
        this(coordinatorStreamProducer, null);
    }

    public CoordinatorStreamManager(CoordinatorStreamSystemProducer coordinatorStreamProducer, CoordinatorStreamSystemConsumer coordinatorStreamConsumer) {
        this.coordinatorStreamProducer = coordinatorStreamProducer;
        this.coordinatorStreamConsumer = coordinatorStreamConsumer;
    }

    public CoordinatorStreamManager(Config coordinatorSystemConfig, MetricsRegistry metricsRegistry) {
        this.coordinatorStreamConsumer = new CoordinatorStreamSystemConsumer(coordinatorSystemConfig, metricsRegistry);
        this.coordinatorStreamProducer = new CoordinatorStreamSystemProducer(coordinatorSystemConfig, metricsRegistry);
    }

    public void register(String source) {
        if (this.coordinatorStreamConsumer != null) {
            LOG.info("Registering coordinator system stream consumer from {}.", (Object)source);
            this.coordinatorStreamConsumer.register();
        }
        if (this.coordinatorStreamProducer != null) {
            LOG.info("Registering coordinator system stream producer from {}.", (Object)source);
            this.coordinatorStreamProducer.register(source);
        }
    }

    public void start() {
        if (this.coordinatorStreamConsumer != null) {
            LOG.debug("Starting coordinator system stream consumer.");
            this.coordinatorStreamConsumer.start();
        }
        if (this.coordinatorStreamProducer != null) {
            LOG.debug("Starting coordinator system stream producer.");
            this.coordinatorStreamProducer.start();
        }
    }

    public void stop() {
        if (this.coordinatorStreamConsumer != null) {
            this.coordinatorStreamConsumer.stop();
        }
        if (this.coordinatorStreamProducer != null) {
            this.coordinatorStreamProducer.stop();
        }
    }

    public void send(CoordinatorStreamMessage message) {
        if (this.coordinatorStreamProducer == null) {
            throw new UnsupportedOperationException(String.format("CoordinatorStreamProducer is not initialized in the CoordinatorStreamManager. ", new Object[0]));
        }
        this.coordinatorStreamProducer.send(message);
    }

    public void bootstrap() {
        if (this.coordinatorStreamConsumer != null) {
            LOG.debug("Bootstrapping coordinator system stream consumer.");
            this.coordinatorStreamConsumer.bootstrap();
        }
    }

    public Set<CoordinatorStreamMessage> getBootstrappedStream(String source) {
        if (this.coordinatorStreamConsumer == null) {
            throw new UnsupportedOperationException(String.format("CoordinatorStreamConsumer is not initialized in the CoordinatorStreamManager. ", new Object[0]));
        }
        return this.coordinatorStreamConsumer.getBootstrappedStream(source);
    }

    public Config getConfig() {
        if (this.coordinatorStreamConsumer == null) {
            throw new IllegalStateException(String.format("CoordinatorStreamConsumer is not initialized in the CoordinatorStreamManager. ", new Object[0]));
        }
        return this.coordinatorStreamConsumer.getConfig();
    }
}

