/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.metadatastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.primitives.UnsignedBytes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.samza.Partition;
import org.apache.samza.config.Config;
import org.apache.samza.coordinator.stream.messages.CoordinatorStreamMessage;
import org.apache.samza.metadatastore.MetadataStore;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.JsonSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.SystemStreamPartitionIterator;
import org.apache.samza.util.CoordinatorStreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorStreamStore
implements MetadataStore {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorStreamStore.class);
    private static final String SOURCE = "SamzaContainer";
    private final Config config;
    private final SystemStream coordinatorSystemStream;
    private final SystemStreamPartition coordinatorSystemStreamPartition;
    private final SystemProducer systemProducer;
    private final SystemConsumer systemConsumer;
    private final SystemAdmin systemAdmin;
    private final String type;
    private final Serde<List<?>> keySerde;
    private final Map<byte[], byte[]> bootstrappedMessages = new TreeMap<byte[], byte[]>(UnsignedBytes.lexicographicalComparator());
    private final Object bootstrapLock = new Object();
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private SystemStreamPartitionIterator iterator;

    public CoordinatorStreamStore(String namespace, Config config, MetricsRegistry metricsRegistry) {
        this.config = config;
        this.type = namespace;
        this.keySerde = new JsonSerde();
        this.coordinatorSystemStream = CoordinatorStreamUtil.getCoordinatorSystemStream(config);
        this.coordinatorSystemStreamPartition = new SystemStreamPartition(this.coordinatorSystemStream, new Partition(0));
        SystemFactory systemFactory = CoordinatorStreamUtil.getCoordinatorSystemFactory(config);
        this.systemProducer = systemFactory.getProducer(this.coordinatorSystemStream.getSystem(), config, metricsRegistry);
        this.systemConsumer = systemFactory.getConsumer(this.coordinatorSystemStream.getSystem(), config, metricsRegistry);
        this.systemAdmin = systemFactory.getAdmin(this.coordinatorSystemStream.getSystem(), config);
    }

    public void init() {
        if (this.isInitialized.compareAndSet(false, true)) {
            LOG.info("Starting the coordinator stream system consumer with config: {}.", (Object)this.config);
            this.registerConsumer();
            this.systemConsumer.start();
            this.systemProducer.register(SOURCE);
            this.systemProducer.start();
            this.iterator = new SystemStreamPartitionIterator(this.systemConsumer, this.coordinatorSystemStreamPartition);
            this.bootstrapMessagesFromStream();
        } else {
            LOG.info("Store had already been initialized. Skipping.", (Object)this.coordinatorSystemStreamPartition);
        }
    }

    public byte[] get(byte[] key) {
        this.bootstrapMessagesFromStream();
        return this.bootstrappedMessages.get(key);
    }

    public void put(byte[] key, byte[] value) {
        OutgoingMessageEnvelope envelope = new OutgoingMessageEnvelope(this.coordinatorSystemStream, (Object)0, (Object)key, (Object)value);
        this.systemProducer.send(SOURCE, envelope);
        this.flush();
    }

    public void delete(byte[] key) {
        this.put(key, null);
    }

    public Map<byte[], byte[]> all() {
        this.bootstrapMessagesFromStream();
        return Collections.unmodifiableMap(this.bootstrappedMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootstrapMessagesFromStream() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            while (this.iterator.hasNext()) {
                IncomingMessageEnvelope envelope = this.iterator.next();
                byte[] keyAsBytes = (byte[])envelope.getKey();
                Object[] keyArray = ((List)this.keySerde.fromBytes(keyAsBytes)).toArray();
                CoordinatorStreamMessage coordinatorStreamMessage = new CoordinatorStreamMessage(keyArray, new HashMap<String, Object>());
                if (!Objects.equals(coordinatorStreamMessage.getType(), this.type)) continue;
                if (envelope.getMessage() != null) {
                    this.bootstrappedMessages.put(keyAsBytes, (byte[])envelope.getMessage());
                    continue;
                }
                this.bootstrappedMessages.remove(keyAsBytes);
            }
        }
    }

    public void close() {
        try {
            LOG.info("Stopping the coordinator stream system consumer.", (Object)this.config);
            this.systemAdmin.stop();
            this.systemProducer.stop();
            this.systemConsumer.stop();
        }
        catch (Exception e) {
            LOG.error("Exception occurred when closing the metadata store:", (Throwable)e);
        }
    }

    public void flush() {
        try {
            this.systemProducer.flush(SOURCE);
        }
        catch (Exception e) {
            LOG.error("Exception occurred when flushing the metadata store:", (Throwable)e);
        }
    }

    private void registerConsumer() {
        LOG.debug("Attempting to register system stream partition: {}", (Object)this.coordinatorSystemStreamPartition);
        String streamName = this.coordinatorSystemStreamPartition.getStream();
        Map systemStreamMetadataMap = this.systemAdmin.getSystemStreamMetadata((Set)Sets.newHashSet((Object[])new String[]{streamName}));
        SystemStreamMetadata systemStreamMetadata = (SystemStreamMetadata)systemStreamMetadataMap.get(streamName);
        Preconditions.checkNotNull((Object)systemStreamMetadata, (Object)String.format("System stream metadata does not exist for stream: %s.", streamName));
        SystemStreamMetadata.SystemStreamPartitionMetadata systemStreamPartitionMetadata = (SystemStreamMetadata.SystemStreamPartitionMetadata)systemStreamMetadata.getSystemStreamPartitionMetadata().get(this.coordinatorSystemStreamPartition.getPartition());
        Preconditions.checkNotNull((Object)systemStreamPartitionMetadata, (Object)String.format("System stream partition metadata does not exist for: %s.", this.coordinatorSystemStreamPartition));
        String startingOffset = systemStreamPartitionMetadata.getOldestOffset();
        LOG.info("Registering system stream partition: {} with offset: {}.", (Object)this.coordinatorSystemStreamPartition, (Object)startingOffset);
        this.systemConsumer.register(this.coordinatorSystemStreamPartition, startingOffset);
    }
}

