/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class StreamPartitionCountMonitor {
    private static final Logger log = LoggerFactory.getLogger(StreamPartitionCountMonitor.class);
    private final Set<SystemStream> streamsToMonitor;
    private final StreamMetadataCache metadataCache;
    private final int monitorPeriodMs;
    private final Map<SystemStream, Gauge<Integer>> gauges;
    private final Map<SystemStream, SystemStreamMetadata> initialMetadata;
    private final Callback callbackMethod;
    private final Object lock = new Object();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryImpl();
    private final ScheduledExecutorService schedulerService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private volatile State state = State.INIT;

    private static Map<SystemStream, SystemStreamMetadata> getMetadata(Set<SystemStream> streamsToMonitor, StreamMetadataCache metadataCache) {
        return (Map)JavaConverters.mapAsJavaMapConverter(metadataCache.getStreamMetadata((scala.collection.immutable.Set<SystemStream>)((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter(streamsToMonitor).asScala()).toSet(), true)).asJava();
    }

    public StreamPartitionCountMonitor(Set<SystemStream> streamsToMonitor, StreamMetadataCache metadataCache, MetricsRegistry metrics, int monitorPeriodMs, Callback monitorCallback) {
        this.streamsToMonitor = streamsToMonitor;
        this.metadataCache = metadataCache;
        this.monitorPeriodMs = monitorPeriodMs;
        this.initialMetadata = StreamPartitionCountMonitor.getMetadata(streamsToMonitor, metadataCache);
        this.callbackMethod = monitorCallback;
        HashMap<SystemStream, Gauge> mutableGauges = new HashMap<SystemStream, Gauge>();
        for (Map.Entry<SystemStream, SystemStreamMetadata> metadataEntry : this.initialMetadata.entrySet()) {
            SystemStream systemStream = metadataEntry.getKey();
            Gauge gauge = metrics.newGauge("job-coordinator", String.format("%s-%s-partitionCount", systemStream.getSystem(), systemStream.getStream()), (Object)0);
            mutableGauges.put(systemStream, gauge);
        }
        this.gauges = Collections.unmodifiableMap(mutableGauges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case INIT: {
                    if (this.monitorPeriodMs > 0) {
                        this.schedulerService.scheduleAtFixedRate(new Runnable(){

                            @Override
                            public void run() {
                                StreamPartitionCountMonitor.this.updatePartitionCountMetric();
                            }
                        }, this.monitorPeriodMs, this.monitorPeriodMs, TimeUnit.MILLISECONDS);
                    }
                    this.state = State.RUNNING;
                    break;
                }
                case RUNNING: {
                    return;
                }
                case STOPPED: {
                    throw new IllegalStateException("StreamPartitionCountMonitor was stopped and cannot be restarted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.schedulerService.shutdownNow();
            this.state = State.STOPPED;
        }
    }

    @VisibleForTesting
    public void updatePartitionCountMetric() {
        try {
            Map<SystemStream, SystemStreamMetadata> currentMetadata = StreamPartitionCountMonitor.getMetadata(this.streamsToMonitor, this.metadataCache);
            HashSet<SystemStream> streamsChanged = new HashSet<SystemStream>();
            for (Map.Entry<SystemStream, SystemStreamMetadata> metadataEntry : this.initialMetadata.entrySet()) {
                try {
                    SystemStream systemStream = metadataEntry.getKey();
                    SystemStreamMetadata metadata = metadataEntry.getValue();
                    int currentPartitionCount = currentMetadata.get(systemStream).getSystemStreamPartitionMetadata().size();
                    int prevPartitionCount = metadata.getSystemStreamPartitionMetadata().size();
                    Gauge<Integer> gauge = this.gauges.get(systemStream);
                    gauge.set((Object)currentPartitionCount);
                    if (currentPartitionCount == prevPartitionCount) continue;
                    log.warn(String.format("Change of partition count detected in stream %s. old partition count: %d, current partition count: %d", systemStream.toString(), prevPartitionCount, currentPartitionCount));
                    if (currentPartitionCount <= prevPartitionCount) continue;
                    log.error(String.format("Shutting down (stateful) or restarting (stateless) the job since current partition count %d is greater than the old partition count %d for stream %s.", currentPartitionCount, prevPartitionCount, systemStream.toString()));
                    streamsChanged.add(systemStream);
                }
                catch (Exception e) {
                    log.error(String.format("Error comparing partition count differences for stream: %s", metadataEntry.getKey().toString()));
                }
            }
            if (!streamsChanged.isEmpty() && this.callbackMethod != null) {
                this.callbackMethod.onSystemStreamPartitionChange(streamsChanged);
            }
        }
        catch (Exception e) {
            log.error("Exception while updating partition count metric.", (Throwable)e);
        }
    }

    @VisibleForTesting
    Map<SystemStream, Gauge<Integer>> getGauges() {
        return this.gauges;
    }

    @VisibleForTesting
    boolean isRunning() {
        return this.state == State.RUNNING;
    }

    @VisibleForTesting
    boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.schedulerService.awaitTermination(timeout, unit);
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private static final String PREFIX = "Samza-" + StreamPartitionCountMonitor.class.getSimpleName() + "-";
        private static final AtomicInteger INSTANCE_NUM = new AtomicInteger();

        private ThreadFactoryImpl() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, PREFIX + INSTANCE_NUM.getAndIncrement());
        }
    }

    public static interface Callback {
        public void onSystemStreamPartitionChange(Set<SystemStream> var1);
    }

    private static enum State {
        INIT,
        RUNNING,
        STOPPED;

    }
}

