/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.context;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.samza.checkpoint.OffsetManager;
import org.apache.samza.context.TaskContext;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.scheduler.CallbackScheduler;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableManager;

public class TaskContextImpl
implements TaskContext {
    private final TaskModel taskModel;
    private final MetricsRegistry taskMetricsRegistry;
    private final Function<String, KeyValueStore> keyValueStoreProvider;
    private final TableManager tableManager;
    private final CallbackScheduler callbackScheduler;
    private final OffsetManager offsetManager;
    private final JobModel jobModel;
    private final StreamMetadataCache streamMetadataCache;
    private final Map<String, Object> objectRegistry = new HashMap<String, Object>();

    public TaskContextImpl(TaskModel taskModel, MetricsRegistry taskMetricsRegistry, Function<String, KeyValueStore> keyValueStoreProvider, TableManager tableManager, CallbackScheduler callbackScheduler, OffsetManager offsetManager, JobModel jobModel, StreamMetadataCache streamMetadataCache) {
        this.taskModel = taskModel;
        this.taskMetricsRegistry = taskMetricsRegistry;
        this.keyValueStoreProvider = keyValueStoreProvider;
        this.tableManager = tableManager;
        this.callbackScheduler = callbackScheduler;
        this.offsetManager = offsetManager;
        this.jobModel = jobModel;
        this.streamMetadataCache = streamMetadataCache;
    }

    public TaskModel getTaskModel() {
        return this.taskModel;
    }

    public MetricsRegistry getTaskMetricsRegistry() {
        return this.taskMetricsRegistry;
    }

    public KeyValueStore getStore(String storeName) {
        KeyValueStore store = this.keyValueStoreProvider.apply(storeName);
        if (store == null) {
            throw new IllegalArgumentException(String.format("No store found for storeName: %s", storeName));
        }
        return store;
    }

    public Table getTable(String tableId) {
        return this.tableManager.getTable(tableId);
    }

    public CallbackScheduler getCallbackScheduler() {
        return this.callbackScheduler;
    }

    public void setStartingOffset(SystemStreamPartition systemStreamPartition, String offset) {
        this.offsetManager.setStartingOffset(this.taskModel.getTaskName(), systemStreamPartition, offset);
    }

    public void registerObject(String name, Object value) {
        this.objectRegistry.put(name, value);
    }

    public Object fetchObject(String name) {
        return this.objectRegistry.get(name);
    }

    public JobModel getJobModel() {
        return this.jobModel;
    }

    public StreamMetadataCache getStreamMetadataCache() {
        return this.streamMetadataCache;
    }
}

