/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.context;

import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.context.JobContext;
import scala.Option;

public class JobContextImpl
implements JobContext {
    private final Config config;
    private final String jobName;
    private final String jobId;

    private JobContextImpl(Config config, String jobName, String jobId) {
        this.config = config;
        this.jobName = jobName;
        this.jobId = jobId;
    }

    public static JobContextImpl fromConfigWithDefaults(Config config) {
        JobConfig jobConfig = new JobConfig(config);
        Option<String> jobName = jobConfig.getName();
        if (jobName.isEmpty()) {
            throw new IllegalArgumentException("Job name is not defined in configuration");
        }
        String jobId = jobConfig.getJobId();
        return new JobContextImpl(config, (String)jobName.get(), jobId);
    }

    public Config getConfig() {
        return this.config;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobId() {
        return this.jobId;
    }
}

