/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.context;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.Context;
import org.apache.samza.context.JobContext;
import org.apache.samza.context.TaskContext;

public class ContextImpl
implements Context {
    private final JobContext jobContext;
    private final ContainerContext containerContext;
    private final TaskContext taskContext;
    private final Optional<ApplicationContainerContext> applicationContainerContextOptional;
    private final Optional<ApplicationTaskContext> applicationTaskContextOptional;

    public ContextImpl(JobContext jobContext, ContainerContext containerContext, TaskContext taskContext, Optional<ApplicationContainerContext> applicationContainerContextOptional, Optional<ApplicationTaskContext> applicationTaskContextOptional) {
        this.jobContext = (JobContext)Preconditions.checkNotNull((Object)jobContext, (Object)"Job context can not be null");
        this.containerContext = (ContainerContext)Preconditions.checkNotNull((Object)containerContext, (Object)"Container context can not be null");
        this.taskContext = (TaskContext)Preconditions.checkNotNull((Object)taskContext, (Object)"Task context can not be null");
        this.applicationContainerContextOptional = applicationContainerContextOptional;
        this.applicationTaskContextOptional = applicationTaskContextOptional;
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public ContainerContext getContainerContext() {
        return this.containerContext;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public ApplicationContainerContext getApplicationContainerContext() {
        if (!this.applicationContainerContextOptional.isPresent()) {
            throw new IllegalStateException("No application-defined container context exists");
        }
        return this.applicationContainerContextOptional.get();
    }

    public ApplicationTaskContext getApplicationTaskContext() {
        if (!this.applicationTaskContextOptional.isPresent()) {
            throw new IllegalStateException("No application-defined task context exists");
        }
        return this.applicationTaskContextOptional.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextImpl context = (ContextImpl)o;
        return Objects.equals(this.jobContext, context.jobContext) && Objects.equals(this.containerContext, context.containerContext) && Objects.equals(this.taskContext, context.taskContext) && Objects.equals(this.applicationContainerContextOptional, context.applicationContainerContextOptional) && Objects.equals(this.applicationTaskContextOptional, context.applicationTaskContextOptional);
    }

    public int hashCode() {
        return Objects.hash(this.jobContext, this.containerContext, this.taskContext, this.applicationContainerContextOptional, this.applicationTaskContextOptional);
    }
}

