/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.host;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.samza.container.host.PosixCommandBasedStatisticsGetter;
import org.apache.samza.container.host.SystemMemoryStatistics;
import org.apache.samza.container.host.SystemStatisticsGetter;
import org.apache.samza.container.host.SystemStatisticsMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsMonitorImpl
implements SystemStatisticsMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsMonitorImpl.class);
    private final long pollingIntervalMillis;
    private final Object lock = new Object();
    private final ScheduledExecutorService schedulerService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Samza StatisticsMonitor Thread-%d").setDaemon(true).build());
    private final ConcurrentMap<SystemStatisticsMonitor.Listener, Boolean> listenerSet = new ConcurrentHashMap<SystemStatisticsMonitor.Listener, Boolean>();
    private final SystemStatisticsGetter statisticsGetter;
    private volatile State currentState;

    public StatisticsMonitorImpl() {
        this(60000L, new PosixCommandBasedStatisticsGetter());
    }

    public StatisticsMonitorImpl(long pollingIntervalMillis, SystemStatisticsGetter statisticsGetter) {
        this.pollingIntervalMillis = pollingIntervalMillis;
        this.statisticsGetter = statisticsGetter;
        this.currentState = State.INIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.currentState) {
                case INIT: {
                    this.currentState = State.RUNNING;
                    this.schedulerService.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            StatisticsMonitorImpl.this.sampleStatistics();
                        }
                    }, this.pollingIntervalMillis, this.pollingIntervalMillis, TimeUnit.MILLISECONDS);
                    break;
                }
                case RUNNING: {
                    return;
                }
                case STOPPED: {
                    throw new IllegalStateException("Attempting to start an already stopped StatisticsMonitor");
                }
            }
        }
    }

    private void sampleStatistics() {
        SystemMemoryStatistics statistics = null;
        try {
            statistics = this.statisticsGetter.getSystemMemoryStatistics();
        }
        catch (Throwable e) {
            LOG.error("Error during obtaining statistics: ", e);
        }
        for (SystemStatisticsMonitor.Listener listener : this.listenerSet.keySet()) {
            if (statistics == null) continue;
            try {
                listener.onUpdate(statistics);
            }
            catch (Throwable e) {
                this.listenerSet.remove(listener);
                LOG.error("Listener threw an exception: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.schedulerService.shutdownNow();
            this.listenerSet.clear();
            this.currentState = State.STOPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerListener(SystemStatisticsMonitor.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == State.STOPPED) {
                LOG.error("Attempting to register a listener after monitor was stopped.");
                return false;
            }
            if (this.listenerSet.containsKey(listener)) {
                LOG.error("Attempting to register an already registered listener");
                return false;
            }
            this.listenerSet.put(listener, Boolean.TRUE);
            return true;
        }
    }

    private static enum State {
        INIT,
        RUNNING,
        STOPPED;

    }
}

