/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.host;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.samza.container.host.SystemMemoryStatistics;
import org.apache.samza.container.host.SystemStatisticsGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosixCommandBasedStatisticsGetter
implements SystemStatisticsGetter {
    private static final Logger log = LoggerFactory.getLogger(PosixCommandBasedStatisticsGetter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCommandOutput(String[] cmdArray) throws IOException {
        Process executable = Runtime.getRuntime().exec(cmdArray);
        String psOutput = null;
        try (BufferedReader processReader = null;){
            processReader = new BufferedReader(new InputStreamReader(executable.getInputStream()));
            psOutput = processReader.readLine();
        }
        return psOutput;
    }

    private long getPhysicalMemory() throws IOException {
        String commandOutput = this.getCommandOutput(new String[]{"sh", "-c", "ps -o rss= -p $PPID"});
        if (commandOutput == null) {
            throw new IOException("ps returned unexpected output: " + commandOutput);
        }
        long rssMemoryKb = Long.parseLong(commandOutput.trim());
        return rssMemoryKb * 1024L;
    }

    @Override
    public SystemMemoryStatistics getSystemMemoryStatistics() {
        try {
            long memory = this.getPhysicalMemory();
            return new SystemMemoryStatistics(memory);
        }
        catch (Exception e) {
            log.warn("Error when running ps: ", (Throwable)e);
            return null;
        }
    }
}

