/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.grouper.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.coordinator.stream.CoordinatorStreamKeySerde;
import org.apache.samza.coordinator.stream.CoordinatorStreamValueSerde;
import org.apache.samza.metadatastore.MetadataStore;
import org.apache.samza.metadatastore.MetadataStoreFactory;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssignmentManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAssignmentManager.class);
    private final Config config;
    private final Map<String, String> taskNameToContainerId = new HashMap<String, String>();
    private final Serde<String> keySerde;
    private final Serde<String> valueSerde;
    private MetadataStore metadataStore;

    public TaskAssignmentManager(Config config, MetricsRegistry metricsRegistry) {
        this(config, metricsRegistry, new CoordinatorStreamKeySerde("set-task-container-assignment"), new CoordinatorStreamValueSerde("set-task-container-assignment"));
    }

    public TaskAssignmentManager(Config config, MetricsRegistry metricsRegistry, Serde<String> keySerde, Serde<String> valueSerde) {
        this.config = config;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        MetadataStoreFactory metadataStoreFactory = Util.getObj(new JobConfig(config).getMetadataStoreFactory(), MetadataStoreFactory.class);
        this.metadataStore = metadataStoreFactory.getMetadataStore("set-task-container-assignment", config, metricsRegistry);
    }

    public void init() {
        this.metadataStore.init();
    }

    public Map<String, String> readTaskAssignment() {
        this.taskNameToContainerId.clear();
        this.metadataStore.all().forEach((keyBytes, valueBytes) -> {
            String taskName = (String)this.keySerde.fromBytes(keyBytes);
            String containerId = (String)this.valueSerde.fromBytes(valueBytes);
            if (containerId != null) {
                this.taskNameToContainerId.put(taskName, containerId);
            }
            LOG.debug("Assignment for task {}: {}", (Object)taskName, (Object)containerId);
        });
        return Collections.unmodifiableMap(new HashMap<String, String>(this.taskNameToContainerId));
    }

    public void writeTaskContainerMapping(String taskName, String containerId) {
        String existingContainerId = this.taskNameToContainerId.get(taskName);
        if (existingContainerId != null && !existingContainerId.equals(containerId)) {
            LOG.info("Task \"{}\" moved from container {} to container {}", new Object[]{taskName, existingContainerId, containerId});
        } else {
            LOG.debug("Task \"{}\" assigned to container {}", (Object)taskName, (Object)containerId);
        }
        if (containerId == null) {
            this.metadataStore.delete(this.keySerde.toBytes((Object)taskName));
            this.taskNameToContainerId.remove(taskName);
        } else {
            this.metadataStore.put(this.keySerde.toBytes((Object)taskName), this.valueSerde.toBytes((Object)containerId));
            this.taskNameToContainerId.put(taskName, containerId);
        }
    }

    public void deleteTaskContainerMappings(Iterable<String> taskNames) {
        for (String taskName : taskNames) {
            this.metadataStore.delete(this.keySerde.toBytes((Object)taskName));
            this.taskNameToContainerId.remove(taskName);
        }
    }

    public void close() {
        this.metadataStore.close();
    }
}

