/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.grouper.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.container.grouper.task.TaskNameGrouper;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.TaskModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByContainerIds
implements TaskNameGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(GroupByContainerIds.class);
    private final int startContainerCount;

    public GroupByContainerIds(int count) {
        this.startContainerCount = count;
    }

    @Override
    public Set<ContainerModel> group(Set<TaskModel> tasks) {
        ArrayList<String> containerIds = new ArrayList<String>(this.startContainerCount);
        for (int i = 0; i < this.startContainerCount; ++i) {
            containerIds.add(String.valueOf(i));
        }
        return this.group(tasks, containerIds);
    }

    @Override
    public Set<ContainerModel> group(Set<TaskModel> tasks, List<String> containersIds) {
        int i;
        if (containersIds == null) {
            return this.group(tasks);
        }
        if (containersIds.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one container");
        }
        if (tasks.isEmpty()) {
            throw new IllegalArgumentException("cannot group an empty set. containersIds=" + Arrays.toString(containersIds.toArray()));
        }
        if (containersIds.size() > tasks.size()) {
            LOG.warn("Number of containers: {} is greater than number of tasks: {}.", (Object)containersIds.size(), (Object)tasks.size());
            containersIds = containersIds.stream().sorted().limit(tasks.size()).collect(Collectors.toList());
            LOG.info("Generating containerModel with containers: {}.", containersIds);
        }
        int containerCount = containersIds.size();
        ArrayList<TaskModel> sortedTasks = new ArrayList<TaskModel>(tasks);
        Collections.sort(sortedTasks);
        Map[] taskGroups = new Map[containerCount];
        for (i = 0; i < containerCount; ++i) {
            taskGroups[i] = new HashMap();
        }
        for (i = 0; i < sortedTasks.size(); ++i) {
            TaskModel tm = (TaskModel)sortedTasks.get(i);
            taskGroups[i % containerCount].put(tm.getTaskName(), tm);
        }
        HashSet<ContainerModel> containerModels = new HashSet<ContainerModel>();
        for (int i2 = 0; i2 < containerCount; ++i2) {
            containerModels.add(new ContainerModel(containersIds.get(i2), taskGroups[i2]));
        }
        return Collections.unmodifiableSet(containerModels);
    }
}

