/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.grouper.stream;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.samza.config.Config;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.container.TaskName;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouper;
import org.apache.samza.system.SystemStreamPartition;

public class GroupByPartition
implements SystemStreamPartitionGrouper {
    private TaskConfigJava taskConfig = null;
    private Set<SystemStreamPartition> broadcastStreams = new HashSet<SystemStreamPartition>();

    public GroupByPartition() {
    }

    public GroupByPartition(Config config) {
        if (config.containsKey((Object)"task.broadcast.inputs")) {
            this.taskConfig = new TaskConfigJava(config);
            this.broadcastStreams = this.taskConfig.getBroadcastSystemStreamPartitions();
        }
    }

    public Map<TaskName, Set<SystemStreamPartition>> group(Set<SystemStreamPartition> ssps) {
        HashMap<TaskName, Set<SystemStreamPartition>> groupedMap = new HashMap<TaskName, Set<SystemStreamPartition>>();
        for (SystemStreamPartition ssp : ssps) {
            if (this.broadcastStreams.contains(ssp)) continue;
            TaskName taskName = new TaskName("Partition " + ssp.getPartition().getPartitionId());
            if (!groupedMap.containsKey(taskName)) {
                groupedMap.put(taskName, new HashSet());
            }
            ((Set)groupedMap.get(taskName)).add(ssp);
        }
        if (!this.broadcastStreams.isEmpty()) {
            for (Set value : groupedMap.values()) {
                for (SystemStreamPartition ssp : this.broadcastStreams) {
                    value.add(ssp);
                }
            }
        }
        return groupedMap;
    }
}

