/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.grouper.stream;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.samza.SamzaException;
import org.apache.samza.container.TaskName;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouper;
import org.apache.samza.system.SystemStreamPartition;

class AllSspToSingleTaskGrouper
implements SystemStreamPartitionGrouper {
    private final List<String> processorList;

    public AllSspToSingleTaskGrouper(List<String> processorList) {
        this.processorList = processorList;
    }

    public Map<TaskName, Set<SystemStreamPartition>> group(Set<SystemStreamPartition> ssps) {
        HashMap<TaskName, Set<SystemStreamPartition>> groupedMap = new HashMap<TaskName, Set<SystemStreamPartition>>();
        if (ssps == null) {
            throw new SamzaException("ssp set cannot be null!");
        }
        if (ssps.size() == 0) {
            throw new SamzaException("Cannot process stream task with no input system stream partitions");
        }
        this.processorList.forEach(processor -> {
            TaskName taskName = new TaskName(String.format("Task-%s", processor));
            groupedMap.put(taskName, ssps);
        });
        return groupedMap;
    }
}

