/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.disk;

import java.util.ArrayList;
import org.apache.samza.config.Config;
import org.apache.samza.container.disk.DiskQuotaPolicy;
import org.apache.samza.container.disk.DiskQuotaPolicyFactory;
import org.apache.samza.container.disk.NoThrottlingDiskQuotaPolicy;
import org.apache.samza.container.disk.WatermarkDiskQuotaPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkDiskQuotaPolicyFactory
implements DiskQuotaPolicyFactory {
    private static final Logger log = LoggerFactory.getLogger(WatermarkDiskQuotaPolicyFactory.class);
    private static final String POLICY_COUNT_KEY = "container.disk.quota.policy.count";

    @Override
    public DiskQuotaPolicy create(Config config) {
        int entryCount = config.getInt(POLICY_COUNT_KEY, 0);
        if (entryCount == 0) {
            log.info("Using a no throttling disk quota policy because policy entry count was missing or set to zero ({})", (Object)POLICY_COUNT_KEY);
            return new NoThrottlingDiskQuotaPolicy();
        }
        ArrayList<WatermarkDiskQuotaPolicy.Entry> entries = new ArrayList<WatermarkDiskQuotaPolicy.Entry>();
        for (int i = 0; i < entryCount; ++i) {
            double lowWaterMark = config.getDouble(String.format("container.disk.quota.policy.%d.lowWaterMark", i));
            double highWaterMark = config.getDouble(String.format("container.disk.quota.policy.%d.highWaterMark", i));
            double workFactor = config.getDouble(String.format("container.disk.quota.policy.%d.workFactor", i));
            entries.add(new WatermarkDiskQuotaPolicy.Entry(lowWaterMark, highWaterMark, workFactor));
        }
        return new WatermarkDiskQuotaPolicy(entries);
    }
}

