/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.disk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.samza.container.disk.DiskQuotaPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkDiskQuotaPolicy
implements DiskQuotaPolicy {
    private static final Comparator<Entry> POLICY_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry lhs, Entry rhs) {
            if (lhs.getHighWaterMarkPercent() > rhs.getHighWaterMarkPercent()) {
                return -1;
            }
            if (lhs.getHighWaterMarkPercent() < rhs.getHighWaterMarkPercent()) {
                return 1;
            }
            if (lhs.getLowWaterMarkPercent() > rhs.getLowWaterMarkPercent()) {
                return -1;
            }
            if (lhs.getLowWaterMarkPercent() < rhs.getLowWaterMarkPercent()) {
                return 1;
            }
            return 0;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(WatermarkDiskQuotaPolicy.class);
    private final List<Entry> entries;
    private int entryIndex = -1;

    private static String dumpPolicyEntries(List<Entry> entries) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = entries.get(i);
            sb.append(String.format("\n    Policy entry %d. Low: %f. High: %f. Work Factor: %f", i, entry.getLowWaterMarkPercent(), entry.getHighWaterMarkPercent(), entry.getWorkFactor()));
        }
        return sb.toString();
    }

    public WatermarkDiskQuotaPolicy(List<Entry> entries) {
        entries = new ArrayList<Entry>(entries);
        Collections.sort(entries, POLICY_COMPARATOR);
        this.entries = Collections.unmodifiableList(entries);
        double lastHighWaterMark = 1.0;
        double lastWorkFactor = 1.0;
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = entries.get(i);
            if (lastHighWaterMark < entry.getHighWaterMarkPercent()) {
                throw new IllegalArgumentException("Policy entry " + i + " has high water mark (" + entry.getHighWaterMarkPercent() + ") > previous high water mark (" + lastHighWaterMark + "):" + WatermarkDiskQuotaPolicy.dumpPolicyEntries(entries));
            }
            if (lastWorkFactor < entry.getWorkFactor()) {
                throw new IllegalArgumentException("Policy entry " + i + " has work factor (" + entry.getWorkFactor() + ") < previous work factor (" + lastWorkFactor + "):" + WatermarkDiskQuotaPolicy.dumpPolicyEntries(entries));
            }
            if (entry.getWorkFactor() < 0.001) {
                throw new IllegalArgumentException("Policy entry " + i + " has work factor (" + entry.getWorkFactor() + ") < minimum work factor (" + 0.001 + "):" + WatermarkDiskQuotaPolicy.dumpPolicyEntries(entries));
            }
            lastHighWaterMark = entry.getHighWaterMarkPercent();
            lastWorkFactor = entry.getWorkFactor();
        }
        log.info("Using the following disk quota enforcement entries: {}", (Object)(entries.isEmpty() ? "NONE" : WatermarkDiskQuotaPolicy.dumpPolicyEntries(entries)));
    }

    @Override
    public double apply(double availableDiskQuotaPercentage) {
        int entryIndex;
        double workFactor = this.entryIndex == -1 ? 1.0 : this.entries.get(this.entryIndex).getWorkFactor();
        for (entryIndex = this.entryIndex; entryIndex >= 0 && this.entries.get(entryIndex).getHighWaterMarkPercent() <= availableDiskQuotaPercentage; --entryIndex) {
        }
        while (entryIndex < this.entries.size() - 1 && this.entries.get(entryIndex + 1).getLowWaterMarkPercent() > availableDiskQuotaPercentage) {
            ++entryIndex;
        }
        if (entryIndex != this.entryIndex) {
            workFactor = entryIndex == -1 ? 1.0 : this.entries.get(entryIndex).getWorkFactor();
            this.entryIndex = entryIndex;
            log.info("Work factor has been updated: {}.", (Object)workFactor);
        }
        return workFactor;
    }

    public static class Entry {
        private final double lowWaterMarkPercent;
        private final double highWaterMarkPercent;
        private final double workFactor;

        public Entry(double lowWaterMarkPercent, double highWaterMarkPercent, double workFactor) {
            if (lowWaterMarkPercent < 0.0) {
                throw new IllegalArgumentException("low water mark percent (" + lowWaterMarkPercent + ") < 0");
            }
            if (highWaterMarkPercent > 1.0) {
                throw new IllegalArgumentException("high water mark percent (" + highWaterMarkPercent + ") > 1");
            }
            if (lowWaterMarkPercent > highWaterMarkPercent) {
                throw new IllegalArgumentException("low water mark percent (" + lowWaterMarkPercent + ") > high water mark percent (" + highWaterMarkPercent + ")");
            }
            if (workFactor <= 0.0) {
                throw new IllegalArgumentException("work factor (" + workFactor + ") <= 0");
            }
            if (workFactor > 1.0) {
                throw new IllegalArgumentException("work factor (" + workFactor + ") > 1");
            }
            this.lowWaterMarkPercent = lowWaterMarkPercent;
            this.highWaterMarkPercent = highWaterMarkPercent;
            this.workFactor = workFactor;
        }

        public double getLowWaterMarkPercent() {
            return this.lowWaterMarkPercent;
        }

        public double getHighWaterMarkPercent() {
            return this.highWaterMarkPercent;
        }

        public double getWorkFactor() {
            return this.workFactor;
        }
    }
}

