/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.disk;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.samza.container.disk.DiskSpaceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingScanDiskSpaceMonitor
implements DiskSpaceMonitor {
    private static final Logger log = LoggerFactory.getLogger(PollingScanDiskSpaceMonitor.class);
    private final ConcurrentMap<DiskSpaceMonitor.Listener, Boolean> listenerSet = new ConcurrentHashMap<DiskSpaceMonitor.Listener, Boolean>();
    private final Object lock = new Object();
    private final ScheduledExecutorService schedulerService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Samza PollingScanDiskSpaceMonitor Thread-%d").setDaemon(true).build());
    private final Set<Path> watchPaths;
    private final long pollingIntervalMillis;
    private State state = State.INIT;

    static long getSpaceUsed(Set<Path> paths) {
        ArrayDeque<Path> pathStack = new ArrayDeque<Path>();
        for (Path path : paths) {
            pathStack.push(path);
        }
        HashSet<Path> visited = new HashSet<Path>();
        long totalBytes = 0L;
        while (!pathStack.isEmpty()) {
            try {
                Path current = ((Path)pathStack.pop()).toRealPath(new LinkOption[0]);
                if (visited.contains(current)) continue;
                visited.add(current);
                BasicFileAttributes currentAttrs = Files.readAttributes(current, BasicFileAttributes.class, new LinkOption[0]);
                if (currentAttrs.isDirectory()) {
                    DirectoryStream<Path> directoryListing = Files.newDirectoryStream(current);
                    Throwable throwable = null;
                    try {
                        for (Path child : directoryListing) {
                            pathStack.push(child);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (directoryListing == null) continue;
                        if (throwable != null) {
                            try {
                                directoryListing.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        directoryListing.close();
                        continue;
                    }
                }
                if (!currentAttrs.isRegularFile()) continue;
                totalBytes += currentAttrs.size();
            }
            catch (IOException iOException) {}
        }
        return totalBytes;
    }

    public PollingScanDiskSpaceMonitor(Set<Path> watchPaths, long pollingIntervalMillis) {
        this.watchPaths = Collections.unmodifiableSet(new HashSet<Path>(watchPaths));
        this.pollingIntervalMillis = pollingIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case INIT: {
                    this.schedulerService.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            PollingScanDiskSpaceMonitor.this.updateSample();
                        }
                    }, this.pollingIntervalMillis, this.pollingIntervalMillis, TimeUnit.MILLISECONDS);
                    this.state = State.RUNNING;
                    break;
                }
                case RUNNING: {
                    return;
                }
                case STOPPED: {
                    throw new IllegalStateException("PollingScanDiskSpaceMonitor was stopped and cannot be restarted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.schedulerService.shutdownNow();
            this.listenerSet.clear();
            this.state = State.STOPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerListener(DiskSpaceMonitor.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.STOPPED) {
                return this.listenerSet.putIfAbsent(listener, Boolean.TRUE) == Boolean.TRUE;
            }
        }
        return false;
    }

    boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.schedulerService.awaitTermination(timeout, unit);
    }

    private void updateSample() {
        long totalBytes = PollingScanDiskSpaceMonitor.getSpaceUsed(this.watchPaths);
        for (DiskSpaceMonitor.Listener listener : this.listenerSet.keySet()) {
            try {
                listener.onUpdate(totalBytes);
            }
            catch (Throwable e) {
                log.error("Exception thrown by a listener ", e);
            }
        }
    }

    private static enum State {
        INIT,
        RUNNING,
        STOPPED;

    }
}

