/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointListener;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.CheckpointManagerFactory;
import org.apache.samza.checkpoint.OffsetManager;
import org.apache.samza.checkpoint.OffsetManager$;
import org.apache.samza.checkpoint.OffsetManagerMetrics;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MetricsConfig$;
import org.apache.samza.config.SerializerConfig$;
import org.apache.samza.config.ShellCommandConfig$;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.config.StorageConfig$;
import org.apache.samza.config.StreamConfig$;
import org.apache.samza.config.SystemConfig$;
import org.apache.samza.config.TaskConfig$;
import org.apache.samza.container.LocalityManager;
import org.apache.samza.container.RunLoopFactory;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.container.SamzaContainer$;
import org.apache.samza.container.SamzaContainer$$anonfun$45$;
import org.apache.samza.container.SamzaContainer$$anonfun$45$$anonfun$54$;
import org.apache.samza.container.SamzaContainerMetrics;
import org.apache.samza.container.SecurityManager;
import org.apache.samza.container.SecurityManagerFactory;
import org.apache.samza.container.TaskInstance;
import org.apache.samza.container.TaskInstanceExceptionHandler$;
import org.apache.samza.container.TaskInstanceMetrics;
import org.apache.samza.container.TaskInstanceMetrics$;
import org.apache.samza.container.TaskName;
import org.apache.samza.container.disk.DiskQuotaPolicy;
import org.apache.samza.container.disk.DiskQuotaPolicyFactory;
import org.apache.samza.container.disk.DiskSpaceMonitor;
import org.apache.samza.container.disk.NoThrottlingDiskQuotaPolicyFactory;
import org.apache.samza.container.disk.PollingScanDiskSpaceMonitor;
import org.apache.samza.container.host.StatisticsMonitorImpl;
import org.apache.samza.container.host.SystemMemoryStatistics;
import org.apache.samza.container.host.SystemStatisticsMonitor;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationContainerContextFactory;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.ContainerContextImpl;
import org.apache.samza.context.JobContext;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.JvmMetrics;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.serializers.IntermediateMessageSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeFactory;
import org.apache.samza.serializers.SerdeManager;
import org.apache.samza.serializers.SerializableSerde;
import org.apache.samza.serializers.StringSerde;
import org.apache.samza.serializers.model.SamzaObjectMapper;
import org.apache.samza.storage.SideInputsProcessor;
import org.apache.samza.storage.SideInputsProcessorFactory;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.TaskSideInputStorageManager;
import org.apache.samza.storage.TaskStorageManager;
import org.apache.samza.storage.TaskStorageManager$;
import org.apache.samza.system.SSPMetadataCache;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.StreamMetadataCache$;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemConsumers;
import org.apache.samza.system.SystemConsumers$;
import org.apache.samza.system.SystemConsumersMetrics;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemProducers;
import org.apache.samza.system.SystemProducersMetrics;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.chooser.DefaultChooser;
import org.apache.samza.system.chooser.DefaultChooser$;
import org.apache.samza.system.chooser.MessageChooserFactory;
import org.apache.samza.system.chooser.RoundRobinChooserFactory;
import org.apache.samza.table.TableManager;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.task.AsyncStreamTaskFactory;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.StreamTaskFactory;
import org.apache.samza.task.TaskFactory;
import org.apache.samza.task.TaskFactoryUtil;
import org.apache.samza.task.TaskInstanceCollector;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.ExponentialSleepStrategy$;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.HttpUtil$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.apache.samza.util.MetricsReporterLoader;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.SystemClock;
import org.apache.samza.util.SystemClock$;
import org.apache.samza.util.Throttleable;
import org.apache.samza.util.Util$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Random$;

public final class SamzaContainer$
implements Logging {
    public static final SamzaContainer$ MODULE$;
    private final int DEFAULT_READ_JOBMODEL_DELAY_MS;
    private final String DISK_POLL_INTERVAL_KEY;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new SamzaContainer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaContainer$ samzaContainer$ = this;
        synchronized (samzaContainer$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaContainer$ samzaContainer$ = this;
        synchronized (samzaContainer$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public int DEFAULT_READ_JOBMODEL_DELAY_MS() {
        return this.DEFAULT_READ_JOBMODEL_DELAY_MS;
    }

    public String DISK_POLL_INTERVAL_KEY() {
        return this.DISK_POLL_INTERVAL_KEY;
    }

    public JobModel readJobModel(String url, int initialDelayMs) {
        this.info((Function0<Object>)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Fetching configuration from: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1}));
            }
            {
                this.url$1 = url$1;
            }
        });
        URL x$36 = new URL(url);
        long x$33 = initialDelayMs;
        double x$34 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$1();
        long x$35 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$3();
        ExponentialSleepStrategy x$37 = new ExponentialSleepStrategy(x$34, x$33, x$35);
        int x$38 = HttpUtil$.MODULE$.read$default$2();
        return (JobModel)SamzaObjectMapper.getObjectMapper().readValue(HttpUtil$.MODULE$.read(x$36, x$38, x$37), JobModel.class);
    }

    public int readJobModel$default$2() {
        return Random$.MODULE$.nextInt(this.DEFAULT_READ_JOBMODEL_DELAY_MS()) + 1;
    }

    public File getNonLoggedStorageBaseDir(Config config, File defaultStoreBaseDir) {
        Option<String> option;
        block4: {
            File file;
            block3: {
                block2: {
                    option = JobConfig$.MODULE$.Config2Job(config).getNonLoggedStorePath();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String nonLoggedStorePath = (String)some.x();
                    file = new File(nonLoggedStorePath);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                file = defaultStoreBaseDir;
            }
            return file;
        }
        throw new MatchError(option);
    }

    public File getLoggedStorageBaseDir(Config config, File defaultStoreBaseDir) {
        Option<String> option;
        block8: {
            File file;
            block7: {
                block6: {
                    option = JobConfig$.MODULE$.Config2Job(config).getLoggedStorePath();
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    String durableStorePath = (String)some.x();
                    file = new File(durableStorePath);
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                file = defaultStoreBaseDir;
            }
            File defaultLoggedStorageBaseDir = file;
            File loggedStorageBaseDir = null;
            if (System.getenv(ShellCommandConfig$.MODULE$.ENV_LOGGED_STORE_BASE_DIR()) == null) {
                if (JobConfig$.MODULE$.Config2Job(config).getLoggedStorePath().isEmpty()) {
                    this.warn((Function0<Object>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "No override was provided for logged store base directory. This disables local state re-use on application restart. If you want to enable this feature, set LOGGED_STORE_BASE_DIR as an environment variable in all machines running the Samza container or configure job.logged.store.base.dir for your application";
                        }
                    });
                }
                loggedStorageBaseDir = defaultLoggedStorageBaseDir;
            } else {
                Tuple2 jobNameAndId = new Tuple2(JobConfig$.MODULE$.Config2Job(config).getName().getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new ConfigException("Missing required config: job.name");
                    }
                }), (Object)JobConfig$.MODULE$.Config2Job(config).getJobId());
                loggedStorageBaseDir = new File(new StringBuilder().append((Object)System.getenv(ShellCommandConfig$.MODULE$.ENV_LOGGED_STORE_BASE_DIR())).append((Object)File.separator).append(jobNameAndId._1()).append((Object)"-").append(jobNameAndId._2()).toString());
            }
            return loggedStorageBaseDir;
        }
        throw new MatchError(option);
    }

    public SamzaContainer apply(String containerId, JobModel jobModel, scala.collection.immutable.Map<String, MetricsReporter> customReporters, TaskFactory<?> taskFactory, JobContext jobContext, Option<ApplicationContainerContextFactory<ApplicationContainerContext>> applicationContainerContextFactoryOption, Option<ApplicationTaskContextFactory<ApplicationTaskContext>> applicationTaskContextFactoryOption) {
        boolean bl;
        boolean bl2;
        SecurityManager securityManager;
        Config config = jobContext.getConfig();
        ContainerModel containerModel = jobModel.getContainers().get(containerId);
        String containerName = new StringOps(Predef$.MODULE$.augmentString("samza-container-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId}));
        int maxChangeLogStreamPartitions = jobModel.maxChangeLogStreamPartitions;
        String containerPID = ManagementFactory.getRuntimeMXBean().getName();
        this.info((Function0<Object>)new Serializable(containerName){
            public static final long serialVersionUID = 0L;
            private final String containerName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting up Samza container: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName$1}));
            }
            {
                this.containerName$1 = containerName$1;
            }
        });
        this.startupLog((Function0<Object>)new Serializable(containerPID){
            public static final long serialVersionUID = 0L;
            private final String containerPID$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Samza container PID: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerPID$1}));
            }
            {
                this.containerPID$1 = containerPID$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Container PID: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerPID})));
        this.startupLog((Function0<Object>)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Using configuration: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config$1}));
            }
            {
                this.config$1 = config$1;
            }
        });
        this.startupLog((Function0<Object>)new Serializable(containerModel){
            public static final long serialVersionUID = 0L;
            private final ContainerModel containerModel$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Using container model: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerModel$1}));
            }
            {
                this.containerModel$1 = containerModel$1;
            }
        });
        MetricsRegistryMap registry = new MetricsRegistryMap(containerName);
        SamzaContainerMetrics samzaContainerMetrics = new SamzaContainerMetrics(containerName, registry);
        SystemProducersMetrics systemProducersMetrics = new SystemProducersMetrics((MetricsRegistry)registry);
        SystemConsumersMetrics systemConsumersMetrics = new SystemConsumersMetrics((MetricsRegistry)registry);
        OffsetManagerMetrics offsetManagerMetrics = new OffsetManagerMetrics((MetricsRegistry)registry);
        HighResolutionClock clock = MetricsConfig$.MODULE$.Config2Metrics(config).getMetricsTimerEnabled() ? new HighResolutionClock(){

            public long nanoTime() {
                return System.nanoTime();
            }
        } : new HighResolutionClock(){

            public long nanoTime() {
                return 0L;
            }
        };
        scala.collection.immutable.Set inputSystemStreamPartitions = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(containerModel.getTasks().values()).asScala()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Set<SystemStreamPartition> apply(TaskModel x$1) {
                return (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(x$1.getSystemStreamPartitions()).asScala();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set inputSystemStreams = ((scala.collection.immutable.Set)inputSystemStreamPartitions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SystemStream apply(SystemStreamPartition x$2) {
                return x$2.getSystemStream();
            }
        }, Set$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set inputSystems = ((scala.collection.immutable.Set)inputSystemStreams.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SystemStream x$3) {
                return x$3.getSystem();
            }
        }, Set$.MODULE$.canBuildFrom())).toSet();
        Buffer<String> systemNames = SystemConfig$.MODULE$.Config2System(config).getSystemNames();
        this.info((Function0<Object>)new Serializable(systemNames){
            public static final long serialVersionUID = 0L;
            private final Buffer systemNames$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system names: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemNames$1}));
            }
            {
                this.systemNames$1 = systemNames$1;
            }
        });
        scala.collection.immutable.Set serdeStreams = (scala.collection.immutable.Set)systemNames.foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final scala.collection.immutable.Set<SystemStream> apply(scala.collection.immutable.Set<SystemStream> x$4, String x$5) {
                return (scala.collection.immutable.Set)x$4.$plus$plus(StreamConfig$.MODULE$.Config2Stream(this.config$1).getSerdeStreams(x$5));
            }
            {
                this.config$1 = config$1;
            }
        });
        this.info((Function0<Object>)new Serializable(serdeStreams){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set serdeStreams$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got serde streams: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeStreams$1}));
            }
            {
                this.serdeStreams$1 = serdeStreams$1;
            }
        });
        scala.collection.immutable.Map systemFactories = ((TraversableOnce)systemNames.map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<String, SystemFactory> apply(String systemName) {
                String systemFactoryClassName = (String)SystemConfig$.MODULE$.Config2System(this.config$1).getSystemFactory(systemName).getOrElse((Function0)new Serializable(this, systemName){
                    public static final long serialVersionUID = 0L;
                    private final String systemName$2;

                    public final Nothing$ apply() {
                        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("A stream uses system %s, which is missing from the configuration.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$2})));
                    }
                    {
                        this.systemName$2 = systemName$2;
                    }
                });
                return new Tuple2((Object)systemName, (Object)Util$.MODULE$.getObj(systemFactoryClassName, SystemFactory.class));
            }
            {
                this.config$1 = config$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(systemFactories){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map systemFactories$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system factories: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemFactories$1.keys()}));
            }
            {
                this.systemFactories$1 = systemFactories$1;
            }
        });
        SystemAdmins systemAdmins = new SystemAdmins(config);
        this.info((Function0<Object>)new Serializable(systemAdmins){
            public static final long serialVersionUID = 0L;
            private final SystemAdmins systemAdmins$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system admins: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemAdmins$1.getSystemNames()}));
            }
            {
                this.systemAdmins$1 = systemAdmins$1;
            }
        });
        StreamMetadataCache streamMetadataCache = new StreamMetadataCache(systemAdmins, StreamMetadataCache$.MODULE$.$lessinit$greater$default$2(), StreamMetadataCache$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map<SystemStream, SystemStreamMetadata> inputStreamMetadata = streamMetadataCache.getStreamMetadata((scala.collection.immutable.Set<SystemStream>)inputSystemStreams, streamMetadataCache.getStreamMetadata$default$2());
        this.info((Function0<Object>)new Serializable(inputStreamMetadata){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map inputStreamMetadata$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got input stream metadata: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputStreamMetadata$1}));
            }
            {
                this.inputStreamMetadata$1 = inputStreamMetadata$1;
            }
        });
        scala.collection.immutable.Map consumers = ((TraversableOnce)((TraversableLike)inputSystems.map((Function1)new Serializable(config, samzaContainerMetrics, systemFactories){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            private final SamzaContainerMetrics samzaContainerMetrics$1;
            private final scala.collection.immutable.Map systemFactories$1;

            public final Tuple2<String, SystemConsumer> apply(String systemName) {
                Tuple2 tuple2;
                SystemFactory systemFactory = (SystemFactory)this.systemFactories$1.apply((Object)systemName);
                try {
                    tuple2 = new Tuple2((Object)systemName, (Object)systemFactory.getConsumer(systemName, this.config$1, (MetricsRegistry)this.samzaContainerMetrics$1.registry()));
                }
                catch (Exception exception) {
                    SamzaContainer$.MODULE$.error((Function0<Object>)new Serializable(this, systemName){
                        public static final long serialVersionUID = 0L;
                        private final String systemName$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Failed to create a consumer for %s, so skipping.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$3}));
                        }
                        {
                            this.systemName$3 = systemName$3;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    tuple2 = new Tuple2((Object)systemName, null);
                }
                return tuple2;
            }
            {
                this.config$1 = config$1;
                this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
                this.systemFactories$1 = systemFactories$1;
            }
        }, Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemConsumer> x$6) {
                return x$6._2() != null;
            }
        })).toMap(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(consumers){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map consumers$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system consumers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumers$1.keys()}));
            }
            {
                this.consumers$1 = consumers$1;
            }
        });
        scala.collection.immutable.Map producers = (scala.collection.immutable.Map)((TraversableLike)systemFactories.map((Function1)new Serializable(config, samzaContainerMetrics){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            private final SamzaContainerMetrics samzaContainerMetrics$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<String, SystemProducer> apply(Tuple2<String, SystemFactory> x0$1) {
                Tuple2 tuple2;
                Tuple2<String, SystemFactory> tuple22 = x0$1;
                if (tuple22 == null) throw new MatchError(tuple22);
                String systemName = (String)tuple22._1();
                SystemFactory systemFactory = (SystemFactory)tuple22._2();
                try {
                    tuple2 = new Tuple2((Object)systemName, (Object)systemFactory.getProducer(systemName, this.config$1, (MetricsRegistry)this.samzaContainerMetrics$1.registry()));
                    return tuple2;
                }
                catch (Exception exception) {
                    SamzaContainer$.MODULE$.error((Function0<Object>)new Serializable(this, systemName){
                        public static final long serialVersionUID = 0L;
                        private final String systemName$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Failed to create a producer for %s, so skipping.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$1}));
                        }
                        {
                            this.systemName$1 = systemName$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$2;

                        public final Exception apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    tuple2 = new Tuple2((Object)systemName, null);
                }
                return tuple2;
            }
            {
                this.config$1 = config$1;
                this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemProducer> x$7) {
                return x$7._2() != null;
            }
        });
        this.info((Function0<Object>)new Serializable(producers){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map producers$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system producers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producers$1.keys()}));
            }
            {
                this.producers$1 = producers$1;
            }
        });
        scala.collection.immutable.Map serdesFromFactories = ((TraversableOnce)SerializerConfig$.MODULE$.Config2Serializer(config).getSerdeNames().map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<String, Serde<Object>> apply(String serdeName) {
                String serdeClassName = (String)SerializerConfig$.MODULE$.Config2Serializer(this.config$1).getSerdeClass(serdeName).getOrElse((Function0)new Serializable(this, serdeName){
                    public static final long serialVersionUID = 0L;
                    private final String serdeName$4;

                    public final String apply() {
                        return SerializerConfig$.MODULE$.getSerdeFactoryName(this.serdeName$4);
                    }
                    {
                        this.serdeName$4 = serdeName$4;
                    }
                });
                Serde serde = Util$.MODULE$.getObj(serdeClassName, SerdeFactory.class).getSerde(serdeName, this.config$1);
                return new Tuple2((Object)serdeName, (Object)serde);
            }
            {
                this.config$1 = config$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(serdesFromFactories){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map serdesFromFactories$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got serdes from factories: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdesFromFactories$1.keys()}));
            }
            {
                this.serdesFromFactories$1 = serdesFromFactories$1;
            }
        });
        SerializableSerde serializableSerde = new SerializableSerde();
        scala.collection.mutable.Map serdesFromSerializedInstances = (scala.collection.mutable.Map)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)config.subset(new StringOps(Predef$.MODULE$.augmentString(SerializerConfig$.MODULE$.SERIALIZER_PREFIX())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{""})))).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.endsWith(SerializerConfig$.MODULE$.SERIALIZED_INSTANCE_SUFFIX());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).flatMap((Function1)new Serializable(serializableSerde){
            public static final long serialVersionUID = 0L;
            private final SerializableSerde serializableSerde$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<Tuple2<String, Serde<Object>>> apply(Tuple2<String, String> x0$3) {
                Iterable iterable;
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError(tuple2);
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                String serdeName = key.replace(SerializerConfig$.MODULE$.SERIALIZED_INSTANCE_SUFFIX(), "");
                SamzaContainer$.MODULE$.debug((Function0<Object>)new Serializable(this, serdeName){
                    public static final long serialVersionUID = 0L;
                    private final String serdeName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to deserialize serde instance for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeName$1}));
                    }
                    {
                        this.serdeName$1 = serdeName$1;
                    }
                });
                try {
                    byte[] bytes = Base64.getDecoder().decode(value);
                    Serde serdeInstance = (Serde)this.serializableSerde$1.fromBytes(bytes);
                    SamzaContainer$.MODULE$.debug((Function0<Object>)new Serializable(this, serdeName){
                        public static final long serialVersionUID = 0L;
                        private final String serdeName$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning serialized instance for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeName$1}));
                        }
                        {
                            this.serdeName$1 = serdeName$1;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)serdeName, (Object)serdeInstance)));
                    return iterable;
                }
                catch (Exception exception) {
                    SamzaContainer$.MODULE$.warn((Function0<Object>)new Serializable(this, value, serdeName){
                        public static final long serialVersionUID = 0L;
                        private final String value$1;
                        private final String serdeName$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid serialized instance for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeName$1, this.value$1}));
                        }
                        {
                            this.value$1 = value$1;
                            this.serdeName$1 = serdeName$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$3;

                        public final Exception apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = e$3;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.serializableSerde$1 = serializableSerde$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        this.info((Function0<Object>)new Serializable(serdesFromSerializedInstances){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map serdesFromSerializedInstances$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got serdes from serialized instances: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdesFromSerializedInstances$1.keys()}));
            }
            {
                this.serdesFromSerializedInstances$1 = serdesFromSerializedInstances$1;
            }
        });
        scala.collection.immutable.Map serdes = serdesFromFactories.$plus$plus((GenTraversableOnce)serdesFromSerializedInstances);
        Serializable buildSystemSerdeMap = new Serializable(systemNames, serdes){
            public static final long serialVersionUID = 0L;
            private final Buffer systemNames$1;
            public final scala.collection.immutable.Map serdes$1;

            public final scala.collection.immutable.Map<String, Serde<Object>> apply(Function1<String, Option<String>> getSerdeName) {
                return ((TraversableOnce)((TraversableLike)this.systemNames$1.filter((Function1)new Serializable(this, getSerdeName){
                    public static final long serialVersionUID = 0L;
                    private final Function1 getSerdeName$1;

                    public final boolean apply(String systemName) {
                        return ((Option)this.getSerdeName$1.apply((Object)systemName)).isDefined();
                    }
                    {
                        this.getSerdeName$1 = getSerdeName$1;
                    }
                })).flatMap((Function1)new Serializable(this, getSerdeName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.18 $outer;
                    private final Function1 getSerdeName$1;

                    public final Iterable<Tuple2<String, Serde<Object>>> apply(String systemName) {
                        String serdeName = (String)((Option)this.getSerdeName$1.apply((Object)systemName)).get();
                        Serde serde = (Serde)this.$outer.serdes$1.getOrElse((Object)serdeName, (Function0)new Serializable(this, serdeName){
                            public static final long serialVersionUID = 0L;
                            private final String serdeName$2;

                            public final Nothing$ apply() {
                                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("buildSystemSerdeMap: No class defined for serde: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeName$2})));
                            }
                            {
                                this.serdeName$2 = serdeName$2;
                            }
                        });
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)serde).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Serde<Object> x$8) {
                                return !(x$8 instanceof NoOpSerde);
                            }
                        }).map((Function1)new Serializable(this, systemName){
                            public static final long serialVersionUID = 0L;
                            private final String systemName$4;

                            public final Tuple2<String, Serde<Object>> apply(Serde<Object> serde) {
                                return new Tuple2((Object)this.systemName$4, serde);
                            }
                            {
                                this.systemName$4 = systemName$4;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.getSerdeName$1 = getSerdeName$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            {
                this.systemNames$1 = systemNames$1;
                this.serdes$1 = serdes$1;
            }
        };
        Serializable buildSystemStreamSerdeMap = new Serializable(inputSystemStreamPartitions, serdeStreams, serdes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set inputSystemStreamPartitions$1;
            private final scala.collection.immutable.Set serdeStreams$1;
            public final scala.collection.immutable.Map serdes$1;

            public final scala.collection.immutable.Map<SystemStream, Serde<Object>> apply(Function1<SystemStream, Option<String>> getSerdeName) {
                return ((TraversableOnce)((TraversableLike)this.serdeStreams$1.$plus$plus((GenTraversableOnce)this.inputSystemStreamPartitions$1).filter((Function1)new Serializable(this, getSerdeName){
                    public static final long serialVersionUID = 0L;
                    private final Function1 getSerdeName$2;

                    public final boolean apply(SystemStream systemStream) {
                        return ((Option)this.getSerdeName$2.apply((Object)systemStream)).isDefined();
                    }
                    {
                        this.getSerdeName$2 = getSerdeName$2;
                    }
                })).flatMap((Function1)new Serializable(this, getSerdeName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.20 $outer;
                    private final Function1 getSerdeName$2;

                    public final Iterable<Tuple2<SystemStream, Serde<Object>>> apply(SystemStream systemStream) {
                        String serdeName = (String)((Option)this.getSerdeName$2.apply((Object)systemStream)).get();
                        Serde serde = (Serde)this.$outer.serdes$1.getOrElse((Object)serdeName, (Function0)new Serializable(this, serdeName){
                            public static final long serialVersionUID = 0L;
                            private final String serdeName$3;

                            public final Nothing$ apply() {
                                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("buildSystemStreamSerdeMap: No serde found for name: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serdeName$3})));
                            }
                            {
                                this.serdeName$3 = serdeName$3;
                            }
                        });
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)serde).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Serde<Object> x$9) {
                                return !(x$9 instanceof NoOpSerde);
                            }
                        }).map((Function1)new Serializable(this, systemStream){
                            public static final long serialVersionUID = 0L;
                            private final SystemStream systemStream$3;

                            public final Tuple2<SystemStream, Serde<Object>> apply(Serde<Object> serde) {
                                return new Tuple2((Object)this.systemStream$3, serde);
                            }
                            {
                                this.systemStream$3 = systemStream$3;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.getSerdeName$2 = getSerdeName$2;
                    }
                }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            {
                this.inputSystemStreamPartitions$1 = inputSystemStreamPartitions$1;
                this.serdeStreams$1 = serdeStreams$1;
                this.serdes$1 = serdes$1;
            }
        };
        scala.collection.immutable.Map systemKeySerdes = (scala.collection.immutable.Map)buildSystemSerdeMap.apply((Object)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Option<String> apply(String systemName) {
                return SystemConfig$.MODULE$.Config2System(this.config$1).getSystemKeySerde(systemName);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.debug((Function0<Object>)new Serializable(systemKeySerdes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map systemKeySerdes$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system key serdes: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemKeySerdes$1}));
            }
            {
                this.systemKeySerdes$1 = systemKeySerdes$1;
            }
        });
        scala.collection.immutable.Map systemMessageSerdes = (scala.collection.immutable.Map)buildSystemSerdeMap.apply((Object)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Option<String> apply(String systemName) {
                return SystemConfig$.MODULE$.Config2System(this.config$1).getSystemMsgSerde(systemName);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.debug((Function0<Object>)new Serializable(systemMessageSerdes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map systemMessageSerdes$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system message serdes: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemMessageSerdes$1}));
            }
            {
                this.systemMessageSerdes$1 = systemMessageSerdes$1;
            }
        });
        scala.collection.immutable.Map systemStreamKeySerdes = (scala.collection.immutable.Map)buildSystemStreamSerdeMap.apply((Object)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Option<String> apply(SystemStream systemStream) {
                return StreamConfig$.MODULE$.Config2Stream(this.config$1).getStreamKeySerde(systemStream);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.debug((Function0<Object>)new Serializable(systemStreamKeySerdes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map systemStreamKeySerdes$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system stream key serdes: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStreamKeySerdes$1}));
            }
            {
                this.systemStreamKeySerdes$1 = systemStreamKeySerdes$1;
            }
        });
        scala.collection.immutable.Map systemStreamMessageSerdes = (scala.collection.immutable.Map)buildSystemStreamSerdeMap.apply((Object)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Option<String> apply(SystemStream systemStream) {
                return StreamConfig$.MODULE$.Config2Stream(this.config$1).getStreamMsgSerde(systemStream);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.debug((Function0<Object>)new Serializable(systemStreamMessageSerdes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map systemStreamMessageSerdes$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system stream message serdes: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStreamMessageSerdes$1}));
            }
            {
                this.systemStreamMessageSerdes$1 = systemStreamMessageSerdes$1;
            }
        });
        scala.collection.immutable.Map changeLogSystemStreams = ((TraversableOnce)((TraversableLike)StorageConfig$.MODULE$.Config2Storage(config).getStoreNames().filter((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final boolean apply(String x$10) {
                return StorageConfig$.MODULE$.Config2Storage(this.config$1).getChangelogStream(x$10).isDefined();
            }
            {
                this.config$1 = config$1;
            }
        })).map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<String, String> apply(String name) {
                return new Tuple2((Object)name, StorageConfig$.MODULE$.Config2Storage(this.config$1).getChangelogStream(name).get());
            }
            {
                this.config$1 = config$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SystemStream apply(String x$11) {
                return StreamUtil.getSystemStreamFromNames(x$11);
            }
        });
        this.info((Function0<Object>)new Serializable(changeLogSystemStreams){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map changeLogSystemStreams$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got change log system streams: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.changeLogSystemStreams$1}));
            }
            {
                this.changeLogSystemStreams$1 = changeLogSystemStreams$1;
            }
        });
        SSPMetadataCache changelogSSPMetadataCache = new SSPMetadataCache(systemAdmins, Duration.ofSeconds(5L), SystemClock$.MODULE$.instance(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.getChangelogSSPsForContainer(containerModel, (scala.collection.immutable.Map<String, SystemStream>)changeLogSystemStreams)).asJava());
        List intermediateStreams = ((TraversableOnce)StreamConfig$.MODULE$.Config2Stream(config).getStreamIds().filter((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final boolean apply(String x$12) {
                return StreamConfig$.MODULE$.Config2Stream(this.config$1).getIsIntermediateStream(x$12);
            }
            {
                this.config$1 = config$1;
            }
        })).toList();
        this.info((Function0<Object>)new Serializable(intermediateStreams){
            public static final long serialVersionUID = 0L;
            private final List intermediateStreams$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got intermediate streams: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intermediateStreams$1}));
            }
            {
                this.intermediateStreams$1 = intermediateStreams$1;
            }
        });
        scala.collection.immutable.Map sideInputStoresToSystemStreams = ((TraversableOnce)((TraversableLike)((TraversableLike)StorageConfig$.MODULE$.Config2Storage(config).getStoreNames().map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<String, Seq<String>> apply(String storeName) {
                return new Tuple2((Object)storeName, StorageConfig$.MODULE$.Config2Storage(this.config$1).getSideInputs(storeName));
            }
            {
                this.config$1 = config$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Seq<String>> x0$4) {
                Tuple2<String, Seq<String>> tuple2 = x0$4;
                if (tuple2 != null) {
                    Seq sideInputs = (Seq)tuple2._2();
                    boolean bl = sideInputs.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            public final Config config$1;

            public final Tuple2<String, Seq<SystemStream>> apply(Tuple2<String, Seq<String>> x0$5) {
                Tuple2<String, Seq<String>> tuple2 = x0$5;
                if (tuple2 != null) {
                    String storeName = (String)tuple2._1();
                    Seq sideInputs = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)storeName, sideInputs.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.32 $outer;

                        public final SystemStream apply(String x$13) {
                            return StreamUtil.getSystemStreamFromNameOrId(this.$outer.config$1, x$13);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(sideInputStoresToSystemStreams){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map sideInputStoresToSystemStreams$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got side input store system streams: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sideInputStoresToSystemStreams$1}));
            }
            {
                this.sideInputStoresToSystemStreams$1 = sideInputStoresToSystemStreams$1;
            }
        });
        scala.collection.immutable.Map controlMessageKeySerdes = ((TraversableOnce)intermediateStreams.flatMap((Function1)new Serializable(config, systemKeySerdes, systemStreamKeySerdes){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            public final scala.collection.immutable.Map systemKeySerdes$1;
            private final scala.collection.immutable.Map systemStreamKeySerdes$1;

            public final Iterable<Tuple2<SystemStream, StringSerde>> apply(String streamId) {
                SystemStream systemStream = StreamConfig$.MODULE$.Config2Stream(this.config$1).streamIdToSystemStream(streamId);
                return Option$.MODULE$.option2Iterable(this.systemStreamKeySerdes$1.get((Object)systemStream).orElse((Function0)new Serializable(this, systemStream){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.33 $outer;
                    private final SystemStream systemStream$1;

                    public final Option<Serde<Object>> apply() {
                        return this.$outer.systemKeySerdes$1.get((Object)this.systemStream$1.getSystem());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.systemStream$1 = systemStream$1;
                    }
                }).map((Function1)new Serializable(this, systemStream){
                    public static final long serialVersionUID = 0L;
                    private final SystemStream systemStream$1;

                    public final Tuple2<SystemStream, StringSerde> apply(Serde<Object> serde) {
                        return new Tuple2((Object)this.systemStream$1, (Object)new StringSerde("UTF-8"));
                    }
                    {
                        this.systemStream$1 = systemStream$1;
                    }
                }));
            }
            {
                this.config$1 = config$1;
                this.systemKeySerdes$1 = systemKeySerdes$1;
                this.systemStreamKeySerdes$1 = systemStreamKeySerdes$1;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map intermediateStreamMessageSerdes = ((TraversableOnce)intermediateStreams.flatMap((Function1)new Serializable(config, systemMessageSerdes, systemStreamMessageSerdes){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            public final scala.collection.immutable.Map systemMessageSerdes$1;
            private final scala.collection.immutable.Map systemStreamMessageSerdes$1;

            public final Iterable<Tuple2<SystemStream, IntermediateMessageSerde>> apply(String streamId) {
                SystemStream systemStream = StreamConfig$.MODULE$.Config2Stream(this.config$1).streamIdToSystemStream(streamId);
                return Option$.MODULE$.option2Iterable(this.systemStreamMessageSerdes$1.get((Object)systemStream).orElse((Function0)new Serializable(this, systemStream){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.34 $outer;
                    private final SystemStream systemStream$2;

                    public final Option<Serde<Object>> apply() {
                        return this.$outer.systemMessageSerdes$1.get((Object)this.systemStream$2.getSystem());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.systemStream$2 = systemStream$2;
                    }
                }).map((Function1)new Serializable(this, systemStream){
                    public static final long serialVersionUID = 0L;
                    private final SystemStream systemStream$2;

                    public final Tuple2<SystemStream, IntermediateMessageSerde> apply(Serde<Object> serde) {
                        return new Tuple2((Object)this.systemStream$2, (Object)new IntermediateMessageSerde(serde));
                    }
                    {
                        this.systemStream$2 = systemStream$2;
                    }
                }));
            }
            {
                this.config$1 = config$1;
                this.systemMessageSerdes$1 = systemMessageSerdes$1;
                this.systemStreamMessageSerdes$1 = systemStreamMessageSerdes$1;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        SerdeManager serdeManager = new SerdeManager((scala.collection.immutable.Map<String, Serde<Object>>)serdes, (scala.collection.immutable.Map<String, Serde<Object>>)systemKeySerdes, (scala.collection.immutable.Map<String, Serde<Object>>)systemMessageSerdes, (scala.collection.immutable.Map<SystemStream, Serde<Object>>)systemStreamKeySerdes, (scala.collection.immutable.Map<SystemStream, Serde<Object>>)systemStreamMessageSerdes, (scala.collection.immutable.Set<SystemStream>)changeLogSystemStreams.values().toSet(), (scala.collection.immutable.Map<SystemStream, Serde<String>>)controlMessageKeySerdes, (scala.collection.immutable.Map<SystemStream, Serde<Object>>)intermediateStreamMessageSerdes);
        this.info((Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up JVM metrics.";
            }
        });
        JvmMetrics jvm = new JvmMetrics((MetricsRegistry)samzaContainerMetrics.registry());
        this.info((Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up message chooser.";
            }
        });
        String chooserFactoryClassName = (String)TaskConfig$.MODULE$.Config2Task(config).getMessageChooserClass().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return RoundRobinChooserFactory.class.getName();
            }
        });
        MessageChooserFactory chooserFactory = Util$.MODULE$.getObj(chooserFactoryClassName, MessageChooserFactory.class);
        DefaultChooser chooser = DefaultChooser$.MODULE$.apply(inputStreamMetadata, chooserFactory, config, (MetricsRegistry)samzaContainerMetrics.registry(), systemAdmins);
        this.info((Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up metrics reporters.";
            }
        });
        scala.collection.immutable.Map reporters = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(MetricsReporterLoader.getMetricsReporters(MetricsConfig$.MODULE$.Config2Metrics(config), containerName)).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus(customReporters);
        this.info((Function0<Object>)new Serializable(reporters){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map reporters$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got metrics reporters: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reporters$1.keys()}));
            }
            {
                this.reporters$1 = reporters$1;
            }
        });
        Option<String> option = JobConfig$.MODULE$.Config2Job(config).getSecurityManagerFactory();
        if (option instanceof Some) {
            Some some = (Some)option;
            String securityManagerFactoryClassName = (String)some.x();
            securityManager = Util$.MODULE$.getObj(securityManagerFactoryClassName, SecurityManagerFactory.class).getSecurityManager(config);
        } else {
            securityManager = null;
        }
        SecurityManager securityManager2 = securityManager;
        this.info((Function0<Object>)new Serializable(securityManager2){
            public static final long serialVersionUID = 0L;
            private final SecurityManager securityManager$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got security manager: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.securityManager$1}));
            }
            {
                this.securityManager$1 = securityManager$1;
            }
        });
        CheckpointManager checkpointManager = (CheckpointManager)TaskConfig$.MODULE$.Config2Task(config).getCheckpointManagerFactory().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$14) {
                return x$14.isEmpty();
            }
        }).map((Function1)new Serializable(config, samzaContainerMetrics){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            private final SamzaContainerMetrics samzaContainerMetrics$1;

            public final CheckpointManager apply(String x$15) {
                return Util$.MODULE$.getObj(x$15, CheckpointManagerFactory.class).getCheckpointManager(this.config$1, (MetricsRegistry)this.samzaContainerMetrics$1.registry());
            }
            {
                this.config$1 = config$1;
                this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(checkpointManager){
            public static final long serialVersionUID = 0L;
            private final CheckpointManager checkpointManager$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got checkpoint manager: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointManager$1}));
            }
            {
                this.checkpointManager$1 = checkpointManager$1;
            }
        });
        scala.collection.immutable.Map checkpointListeners = (scala.collection.immutable.Map)((TraversableLike)consumers.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, SystemConsumer> x$16) {
                return x$16._2() instanceof CheckpointListener;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, CheckpointListener> apply(Tuple2<String, SystemConsumer> x0$6) {
                Tuple2<String, SystemConsumer> tuple2 = x0$6;
                if (tuple2 != null) {
                    String system = (String)tuple2._1();
                    SystemConsumer consumer = (SystemConsumer)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)system, (Object)((CheckpointListener)consumer));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        this.info((Function0<Object>)new Serializable(checkpointListeners){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map checkpointListeners$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got checkpointListeners : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointListeners$1}));
            }
            {
                this.checkpointListeners$1 = checkpointListeners$1;
            }
        });
        OffsetManager offsetManager = OffsetManager$.MODULE$.apply((Map<SystemStream, SystemStreamMetadata>)inputStreamMetadata, config, checkpointManager, systemAdmins, (Map<String, CheckpointListener>)checkpointListeners, offsetManagerMetrics);
        this.info((Function0<Object>)new Serializable(offsetManager){
            public static final long serialVersionUID = 0L;
            private final OffsetManager offsetManager$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got offset manager: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsetManager$1}));
            }
            {
                this.offsetManager$1 = offsetManager$1;
            }
        });
        Option<String> option2 = TaskConfig$.MODULE$.Config2Task(config).getDropDeserialization();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String dropError = (String)some.x();
            bl2 = new StringOps(Predef$.MODULE$.augmentString(dropError)).toBoolean();
        } else {
            bl2 = false;
        }
        boolean dropDeserializationError = bl2;
        Option<String> option3 = TaskConfig$.MODULE$.Config2Task(config).getDropSerialization();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String dropError = (String)some.x();
            bl = new StringOps(Predef$.MODULE$.augmentString(dropError)).toBoolean();
        } else {
            bl = false;
        }
        boolean dropSerializationError = bl;
        int pollIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)TaskConfig$.MODULE$.Config2Task(config).getPollIntervalMs().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ((Object)BoxesRunTime.boxToInteger((int)SystemConsumers$.MODULE$.DEFAULT_POLL_INTERVAL_MS())).toString();
            }
        }))).toInt();
        DefaultChooser x$39 = chooser;
        scala.collection.immutable.Map x$40 = consumers;
        SerdeManager x$41 = serdeManager;
        SystemConsumersMetrics x$42 = systemConsumersMetrics;
        boolean x$43 = dropDeserializationError;
        int x$44 = pollIntervalMs;
        Serializable x$45 = new Serializable(clock){
            public static final long serialVersionUID = 0L;
            private final HighResolutionClock clock$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.clock$1.nanoTime();
            }
            {
                this.clock$1 = clock$1;
            }
        };
        int x$46 = SystemConsumers$.MODULE$.$lessinit$greater$default$5();
        SystemConsumers consumerMultiplexer = new SystemConsumers(x$39, (scala.collection.immutable.Map<String, SystemConsumer>)x$40, x$41, x$42, x$46, x$43, x$44, (Function0<Object>)x$45);
        SystemProducers producerMultiplexer = new SystemProducers((scala.collection.immutable.Map<String, SystemProducer>)producers, serdeManager, systemProducersMetrics, dropSerializationError);
        scala.collection.immutable.Map storageEngineFactories = ((TraversableOnce)StorageConfig$.MODULE$.Config2Storage(config).getStoreNames().map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<String, StorageEngineFactory<Object, Object>> apply(String storeName) {
                String storageFactoryClassName = (String)StorageConfig$.MODULE$.Config2Storage(this.config$1).getStorageFactoryClassName(storeName).getOrElse((Function0)new Serializable(this, storeName){
                    public static final long serialVersionUID = 0L;
                    private final String storeName$2;

                    public final Nothing$ apply() {
                        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Missing storage factory for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeName$2})));
                    }
                    {
                        this.storeName$2 = storeName$2;
                    }
                });
                return new Tuple2((Object)storeName, (Object)Util$.MODULE$.getObj(storageFactoryClassName, StorageEngineFactory.class));
            }
            {
                this.config$1 = config$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.info((Function0<Object>)new Serializable(storageEngineFactories){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map storageEngineFactories$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got storage engines: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storageEngineFactories$1.keys()}));
            }
            {
                this.storageEngineFactories$1 = storageEngineFactories$1;
            }
        });
        boolean singleThreadMode = JobConfig$.MODULE$.Config2Job(config).getSingleThreadMode();
        this.info((Function0<Object>)new Serializable(singleThreadMode){
            public static final long serialVersionUID = 0L;
            private final boolean singleThreadMode$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Got single thread mode: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.singleThreadMode$1)).toString();
            }
            {
                this.singleThreadMode$1 = singleThreadMode$1;
            }
        });
        int threadPoolSize = JobConfig$.MODULE$.Config2Job(config).getThreadPoolSize();
        this.info((Function0<Object>)new Serializable(threadPoolSize){
            public static final long serialVersionUID = 0L;
            private final int threadPoolSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Got thread pool size: ").append((Object)BoxesRunTime.boxToInteger((int)this.threadPoolSize$1)).toString();
            }
            {
                this.threadPoolSize$1 = threadPoolSize$1;
            }
        });
        ExecutorService taskThreadPool = !singleThreadMode && threadPoolSize > 0 ? Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("Samza Container Thread-%d").build()) : null;
        TaskFactory finalTaskFactory = TaskFactoryUtil.finalizeTaskFactory(taskFactory, singleThreadMode, taskThreadPool);
        scala.collection.immutable.Set taskNames = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(containerModel.getTasks().values()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TaskName apply(TaskModel x$17) {
                return x$17.getTaskName();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
        ContainerContextImpl containerContext = new ContainerContextImpl(containerModel, (MetricsRegistry)samzaContainerMetrics.registry());
        Option applicationContainerContextOption = applicationContainerContextFactoryOption.map((Function1)new Serializable(jobContext, containerContext){
            public static final long serialVersionUID = 0L;
            private final JobContext jobContext$1;
            private final ContainerContextImpl containerContext$1;

            public final ApplicationContainerContext apply(ApplicationContainerContextFactory<ApplicationContainerContext> x$18) {
                return x$18.create(this.jobContext$1, (ContainerContext)this.containerContext$1);
            }
            {
                this.jobContext$1 = jobContext$1;
                this.containerContext$1 = containerContext$1;
            }
        });
        HashSet<Path> storeWatchPaths = new HashSet<Path>();
        ScheduledExecutorService timerExecutor = Executors.newSingleThreadScheduledExecutor();
        scala.collection.immutable.Map taskInstances = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(containerModel.getTasks().values()).asScala()).map((Function1)new Serializable(jobModel, jobContext, applicationTaskContextFactoryOption, config, maxChangeLogStreamPartitions, samzaContainerMetrics, systemFactories, systemAdmins, streamMetadataCache, serdes, changeLogSystemStreams, changelogSSPMetadataCache, sideInputStoresToSystemStreams, reporters, offsetManager, consumerMultiplexer, producerMultiplexer, storageEngineFactories, finalTaskFactory, containerContext, applicationContainerContextOption, storeWatchPaths, timerExecutor){
            public static final long serialVersionUID = 0L;
            private final JobModel jobModel$1;
            public final JobContext jobContext$1;
            private final Option applicationTaskContextFactoryOption$1;
            public final Config config$1;
            private final int maxChangeLogStreamPartitions$1;
            public final SamzaContainerMetrics samzaContainerMetrics$1;
            public final scala.collection.immutable.Map systemFactories$1;
            private final SystemAdmins systemAdmins$1;
            private final StreamMetadataCache streamMetadataCache$1;
            public final scala.collection.immutable.Map serdes$1;
            public final scala.collection.immutable.Map changeLogSystemStreams$1;
            private final SSPMetadataCache changelogSSPMetadataCache$1;
            public final scala.collection.immutable.Map sideInputStoresToSystemStreams$1;
            private final scala.collection.immutable.Map reporters$1;
            private final OffsetManager offsetManager$1;
            private final SystemConsumers consumerMultiplexer$1;
            private final SystemProducers producerMultiplexer$1;
            private final scala.collection.immutable.Map storageEngineFactories$1;
            private final TaskFactory finalTaskFactory$1;
            public final ContainerContextImpl containerContext$1;
            private final Option applicationContainerContextOption$1;
            public final HashSet storeWatchPaths$1;
            private final ScheduledExecutorService timerExecutor$1;

            public final Tuple2<TaskName, TaskInstance> apply(TaskModel taskModel) {
                TaskFactory taskFactory;
                block7: {
                    Object object;
                    TaskName taskName;
                    block6: {
                        block5: {
                            SamzaContainer$.MODULE$.debug((Function0<Object>)new Serializable(this, taskModel){
                                public static final long serialVersionUID = 0L;
                                private final TaskModel taskModel$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Setting up task instance: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskModel$1}));
                                }
                                {
                                    this.taskModel$1 = taskModel$1;
                                }
                            });
                            taskName = taskModel.getTaskName();
                            taskFactory = this.finalTaskFactory$1;
                            if (!(taskFactory instanceof AsyncStreamTaskFactory)) break block5;
                            AsyncStreamTaskFactory asyncStreamTaskFactory = (AsyncStreamTaskFactory)taskFactory;
                            object = asyncStreamTaskFactory.createInstance();
                            break block6;
                        }
                        if (!(taskFactory instanceof StreamTaskFactory)) break block7;
                        StreamTaskFactory streamTaskFactory = (StreamTaskFactory)taskFactory;
                        object = streamTaskFactory.createInstance();
                    }
                    Object task = object;
                    TaskInstanceMetrics taskInstanceMetrics = new TaskInstanceMetrics(new StringOps(Predef$.MODULE$.augmentString("TaskName-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskName})), TaskInstanceMetrics$.MODULE$.$lessinit$greater$default$2());
                    TaskInstanceCollector collector = new TaskInstanceCollector(this.producerMultiplexer$1, taskInstanceMetrics);
                    scala.collection.immutable.Map storeConsumers = (scala.collection.immutable.Map)this.changeLogSystemStreams$1.map((Function1)new Serializable(this, taskName, taskInstanceMetrics){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.45 $outer;
                        private final TaskName taskName$1;
                        private final TaskInstanceMetrics taskInstanceMetrics$1;

                        public final Tuple2<String, SystemConsumer> apply(Tuple2<String, SystemStream> x0$7) {
                            Tuple2<String, SystemStream> tuple2 = x0$7;
                            if (tuple2 != null) {
                                String storeName = (String)tuple2._1();
                                SystemStream changeLogSystemStream = (SystemStream)tuple2._2();
                                SystemConsumer systemConsumer = ((SystemFactory)this.$outer.systemFactories$1.getOrElse((Object)changeLogSystemStream.getSystem(), (Function0)new Serializable(this, storeName, changeLogSystemStream){
                                    public static final long serialVersionUID = 0L;
                                    private final String storeName$1;
                                    private final SystemStream changeLogSystemStream$1;

                                    public final Nothing$ apply() {
                                        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Changelog system %s for store %s does not exist in the config.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.changeLogSystemStream$1, this.storeName$1})));
                                    }
                                    {
                                        this.storeName$1 = storeName$1;
                                        this.changeLogSystemStream$1 = changeLogSystemStream$1;
                                    }
                                })).getConsumer(changeLogSystemStream.getSystem(), this.$outer.config$1, (MetricsRegistry)this.taskInstanceMetrics$1.registry());
                                this.$outer.samzaContainerMetrics$1.addStoreRestorationGauge(this.taskName$1, storeName);
                                Tuple2 tuple22 = new Tuple2((Object)storeName, (Object)systemConsumer);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.taskName$1 = taskName$1;
                            this.taskInstanceMetrics$1 = taskInstanceMetrics$1;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, storeConsumers){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map storeConsumers$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got store consumers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeConsumers$1}));
                        }
                        {
                            this.storeConsumers$1 = storeConsumers$1;
                        }
                    });
                    File defaultStoreBaseDir = new File(System.getProperty("user.dir"), "state");
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, defaultStoreBaseDir){
                        public static final long serialVersionUID = 0L;
                        private final File defaultStoreBaseDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got default storage engine base directory: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultStoreBaseDir$1}));
                        }
                        {
                            this.defaultStoreBaseDir$1 = defaultStoreBaseDir$1;
                        }
                    });
                    File nonLoggedStorageBaseDir = SamzaContainer$.MODULE$.getNonLoggedStorageBaseDir(this.config$1, defaultStoreBaseDir);
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, nonLoggedStorageBaseDir){
                        public static final long serialVersionUID = 0L;
                        private final File nonLoggedStorageBaseDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got base directory for non logged data stores: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nonLoggedStorageBaseDir$1}));
                        }
                        {
                            this.nonLoggedStorageBaseDir$1 = nonLoggedStorageBaseDir$1;
                        }
                    });
                    File loggedStorageBaseDir = SamzaContainer$.MODULE$.getLoggedStorageBaseDir(this.config$1, defaultStoreBaseDir);
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, loggedStorageBaseDir){
                        public static final long serialVersionUID = 0L;
                        private final File loggedStorageBaseDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got base directory for logged data stores: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.loggedStorageBaseDir$1}));
                        }
                        {
                            this.loggedStorageBaseDir$1 = loggedStorageBaseDir$1;
                        }
                    });
                    scala.collection.immutable.Map taskStores = (scala.collection.immutable.Map)this.storageEngineFactories$1.map((Function1)new Serializable(this, taskName, taskInstanceMetrics, collector, nonLoggedStorageBaseDir, loggedStorageBaseDir, taskModel){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.45 $outer;
                        private final TaskName taskName$1;
                        private final TaskInstanceMetrics taskInstanceMetrics$1;
                        private final TaskInstanceCollector collector$1;
                        private final File nonLoggedStorageBaseDir$1;
                        private final File loggedStorageBaseDir$1;
                        private final TaskModel taskModel$1;

                        public final Tuple2<String, StorageEngine> apply(Tuple2<String, StorageEngineFactory<Object, Object>> x0$8) {
                            Tuple2<String, StorageEngineFactory<Object, Object>> tuple2 = x0$8;
                            if (tuple2 != null) {
                                Serde serde;
                                Serde serde2;
                                String storeName = (String)tuple2._1();
                                StorageEngineFactory storageEngineFactory = (StorageEngineFactory)tuple2._2();
                                SystemStreamPartition changeLogSystemStreamPartition = this.$outer.changeLogSystemStreams$1.contains((Object)storeName) ? new SystemStreamPartition((SystemStream)this.$outer.changeLogSystemStreams$1.apply((Object)storeName), this.taskModel$1.getChangelogPartition()) : null;
                                Option<String> option = StorageConfig$.MODULE$.Config2Storage(this.$outer.config$1).getStorageKeySerde(storeName);
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    String keySerde = (String)some.x();
                                    serde2 = (Serde)this.$outer.serdes$1.getOrElse((Object)keySerde, (Function0)new Serializable(this, keySerde){
                                        public static final long serialVersionUID = 0L;
                                        private final String keySerde$1;

                                        public final Nothing$ apply() {
                                            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("StorageKeySerde: No class defined for serde: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keySerde$1})));
                                        }
                                        {
                                            this.keySerde$1 = keySerde$1;
                                        }
                                    });
                                } else {
                                    serde2 = null;
                                }
                                Serde keySerde = serde2;
                                Option<String> option2 = StorageConfig$.MODULE$.Config2Storage(this.$outer.config$1).getStorageMsgSerde(storeName);
                                if (option2 instanceof Some) {
                                    Some some = (Some)option2;
                                    String msgSerde = (String)some.x();
                                    serde = (Serde)this.$outer.serdes$1.getOrElse((Object)msgSerde, (Function0)new Serializable(this, msgSerde){
                                        public static final long serialVersionUID = 0L;
                                        private final String msgSerde$1;

                                        public final Nothing$ apply() {
                                            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("StorageMsgSerde: No class defined for serde: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.msgSerde$1})));
                                        }
                                        {
                                            this.msgSerde$1 = msgSerde$1;
                                        }
                                    });
                                } else {
                                    serde = null;
                                }
                                Serde msgSerde = serde;
                                File storeDir = changeLogSystemStreamPartition == null && !this.$outer.sideInputStoresToSystemStreams$1.contains((Object)storeName) ? TaskStorageManager$.MODULE$.getStorePartitionDir(this.nonLoggedStorageBaseDir$1, storeName, this.taskName$1) : TaskStorageManager$.MODULE$.getStorePartitionDir(this.loggedStorageBaseDir$1, storeName, this.taskName$1);
                                this.$outer.storeWatchPaths$1.add(storeDir.toPath());
                                StorageEngine storageEngine = storageEngineFactory.getStorageEngine(storeName, storeDir, keySerde, msgSerde, (MessageCollector)this.collector$1, (MetricsRegistry)this.taskInstanceMetrics$1.registry(), changeLogSystemStreamPartition, this.$outer.jobContext$1, (ContainerContext)this.$outer.containerContext$1);
                                Tuple2 tuple22 = new Tuple2((Object)storeName, (Object)storageEngine);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.taskName$1 = taskName$1;
                            this.taskInstanceMetrics$1 = taskInstanceMetrics$1;
                            this.collector$1 = collector$1;
                            this.nonLoggedStorageBaseDir$1 = nonLoggedStorageBaseDir$1;
                            this.loggedStorageBaseDir$1 = loggedStorageBaseDir$1;
                            this.taskModel$1 = taskModel$1;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, taskStores){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map taskStores$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got task stores: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskStores$1}));
                        }
                        {
                            this.taskStores$1 = taskStores$1;
                        }
                    });
                    scala.collection.immutable.Set taskSSPs = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(taskModel.getSystemStreamPartitions()).asScala()).toSet();
                    SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, taskSSPs){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Set taskSSPs$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Got task SSPs: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskSSPs$1}));
                        }
                        {
                            this.taskSSPs$1 = taskSSPs$1;
                        }
                    });
                    Tuple2 tuple2 = taskStores.partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.45 $outer;

                        public final boolean apply(Tuple2<String, StorageEngine> x0$9) {
                            Tuple2<String, StorageEngine> tuple2 = x0$9;
                            if (tuple2 != null) {
                                String storeName = (String)tuple2._1();
                                boolean bl = this.$outer.sideInputStoresToSystemStreams$1.contains((Object)storeName);
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        scala.collection.immutable.Map sideInputStores = (scala.collection.immutable.Map)tuple2._1();
                        scala.collection.immutable.Map nonSideInputStores = (scala.collection.immutable.Map)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)sideInputStores, (Object)nonSideInputStores);
                        scala.collection.immutable.Map sideInputStores2 = (scala.collection.immutable.Map)tuple23._1();
                        scala.collection.immutable.Map nonSideInputStores2 = (scala.collection.immutable.Map)tuple23._2();
                        scala.collection.immutable.Map sideInputStoresToSSPs = this.sideInputStoresToSystemStreams$1.mapValues((Function1)new Serializable(this, taskSSPs){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Set taskSSPs$1;

                            public final java.util.Set<SystemStreamPartition> apply(Seq<SystemStream> sideInputSystemStreams) {
                                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.taskSSPs$1.filter((Function1)new Serializable(this, sideInputSystemStreams){
                                    public static final long serialVersionUID = 0L;
                                    private final Seq sideInputSystemStreams$1;

                                    public final boolean apply(SystemStreamPartition ssp) {
                                        return this.sideInputSystemStreams$1.contains((Object)ssp.getSystemStream());
                                    }
                                    {
                                        this.sideInputSystemStreams$1 = sideInputSystemStreams$1;
                                    }
                                })).asJava();
                            }
                            {
                                this.taskSSPs$1 = taskSSPs$1;
                            }
                        });
                        scala.collection.immutable.Set taskSideInputSSPs = ((TraversableOnce)sideInputStoresToSSPs.values().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final scala.collection.mutable.Set<SystemStreamPartition> apply(java.util.Set<SystemStreamPartition> x$20) {
                                return (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(x$20).asScala();
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
                        SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this, taskSideInputSSPs){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Set taskSideInputSSPs$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Got task side input SSPs: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskSideInputSSPs$1}));
                            }
                            {
                                this.taskSideInputSSPs$1 = taskSideInputSSPs$1;
                            }
                        });
                        scala.collection.immutable.Map sideInputStoresToProcessor = ((TraversableOnce)sideInputStores2.keys().map((Function1)new Serializable(this, taskInstanceMetrics){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.45 $outer;
                            public final TaskInstanceMetrics taskInstanceMetrics$1;

                            public final Tuple2<String, SideInputsProcessor> apply(String storeName) {
                                return (Tuple2)StorageConfig$.MODULE$.Config2Storage(this.$outer.config$1).getSideInputsProcessorSerializedInstance(storeName).map((Function1)new Serializable(this, storeName){
                                    public static final long serialVersionUID = 0L;
                                    private final String storeName$3;

                                    public final Tuple2<String, Nothing$> apply(String serializedInstance) {
                                        return new Tuple2((Object)this.storeName$3, SerdeUtils.deserialize("Side Inputs Processor", serializedInstance));
                                    }
                                    {
                                        this.storeName$3 = storeName$3;
                                    }
                                }).orElse((Function0)new Serializable(this, storeName){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$45$$anonfun$54 $outer;
                                    public final String storeName$3;

                                    public final Option<Tuple2<String, SideInputsProcessor>> apply() {
                                        return StorageConfig$.MODULE$.Config2Storage(this.$outer.org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$$outer().config$1).getSideInputsProcessorFactory(this.storeName$3).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$45$$anonfun$54$$anonfun$apply$63 $outer;

                                            public final Tuple2<String, SideInputsProcessor> apply(String factoryClassName) {
                                                return new Tuple2((Object)this.$outer.storeName$3, (Object)Util$.MODULE$.getObj(factoryClassName, SideInputsProcessorFactory.class).getSideInputsProcessor(this.$outer.org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$anonfun$$$outer().org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$$outer().config$1, (MetricsRegistry)this.$outer.org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$anonfun$$$outer().taskInstanceMetrics$1.registry()));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }

                                    public /* synthetic */ anonfun$45$$anonfun$54 org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.storeName$3 = storeName$3;
                                    }
                                }).get();
                            }

                            public /* synthetic */ anonfun.45 org$apache$samza$container$SamzaContainer$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.taskInstanceMetrics$1 = taskInstanceMetrics$1;
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        TaskStorageManager storageManager = new TaskStorageManager(taskName, (scala.collection.immutable.Map<String, StorageEngine>)nonSideInputStores2, (scala.collection.immutable.Map<String, SystemConsumer>)storeConsumers, (scala.collection.immutable.Map<String, SystemStream>)this.changeLogSystemStreams$1, this.maxChangeLogStreamPartitions$1, this.streamMetadataCache$1, this.changelogSSPMetadataCache$1, nonLoggedStorageBaseDir, loggedStorageBaseDir, taskModel.getChangelogPartition(), this.systemAdmins$1, new StorageConfig(this.config$1).getChangeLogDeleteRetentionsInMs(), new SystemClock());
                        ObjectRef sideInputStorageManager = ObjectRef.create(null);
                        if (sideInputStores2.nonEmpty()) {
                            sideInputStorageManager.elem = new TaskSideInputStorageManager(taskName, this.streamMetadataCache$1, loggedStorageBaseDir.getPath(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)sideInputStores2).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)sideInputStoresToProcessor).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)sideInputStoresToSSPs).asJava(), this.systemAdmins$1, this.config$1, new SystemClock());
                        }
                        TableManager tableManager = new TableManager(this.config$1, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.serdes$1).asJava());
                        SamzaContainer$.MODULE$.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Got table manager";
                            }
                        });
                        TaskInstance taskInstance = this.createTaskInstance$1(task, taskInstanceMetrics, collector, taskSSPs, taskSideInputSSPs, storageManager, sideInputStorageManager, tableManager, taskModel);
                        return new Tuple2((Object)taskName, (Object)taskInstance);
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)taskFactory);
            }

            private final TaskInstance createTaskInstance$1(Object task, TaskInstanceMetrics taskInstanceMetrics$1, TaskInstanceCollector collector$1, scala.collection.immutable.Set taskSSPs$1, scala.collection.immutable.Set taskSideInputSSPs$1, TaskStorageManager storageManager$1, ObjectRef sideInputStorageManager$1, TableManager tableManager$1, TaskModel taskModel$1) {
                return new TaskInstance(task, taskModel$1, taskInstanceMetrics$1, this.systemAdmins$1, this.consumerMultiplexer$1, collector$1, this.offsetManager$1, storageManager$1, tableManager$1, (Map<String, MetricsReporter>)this.reporters$1, (scala.collection.immutable.Set<SystemStreamPartition>)taskSSPs$1, TaskInstanceExceptionHandler$.MODULE$.apply(taskInstanceMetrics$1, this.config$1), this.jobModel$1, this.streamMetadataCache$1, this.timerExecutor$1, (scala.collection.immutable.Set<SystemStreamPartition>)taskSideInputSSPs$1, (TaskSideInputStorageManager)sideInputStorageManager$1.elem, this.jobContext$1, this.containerContext$1, (Option<ApplicationContainerContext>)this.applicationContainerContextOption$1, (Option<ApplicationTaskContextFactory<ApplicationTaskContext>>)this.applicationTaskContextFactoryOption$1);
            }
            {
                this.jobModel$1 = jobModel$1;
                this.jobContext$1 = jobContext$1;
                this.applicationTaskContextFactoryOption$1 = applicationTaskContextFactoryOption$1;
                this.config$1 = config$1;
                this.maxChangeLogStreamPartitions$1 = maxChangeLogStreamPartitions$1;
                this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
                this.systemFactories$1 = systemFactories$1;
                this.systemAdmins$1 = systemAdmins$1;
                this.streamMetadataCache$1 = streamMetadataCache$1;
                this.serdes$1 = serdes$1;
                this.changeLogSystemStreams$1 = changeLogSystemStreams$1;
                this.changelogSSPMetadataCache$1 = changelogSSPMetadataCache$1;
                this.sideInputStoresToSystemStreams$1 = sideInputStoresToSystemStreams$1;
                this.reporters$1 = reporters$1;
                this.offsetManager$1 = offsetManager$1;
                this.consumerMultiplexer$1 = consumerMultiplexer$1;
                this.producerMultiplexer$1 = producerMultiplexer$1;
                this.storageEngineFactories$1 = storageEngineFactories$1;
                this.finalTaskFactory$1 = finalTaskFactory$1;
                this.containerContext$1 = containerContext$1;
                this.applicationContainerContextOption$1 = applicationContainerContextOption$1;
                this.storeWatchPaths$1 = storeWatchPaths$1;
                this.timerExecutor$1 = timerExecutor$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        long maxThrottlingDelayMs = config.getLong("container.disk.quota.delay.max.ms", TimeUnit.SECONDS.toMillis(1L));
        Runnable runLoop = RunLoopFactory.createRunLoop((scala.collection.immutable.Map<TaskName, TaskInstance>)taskInstances, consumerMultiplexer, taskThreadPool, maxThrottlingDelayMs, samzaContainerMetrics, TaskConfig$.MODULE$.Config2Task(config), clock);
        StatisticsMonitorImpl memoryStatisticsMonitor = new StatisticsMonitorImpl();
        memoryStatisticsMonitor.registerListener(new SystemStatisticsMonitor.Listener(samzaContainerMetrics){
            private final SamzaContainerMetrics samzaContainerMetrics$1;

            public void onUpdate(SystemMemoryStatistics sample) {
                long physicalMemoryBytes = sample.getPhysicalMemoryBytes();
                double physicalMemoryMb = (double)physicalMemoryBytes / 1048576.0;
                SamzaContainer$.MODULE$.logger().debug(new StringBuilder().append((Object)"Container physical memory utilization (mb): ").append((Object)BoxesRunTime.boxToDouble((double)physicalMemoryMb)).toString());
                this.samzaContainerMetrics$1.physicalMemoryMb().set((Object)BoxesRunTime.boxToDouble((double)physicalMemoryMb));
            }
            {
                this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
            }
        });
        long diskQuotaBytes = config.getLong("container.disk.quota.bytes", Long.MAX_VALUE);
        samzaContainerMetrics.diskQuotaBytes().set((Object)BoxesRunTime.boxToLong((long)diskQuotaBytes));
        String diskQuotaPolicyFactoryString = config.get("container.disk.quota.policy.factory", NoThrottlingDiskQuotaPolicyFactory.class.getName());
        DiskQuotaPolicyFactory diskQuotaPolicyFactory = Util$.MODULE$.getObj(diskQuotaPolicyFactoryString, DiskQuotaPolicyFactory.class);
        DiskQuotaPolicy diskQuotaPolicy = diskQuotaPolicyFactory.create(config);
        PollingScanDiskSpaceMonitor diskSpaceMonitor = null;
        int diskPollMillis = config.getInt(this.DISK_POLL_INTERVAL_KEY(), 0);
        if (diskPollMillis != 0) {
            diskSpaceMonitor = new PollingScanDiskSpaceMonitor(storeWatchPaths, diskPollMillis);
            diskSpaceMonitor.registerListener(new DiskSpaceMonitor.Listener(samzaContainerMetrics, runLoop, diskQuotaBytes, diskQuotaPolicy){
                private final SamzaContainerMetrics samzaContainerMetrics$1;
                private final Runnable runLoop$1;
                private final long diskQuotaBytes$1;
                private final DiskQuotaPolicy diskQuotaPolicy$1;

                public void onUpdate(long diskUsageBytes) {
                    double newWorkRate = this.diskQuotaPolicy$1.apply(1.0 - (double)diskUsageBytes / (double)this.diskQuotaBytes$1);
                    ((Throttleable)((Object)this.runLoop$1)).setWorkFactor(newWorkRate);
                    this.samzaContainerMetrics$1.executorWorkFactor().set((Object)BoxesRunTime.boxToDouble((double)((Throttleable)((Object)this.runLoop$1)).getWorkFactor()));
                    this.samzaContainerMetrics$1.diskUsageBytes().set((Object)BoxesRunTime.boxToLong((long)diskUsageBytes));
                }
                {
                    this.samzaContainerMetrics$1 = samzaContainerMetrics$1;
                    this.runLoop$1 = runLoop$1;
                    this.diskQuotaBytes$1 = diskQuotaBytes$1;
                    this.diskQuotaPolicy$1 = diskQuotaPolicy$1;
                }
            });
            this.info((Function0<Object>)new Serializable(storeWatchPaths){
                public static final long serialVersionUID = 0L;
                private final HashSet storeWatchPaths$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Initialized disk space monitor watch paths to: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeWatchPaths$1}));
                }
                {
                    this.storeWatchPaths$1 = storeWatchPaths$1;
                }
            });
        } else {
            this.info((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disk quotas disabled because polling interval is not set (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SamzaContainer$.MODULE$.DISK_POLL_INTERVAL_KEY()}));
                }
            });
        }
        this.info((Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Samza container setup complete.";
            }
        });
        Config x$47 = config;
        scala.collection.immutable.Map x$48 = taskInstances;
        Runnable x$49 = runLoop;
        SystemAdmins x$50 = systemAdmins;
        SystemConsumers x$51 = consumerMultiplexer;
        SystemProducers x$52 = producerMultiplexer;
        OffsetManager x$53 = offsetManager;
        SecurityManager x$54 = securityManager2;
        SamzaContainerMetrics x$55 = samzaContainerMetrics;
        scala.collection.immutable.Map x$56 = reporters;
        JvmMetrics x$57 = jvm;
        PollingScanDiskSpaceMonitor x$58 = diskSpaceMonitor;
        StatisticsMonitorImpl x$59 = memoryStatisticsMonitor;
        ExecutorService x$60 = taskThreadPool;
        ScheduledExecutorService x$61 = timerExecutor;
        ContainerContextImpl x$62 = containerContext;
        Option x$63 = applicationContainerContextOption;
        LocalityManager x$64 = this.$lessinit$greater$default$11();
        return new SamzaContainer(x$47, (scala.collection.immutable.Map<TaskName, TaskInstance>)x$48, x$49, x$50, x$51, x$52, x$55, x$58, x$59, x$53, x$64, x$54, (scala.collection.immutable.Map<String, MetricsReporter>)x$56, x$57, x$60, x$61, x$62, (Option<ApplicationContainerContext>)x$63);
    }

    public scala.collection.immutable.Map<String, MetricsReporter> apply$default$3() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    @VisibleForTesting
    public scala.collection.immutable.Set<SystemStreamPartition> getChangelogSSPsForContainer(ContainerModel containerModel, scala.collection.immutable.Map<String, SystemStream> changeLogSystemStreams) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(containerModel.getTasks().values()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Partition apply(TaskModel taskModel) {
                return taskModel.getChangelogPartition();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(changeLogSystemStreams){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map changeLogSystemStreams$2;

            public final scala.collection.immutable.Iterable<SystemStreamPartition> apply(Partition changelogPartition) {
                return (scala.collection.immutable.Iterable)this.changeLogSystemStreams$2.map((Function1)new Serializable(this, changelogPartition){
                    public static final long serialVersionUID = 0L;
                    private final Partition changelogPartition$1;

                    public final SystemStreamPartition apply(Tuple2<String, SystemStream> x0$10) {
                        Tuple2<String, SystemStream> tuple2 = x0$10;
                        if (tuple2 != null) {
                            SystemStream systemStream = (SystemStream)tuple2._2();
                            SystemStreamPartition systemStreamPartition = new SystemStreamPartition(systemStream, this.changelogPartition$1);
                            return systemStreamPartition;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.changelogPartition$1 = changelogPartition$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.changeLogSystemStreams$2 = changeLogSystemStreams$2;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public DiskSpaceMonitor $lessinit$greater$default$8() {
        return null;
    }

    public SystemStatisticsMonitor $lessinit$greater$default$9() {
        return null;
    }

    public OffsetManager $lessinit$greater$default$10() {
        return new OffsetManager(OffsetManager$.MODULE$.$lessinit$greater$default$1(), OffsetManager$.MODULE$.$lessinit$greater$default$2(), OffsetManager$.MODULE$.$lessinit$greater$default$3(), OffsetManager$.MODULE$.$lessinit$greater$default$4(), OffsetManager$.MODULE$.$lessinit$greater$default$5());
    }

    public LocalityManager $lessinit$greater$default$11() {
        return null;
    }

    public SecurityManager $lessinit$greater$default$12() {
        return null;
    }

    public scala.collection.immutable.Map<String, MetricsReporter> $lessinit$greater$default$13() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public JvmMetrics $lessinit$greater$default$14() {
        return null;
    }

    public ExecutorService $lessinit$greater$default$15() {
        return null;
    }

    public ScheduledExecutorService $lessinit$greater$default$16() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    private SamzaContainer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.DEFAULT_READ_JOBMODEL_DELAY_MS = 100;
        this.DISK_POLL_INTERVAL_KEY = "container.disk.poll.interval.ms";
    }
}

