/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container;

import java.util.concurrent.ExecutorService;
import org.apache.samza.SamzaException;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.container.RunLoop;
import org.apache.samza.container.SamzaContainerMetrics;
import org.apache.samza.container.TaskInstance;
import org.apache.samza.container.TaskName;
import org.apache.samza.system.SystemConsumers;
import org.apache.samza.task.AsyncRunLoop;
import org.apache.samza.util.HighResolutionClock;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters;
import scala.collection.immutable.Map;
import scala.runtime.AbstractFunction1;

public class RunLoopFactory {
    private static final Logger log = LoggerFactory.getLogger(RunLoopFactory.class);

    public static Runnable createRunLoop(Map<TaskName, TaskInstance> taskInstances, SystemConsumers consumerMultiplexer, ExecutorService threadPool, long maxThrottlingDelayMs, SamzaContainerMetrics containerMetrics, TaskConfig config, HighResolutionClock clock) {
        long taskWindowMs = config.getWindowMs();
        log.info("Got window milliseconds: {}.", (Object)taskWindowMs);
        long taskCommitMs = config.getCommitMs();
        log.info("Got commit milliseconds: {}.", (Object)taskCommitMs);
        int asyncTaskCount = taskInstances.values().count((Function1)new AbstractFunction1<TaskInstance, Object>(){

            public Boolean apply(TaskInstance t) {
                return t.isAsyncTask();
            }
        });
        if (asyncTaskCount > 0 && asyncTaskCount < taskInstances.size()) {
            throw new SamzaException("Mixing StreamTask and AsyncStreamTask is not supported");
        }
        if (asyncTaskCount == 0) {
            log.info("Run loop in single thread mode.");
            return new RunLoop(taskInstances, consumerMultiplexer, containerMetrics, maxThrottlingDelayMs, taskWindowMs, taskCommitMs, (Function0<Object>)ScalaJavaUtil.toScalaFunction(() -> clock.nanoTime()));
        }
        Integer taskMaxConcurrency = config.getMaxConcurrency();
        log.info("Got taskMaxConcurrency: {}.", (Object)taskMaxConcurrency);
        boolean isAsyncCommitEnabled = config.getAsyncCommit();
        log.info("Got asyncCommitEnabled: {}.", (Object)isAsyncCommitEnabled);
        Long callbackTimeout = config.getCallbackTimeoutMs();
        log.info("Got callbackTimeout: {}.", (Object)callbackTimeout);
        Long maxIdleMs = config.getMaxIdleMs();
        log.info("Got maxIdleMs: {}.", (Object)maxIdleMs);
        log.info("Run loop in asynchronous mode.");
        return new AsyncRunLoop((java.util.Map)JavaConverters.mapAsJavaMapConverter(taskInstances).asJava(), threadPool, consumerMultiplexer, taskMaxConcurrency, taskWindowMs, taskCommitMs, callbackTimeout, maxThrottlingDelayMs, maxIdleMs, containerMetrics, clock, isAsyncCommitEnabled);
    }
}

