/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.coordinator.stream.CoordinatorStreamKeySerde;
import org.apache.samza.coordinator.stream.CoordinatorStreamValueSerde;
import org.apache.samza.metadatastore.MetadataStore;
import org.apache.samza.metadatastore.MetadataStoreFactory;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalityManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalityManager.class);
    private final Config config;
    private final Serde<String> keySerde;
    private final Serde<String> valueSerde;
    private final MetadataStore metadataStore;

    public LocalityManager(Config config, MetricsRegistry metricsRegistry) {
        this(config, metricsRegistry, new CoordinatorStreamKeySerde("set-container-host-assignment"), new CoordinatorStreamValueSerde("set-container-host-assignment"));
    }

    LocalityManager(Config config, MetricsRegistry metricsRegistry, Serde<String> keySerde, Serde<String> valueSerde) {
        this.config = config;
        MetadataStoreFactory metadataStoreFactory = Util.getObj(new JobConfig(config).getMetadataStoreFactory(), MetadataStoreFactory.class);
        this.metadataStore = metadataStoreFactory.getMetadataStore("set-container-host-assignment", config, metricsRegistry);
        this.metadataStore.init();
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public Map<String, Map<String, String>> readContainerLocality() {
        HashMap allMappings = new HashMap();
        this.metadataStore.all().forEach((keyBytes, valueBytes) -> {
            if (valueBytes != null) {
                String locationId = (String)this.valueSerde.fromBytes(valueBytes);
                allMappings.put(this.keySerde.fromBytes(keyBytes), ImmutableMap.of((Object)"host", (Object)locationId));
            }
        });
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : allMappings.entrySet()) {
                LOG.debug(String.format("Locality for container %s: %s", entry.getKey(), entry.getValue()));
            }
        }
        return Collections.unmodifiableMap(allMappings);
    }

    public void writeContainerToHostMapping(String containerId, String hostName) {
        String existingHostMapping;
        Map<String, Map<String, String>> containerToHostMapping = this.readContainerLocality();
        Map<String, String> existingMappings = containerToHostMapping.get(containerId);
        String string = existingHostMapping = existingMappings != null ? existingMappings.get("host") : null;
        if (existingHostMapping != null && !existingHostMapping.equals(hostName)) {
            LOG.info("Container {} moved from {} to {}", new Object[]{containerId, existingHostMapping, hostName});
        } else {
            LOG.info("Container {} started at {}", (Object)containerId, (Object)hostName);
        }
        this.metadataStore.put(this.keySerde.toBytes((Object)containerId), this.valueSerde.toBytes((Object)hostName));
    }

    public void close() {
        this.metadataStore.close();
    }
}

