/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.samza.container.ContainerHeartbeatClient;
import org.apache.samza.container.ContainerHeartbeatResponse;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerHeartbeatMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerHeartbeatMonitor.class);
    private static final ThreadFactory THREAD_FACTORY = new HeartbeatThreadFactory();
    private static final int SCHEDULE_MS = 60000;
    private static final int SHUTDOWN_TIMOUT_MS = 120000;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private final Runnable onContainerExpired;
    private final ContainerHeartbeatClient containerHeartbeatClient;
    private boolean started = false;

    public ContainerHeartbeatMonitor(Runnable onContainerExpired, ContainerHeartbeatClient containerHeartbeatClient) {
        this.onContainerExpired = onContainerExpired;
        this.containerHeartbeatClient = containerHeartbeatClient;
    }

    public void start() {
        if (this.started) {
            LOG.warn("Skipping attempt to start an already started ContainerHeartbeatMonitor.");
            return;
        }
        LOG.info("Starting ContainerHeartbeatMonitor");
        this.scheduler.scheduleAtFixedRate(() -> {
            ContainerHeartbeatResponse response = this.containerHeartbeatClient.requestHeartbeat();
            if (!response.isAlive()) {
                this.scheduler.schedule(() -> {
                    LOG.error("Graceful shutdown timeout expired. Force exiting.");
                    Util.logThreadDump("Thread dump at heartbeat monitor shutdown timeout.");
                    System.exit(1);
                }, 120000L, TimeUnit.MILLISECONDS);
                this.onContainerExpired.run();
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            LOG.info("Stopping ContainerHeartbeatMonitor");
            this.scheduler.shutdown();
        }
    }

    private static class HeartbeatThreadFactory
    implements ThreadFactory {
        private static final String PREFIX = "Samza-" + ContainerHeartbeatMonitor.class.getSimpleName() + "-";
        private static final AtomicInteger INSTANCE_NUM = new AtomicInteger();

        private HeartbeatThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, PREFIX + INSTANCE_NUM.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

