/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.stream.Collectors;
import org.apache.samza.container.ContainerHeartbeatResponse;
import org.apache.samza.util.HttpUtil;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerHeartbeatClient {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerHeartbeatClient.class);
    private static final int NUM_RETRIES = 6;
    private static final int TIMEOUT_MS = 5000;
    private static final int BACKOFF_MULTIPLIER = 2;
    private final String heartbeatEndpoint;

    public ContainerHeartbeatClient(String coordinatorUrl, String executionEnvContainerId) {
        this.heartbeatEndpoint = String.format("%scontainerHeartbeat?executionContainerId=%s", coordinatorUrl, executionEnvContainerId);
    }

    public ContainerHeartbeatResponse requestHeartbeat() {
        ObjectMapper mapper = new ObjectMapper();
        String reply = "";
        try {
            reply = this.httpGet(new URL(this.heartbeatEndpoint));
            LOG.debug("Container Heartbeat got response {}", (Object)reply);
            ContainerHeartbeatResponse response = (ContainerHeartbeatResponse)mapper.readValue(reply, ContainerHeartbeatResponse.class);
            return response;
        }
        catch (Exception e) {
            LOG.error("Error in container heartbeat to JobCoordinator.", (Throwable)e);
            LOG.error("Container heartbeat expired");
            ContainerHeartbeatResponse response = new ContainerHeartbeatResponse(false);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String httpGet(URL url) throws IOException {
        int delayMillis = 1000;
        BufferedReader br = null;
        for (int currentTry = 0; currentTry < 6; ++currentTry) {
            try {
                HttpURLConnection conn = HttpUtil.getHttpConnection(url, 5000);
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                if (conn.getResponseCode() != 200) {
                    throw new IOException(String.format("HTTP error fetching url %s. Returned status code %d", url.toString(), conn.getResponseCode()));
                }
                String string = br.lines().collect(Collectors.joining());
                return string;
            }
            catch (Exception e) {
                LOG.error(String.format("Error in heartbeat request. Retrying [%d/%d].", currentTry + 1, 6), (Throwable)e);
                this.sleepUninterruptibly(delayMillis);
                delayMillis *= 2;
                continue;
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new IOException(String.format("Error fetching url: %s. Tried %d time(s).", url.toString(), 6));
    }

    private void sleepUninterruptibly(int delayMillis) {
        try {
            Thread.sleep(delayMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

