/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.MapConfig;

public class ZkConfig
extends MapConfig {
    public static final String ZK_CONNECT = "job.coordinator.zk.connect";
    public static final String ZK_SESSION_TIMEOUT_MS = "job.coordinator.zk.session.timeout.ms";
    public static final String ZK_CONNECTION_TIMEOUT_MS = "job.coordinator.zk.connection.timeout.ms";
    public static final String ZK_CONSENSUS_TIMEOUT_MS = "job.coordinator.zk.consensus.timeout.ms";
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT_MS = 30000;
    public static final int DEFAULT_CONSENSUS_TIMEOUT_MS = 40000;

    public ZkConfig(Config config) {
        super((Map)config);
    }

    public String getZkConnect() {
        if (!this.containsKey(ZK_CONNECT)) {
            throw new ConfigException("Missing job.coordinator.zk.connect config!");
        }
        return this.get(ZK_CONNECT);
    }

    public int getZkSessionTimeoutMs() {
        return this.getInt(ZK_SESSION_TIMEOUT_MS, 30000);
    }

    public int getZkConnectionTimeoutMs() {
        return this.getInt(ZK_CONNECTION_TIMEOUT_MS, 60000);
    }

    public int getZkBarrierTimeoutMs() {
        return this.getInt(ZK_CONSENSUS_TIMEOUT_MS, 40000);
    }
}

