/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.Partition;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.CheckpointManagerFactory;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class TaskConfigJava
extends MapConfig {
    public static final String TASK_SHUTDOWN_MS = "task.shutdown.ms";
    public static final long DEFAULT_TASK_SHUTDOWN_MS = 30000L;
    public static final String BROADCAST_INPUT_STREAMS = "task.broadcast.inputs";
    private static final String BROADCAST_STREAM_PATTERN = "^[\\d]+$";
    private static final String BROADCAST_STREAM_RANGE_PATTERN = "^\\[[\\d]+\\-[\\d]+\\]$";
    public static final String CHECKPOINT_MANAGER_FACTORY = "task.checkpoint.factory";
    public static final Logger LOGGER = LoggerFactory.getLogger(TaskConfigJava.class);

    public TaskConfigJava(Config config) {
        super((Map)config);
    }

    public String getCheckpointManagerFactoryName() {
        return this.get(CHECKPOINT_MANAGER_FACTORY, null);
    }

    public CheckpointManager getCheckpointManager(MetricsRegistry metricsRegistry) {
        String checkpointManagerFactoryName = this.getCheckpointManagerFactoryName();
        if (StringUtils.isNotBlank((CharSequence)checkpointManagerFactoryName)) {
            CheckpointManager checkpointManager = Util.getObj(checkpointManagerFactoryName, CheckpointManagerFactory.class).getCheckpointManager((Config)this, metricsRegistry);
            return checkpointManager;
        }
        return null;
    }

    public Set<SystemStreamPartition> getBroadcastSystemStreamPartitions() {
        HashSet<SystemStreamPartition> systemStreamPartitionSet = new HashSet<SystemStreamPartition>();
        List systemStreamPartitions = this.getList(BROADCAST_INPUT_STREAMS, Collections.emptyList());
        for (String systemStreamPartition : systemStreamPartitions) {
            int hashPosition = systemStreamPartition.indexOf("#");
            if (hashPosition == -1) {
                throw new IllegalArgumentException("incorrect format in " + systemStreamPartition + ". Broadcast stream names should be in the form 'system.stream#partitionId' or 'system.stream#[partitionN-partitionM]'");
            }
            String systemStreamName = systemStreamPartition.substring(0, hashPosition);
            String partitionSegment = systemStreamPartition.substring(hashPosition + 1);
            SystemStream systemStream = StreamUtil.getSystemStreamFromNames(systemStreamName);
            if (Pattern.matches(BROADCAST_STREAM_PATTERN, partitionSegment)) {
                systemStreamPartitionSet.add(new SystemStreamPartition(systemStream, new Partition(Integer.valueOf(partitionSegment).intValue())));
                continue;
            }
            if (Pattern.matches(BROADCAST_STREAM_RANGE_PATTERN, partitionSegment)) {
                int partitionEnd;
                int partitionStart = Integer.valueOf(partitionSegment.substring(1, partitionSegment.lastIndexOf("-")));
                if (partitionStart > (partitionEnd = Integer.valueOf(partitionSegment.substring(partitionSegment.lastIndexOf("-") + 1, partitionSegment.indexOf("]"))).intValue())) {
                    LOGGER.warn("The starting partition in stream " + systemStream.toString() + " is bigger than the ending Partition. No partition is added");
                }
                for (int i = partitionStart; i <= partitionEnd; ++i) {
                    systemStreamPartitionSet.add(new SystemStreamPartition(systemStream, new Partition(i)));
                }
                continue;
            }
            throw new IllegalArgumentException("incorrect format in " + systemStreamPartition + ". Broadcast stream names should be in the form 'system.stream#partitionId' or 'system.stream#[partitionN-partitionM]'");
        }
        return systemStreamPartitionSet;
    }

    public Set<SystemStream> getBroadcastSystemStreams() {
        HashSet<SystemStream> broadcastSS = new HashSet<SystemStream>();
        Set<SystemStreamPartition> broadcastSSPs = this.getBroadcastSystemStreamPartitions();
        for (SystemStreamPartition bssp : broadcastSSPs) {
            broadcastSS.add(bssp.getSystemStream());
        }
        return Collections.unmodifiableSet(broadcastSS);
    }

    public Set<SystemStream> getAllInputStreams() {
        HashSet<SystemStream> allInputSS = new HashSet<SystemStream>();
        TaskConfig taskConfig = TaskConfig.Config2Task((Config)this);
        allInputSS.addAll((Set)JavaConverters.setAsJavaSetConverter(taskConfig.getInputStreams()).asJava());
        allInputSS.addAll(this.getBroadcastSystemStreams());
        return Collections.unmodifiableSet(allInputSS);
    }

    public long getShutdownMs() {
        String shutdownMs = this.get(TASK_SHUTDOWN_MS);
        try {
            return Long.parseLong(shutdownMs);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn(String.format("Unable to parse user-configure value for %s - %s. Using default value %d", TASK_SHUTDOWN_MS, shutdownMs, 30000L));
            return 30000L;
        }
    }
}

