/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.coordinator.CoordinationUtilsFactory;
import org.apache.samza.standalone.PassthroughCoordinationUtilsFactory;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;
import org.apache.samza.util.Util;
import org.apache.samza.zk.ZkCoordinationUtilsFactory;
import org.apache.samza.zk.ZkJobCoordinatorFactory;

public class JobCoordinatorConfig
extends MapConfig {
    public static final String JOB_COORDINATOR_FACTORY = "job.coordinator.factory";
    public static final String DEFAULT_COORDINATOR_FACTORY = ZkJobCoordinatorFactory.class.getName();
    private static final String AZURE_COORDINATION_UTILS_FACTORY = "org.apache.samza.coordinator.AzureCoordinationUtilsFactory";
    private static final String AZURE_COORDINATOR_FACTORY = "org.apache.samza.coordinator.AzureJobCoordinatorFactory";

    public JobCoordinatorConfig(Config config) {
        super((Map)config);
    }

    public String getJobCoordinationUtilsFactoryClassName() {
        String coordinationUtilsFactory;
        String coordinatorFactory = this.get(JOB_COORDINATOR_FACTORY, DEFAULT_COORDINATOR_FACTORY);
        if (AZURE_COORDINATOR_FACTORY.equals(coordinatorFactory)) {
            coordinationUtilsFactory = AZURE_COORDINATION_UTILS_FACTORY;
        } else if (PassthroughJobCoordinatorFactory.class.getName().equals(coordinatorFactory)) {
            coordinationUtilsFactory = PassthroughCoordinationUtilsFactory.class.getName();
        } else if (ZkJobCoordinatorFactory.class.getName().equals(coordinatorFactory)) {
            coordinationUtilsFactory = ZkCoordinationUtilsFactory.class.getName();
        } else {
            throw new SamzaException(String.format("Coordination factory: %s defined by the config: %s is invalid.", coordinatorFactory, JOB_COORDINATOR_FACTORY));
        }
        try {
            Class.forName(coordinationUtilsFactory);
        }
        catch (ClassNotFoundException e) {
            throw new SamzaException("Failed to validate config value for job.coordinator.factory = " + coordinationUtilsFactory, (Throwable)e);
        }
        return coordinationUtilsFactory;
    }

    public CoordinationUtilsFactory getCoordinationUtilsFactory() {
        String coordinationUtilsFactoryClass = this.getJobCoordinationUtilsFactoryClassName();
        return Util.getObj(coordinationUtilsFactoryClass, CoordinationUtilsFactory.class);
    }

    public String getJobCoordinatorFactoryClassName() {
        String jobCoordinatorFactoryClassName = this.get(JOB_COORDINATOR_FACTORY);
        if (Strings.isNullOrEmpty((String)jobCoordinatorFactoryClassName)) {
            return ZkJobCoordinatorFactory.class.getName();
        }
        return jobCoordinatorFactoryClassName;
    }
}

