/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;

public class JavaTableConfig
extends MapConfig {
    public static final String TABLES_PREFIX = "tables.";
    public static final String TABLE_ID_PREFIX = "tables.%s";
    public static final String TABLE_PROVIDER_FACTORY_SUFFIX = ".provider.factory";
    public static final String TABLE_PROVIDER_FACTORY = String.format("%s.provider.factory", "tables.%s");
    public static final String TABLE_KEY_SERDE = String.format("%s.key.serde", "tables.%s");
    public static final String TABLE_VALUE_SERDE = String.format("%s.value.serde", "tables.%s");

    public JavaTableConfig(Config config) {
        super((Map)config);
    }

    public List<String> getTableIds() {
        Config subConfig = this.subset(TABLES_PREFIX, true);
        Set tableNames = subConfig.keySet().stream().filter(k -> k.endsWith(TABLE_PROVIDER_FACTORY_SUFFIX)).map(k -> k.replace(TABLE_PROVIDER_FACTORY_SUFFIX, "")).collect(Collectors.toSet());
        return new LinkedList<String>(tableNames);
    }

    public String getTableProviderFactory(String tableId) {
        return this.get(String.format(TABLE_PROVIDER_FACTORY, tableId), null);
    }

    public String getKeySerde(String tableId) {
        return this.get(String.format(TABLE_KEY_SERDE, tableId), null);
    }

    public String getValueSerde(String tableId) {
        return this.get(String.format(TABLE_VALUE_SERDE, tableId), null);
    }
}

