/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.util.Util;

public class JavaSystemConfig
extends MapConfig {
    public static final String SYSTEM_PREFIX = "systems.";
    public static final String SYSTEM_FACTORY_SUFFIX = ".samza.factory";
    public static final String SYSTEM_FACTORY_FORMAT = "systems.%s.samza.factory";
    private static final String SYSTEM_DEFAULT_STREAMS_PREFIX_FORMAT = "systems.%s.default.stream.";
    private static final String EMPTY = "";

    public JavaSystemConfig(Config config) {
        super((Map)config);
    }

    public String getSystemFactory(String name) {
        if (name == null) {
            return null;
        }
        String systemFactory = String.format(SYSTEM_FACTORY_FORMAT, name);
        String value = this.get(systemFactory, null);
        return StringUtils.isBlank((CharSequence)value) ? null : value;
    }

    public List<String> getSystemNames() {
        Config subConf = this.subset(SYSTEM_PREFIX, true);
        ArrayList<String> systemNames = new ArrayList<String>();
        for (Map.Entry entry : subConf.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(SYSTEM_FACTORY_SUFFIX)) continue;
            systemNames.add(key.replace(SYSTEM_FACTORY_SUFFIX, EMPTY));
        }
        return systemNames;
    }

    public Map<String, SystemAdmin> getSystemAdmins() {
        return this.getSystemFactories().entrySet().stream().collect(Collectors.toMap(systemNameToFactoryEntry -> (String)systemNameToFactoryEntry.getKey(), systemNameToFactoryEntry -> ((SystemFactory)systemNameToFactoryEntry.getValue()).getAdmin((String)systemNameToFactoryEntry.getKey(), (Config)this)));
    }

    public SystemAdmin getSystemAdmin(String systemName) {
        return this.getSystemAdmins().get(systemName);
    }

    public Map<String, SystemFactory> getSystemFactories() {
        Map<String, SystemFactory> systemFactories = this.getSystemNames().stream().collect(Collectors.toMap(systemName -> systemName, systemName -> {
            String systemFactoryClassName = this.getSystemFactory((String)systemName);
            if (systemFactoryClassName == null) {
                throw new SamzaException(String.format("A stream uses system %s, which is missing from the configuration.", systemName));
            }
            return Util.getObj(systemFactoryClassName, SystemFactory.class);
        }));
        return systemFactories;
    }

    public Config getDefaultStreamProperties(String systemName) {
        return this.subset(String.format(SYSTEM_DEFAULT_STREAMS_PREFIX_FORMAT, systemName), true);
    }
}

