/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.execution.StreamManager;

public class JavaStorageConfig
extends MapConfig {
    private static final String FACTORY_SUFFIX = ".factory";
    private static final String STORE_PREFIX = "stores.";
    private static final String FACTORY = "stores.%s.factory";
    private static final String KEY_SERDE = "stores.%s.key.serde";
    private static final String MSG_SERDE = "stores.%s.msg.serde";
    private static final String CHANGELOG_STREAM = "stores.%s.changelog";
    private static final String CHANGELOG_SYSTEM = "job.changelog.system";
    private static final String ACCESSLOG_STREAM_SUFFIX = "access-log";
    private static final String ACCESSLOG_SAMPLING_RATIO = "stores.%s.accesslog.sampling.ratio";
    private static final String ACCESSLOG_ENABLED = "stores.%s.accesslog.enabled";
    private static final int DEFAULT_ACCESSLOG_SAMPLING_RATIO = 50;
    public static final String SIDE_INPUTS = "stores.%s.side.inputs";
    public static final String SIDE_INPUTS_PROCESSOR_FACTORY = "stores.%s.side.inputs.processor.factory";
    public static final String SIDE_INPUTS_PROCESSOR_SERIALIZED_INSTANCE = "stores.%s.side.inputs.processor.serialized.instance";

    public JavaStorageConfig(Config config) {
        super((Map)config);
    }

    public List<String> getStoreNames() {
        Config subConfig = this.subset(STORE_PREFIX, true);
        ArrayList<String> storeNames = new ArrayList<String>();
        for (String key : subConfig.keySet()) {
            if (!key.endsWith(FACTORY_SUFFIX)) continue;
            storeNames.add(key.substring(0, key.length() - FACTORY_SUFFIX.length()));
        }
        return storeNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getChangelogStream(String storeName) {
        String systemStreamRes;
        String systemStream = StringUtils.trimToNull((String)this.get(String.format(CHANGELOG_STREAM, storeName), null));
        if (systemStream != null && !systemStream.contains(".")) {
            String changelogSystem = this.getChangelogSystem();
            if (changelogSystem == null) throw new SamzaException("changelog system is not defined:" + systemStream);
            systemStreamRes = changelogSystem + "." + systemStream;
        } else {
            systemStreamRes = systemStream;
        }
        if (systemStreamRes == null) return systemStreamRes;
        return StreamManager.createUniqueNameForBatch(systemStreamRes, (Config)this);
    }

    public boolean getAccessLogEnabled(String storeName) {
        return this.getBoolean(String.format(ACCESSLOG_ENABLED, storeName), false);
    }

    public String getAccessLogStream(String changeLogStream) {
        return String.format("%s-%s", changeLogStream, ACCESSLOG_STREAM_SUFFIX);
    }

    public int getAccessLogSamplingRatio(String storeName) {
        return this.getInt(String.format(ACCESSLOG_SAMPLING_RATIO, storeName), 50);
    }

    public String getStorageFactoryClassName(String storeName) {
        return this.get(String.format(FACTORY, storeName), null);
    }

    public String getStorageKeySerde(String storeName) {
        return this.get(String.format(KEY_SERDE, storeName), null);
    }

    public String getStorageMsgSerde(String storeName) {
        return this.get(String.format(MSG_SERDE, storeName), null);
    }

    public String getChangelogSystem() {
        return this.get(CHANGELOG_SYSTEM, this.get(JobConfig.JOB_DEFAULT_SYSTEM(), null));
    }

    public List<String> getSideInputs(String storeName) {
        return Optional.ofNullable(this.get(String.format(SIDE_INPUTS, storeName), null)).map(inputs -> Stream.of(inputs.split(",")).map(String::trim).filter(input -> !input.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String getSideInputsProcessorFactory(String storeName) {
        return this.get(String.format(SIDE_INPUTS_PROCESSOR_FACTORY, storeName), null);
    }

    public String getSideInputsProcessorSerializedInstance(String storeName) {
        return this.get(String.format(SIDE_INPUTS_PROCESSOR_SERIALIZED_INSTANCE, storeName), null);
    }
}

