/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;

public class JavaSerializerConfig
extends MapConfig {
    private static final String SERIALIZER_PREFIX = "serializers.registry.%s";
    private static final String SERDE = "serializers.registry.%s.class";

    public JavaSerializerConfig(Config config) {
        super((Map)config);
    }

    public String getSerdeClass(String name) {
        return this.get(String.format(SERDE, name), null);
    }

    public List<String> getSerdeNames() {
        ArrayList<String> results = new ArrayList<String>();
        Config subConfig = this.subset(String.format(SERIALIZER_PREFIX, ""), true);
        for (String key : subConfig.keySet()) {
            if (!key.endsWith(".class")) continue;
            results.add(key.replace(".class", ""));
        }
        return results;
    }
}

