/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigRewriter;
import org.apache.samza.config.MapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfigRewriter
implements ConfigRewriter {
    public static final String SAMZA_KEY_PREFIX = "SAMZA_";
    public static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentConfigRewriter.class);

    public Config rewrite(String name, Config config) {
        return this.rewrite(config, System.getenv());
    }

    protected Config rewrite(Config config, Map<String, String> env) {
        String key;
        HashMap<String, String> envConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().startsWith(SAMZA_KEY_PREFIX)) continue;
            key = EnvironmentConfigRewriter.renameKey(entry.getKey());
            String value = entry.getValue();
            if (config.containsKey((Object)key)) {
                LOGGER.info(String.format("Overriding property from environment: %s=%s", key, value));
            } else {
                LOGGER.info(String.format("Setting property from environment: %s=%s", key, value));
            }
            envConfig.put(key, value);
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            key = entry.getKey();
            if (envConfig.containsKey(key) || !envConfig.containsKey(key.toLowerCase())) continue;
            throw new IllegalArgumentException(String.format("Can't override property from environment with mixed case: %s", key));
        }
        return new MapConfig(Arrays.asList(config, envConfig));
    }

    protected static String renameKey(String envName) {
        if (envName.length() <= SAMZA_KEY_PREFIX.length()) {
            throw new IllegalArgumentException();
        }
        String configName = envName.substring(SAMZA_KEY_PREFIX.length());
        return configName.toLowerCase().replace('_', '.');
    }
}

