/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.system.SystemStream;

public class DefaultChooserConfig
extends MapConfig {
    private static final String BATCH_SIZE = "task.consumer.batch.size";
    private final TaskConfigJava taskConfigJava;
    private final StreamConfig streamConfig;

    public DefaultChooserConfig(Config config) {
        super((Map)config);
        this.taskConfigJava = new TaskConfigJava(config);
        this.streamConfig = new StreamConfig(config);
    }

    public int getChooserBatchSize() {
        return this.getInt(BATCH_SIZE, 0);
    }

    public Set<SystemStream> getBootstrapStreams() {
        HashSet<SystemStream> bootstrapInputs = new HashSet<SystemStream>();
        Set<SystemStream> allInputs = this.taskConfigJava.getAllInputStreams();
        for (SystemStream systemStream : allInputs) {
            if (!this.streamConfig.getBootstrapEnabled(systemStream)) continue;
            bootstrapInputs.add(systemStream);
        }
        return Collections.unmodifiableSet(bootstrapInputs);
    }

    public Map<SystemStream, Integer> getPriorityStreams() {
        Set<SystemStream> allInputs = this.taskConfigJava.getAllInputStreams();
        HashMap<SystemStream, Integer> priorityStreams = new HashMap<SystemStream, Integer>();
        for (SystemStream systemStream : allInputs) {
            int priority = this.streamConfig.getPriority(systemStream);
            if (priority < 0) continue;
            priorityStreams.put(systemStream, priority);
        }
        return Collections.unmodifiableMap(priorityStreams);
    }
}

