/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManagerConfig
extends MapConfig {
    private static final Logger log = LoggerFactory.getLogger(ClusterManagerConfig.class);
    private static final String CLUSTER_MANAGER_FACTORY = "samza.cluster-manager.factory";
    private static final String CLUSTER_MANAGER_FACTORY_DEFAULT = "org.apache.samza.job.yarn.YarnResourceManagerFactory";
    private static final String ALLOCATOR_SLEEP_MS = "cluster-manager.allocator.sleep.ms";
    public static final String YARN_ALLOCATOR_SLEEP_MS = "yarn.allocator.sleep.ms";
    private static final int DEFAULT_ALLOCATOR_SLEEP_MS = 3600;
    public static final String CONTAINER_REQUEST_TIMEOUT_MS = "yarn.container.request.timeout.ms";
    public static final String CLUSTER_MANAGER_REQUEST_TIMEOUT_MS = "cluster-manager.container.request.timeout.ms";
    private static final int DEFAULT_CONTAINER_REQUEST_TIMEOUT_MS = 5000;
    public static final String HOST_AFFINITY_ENABLED = "yarn.samza.host-affinity.enabled";
    public static final String CLUSTER_MANAGER_HOST_AFFINITY_ENABLED = "job.host-affinity.enabled";
    public static final String CONTAINER_MAX_CPU_CORES = "yarn.container.cpu.cores";
    public static final String CLUSTER_MANAGER_MAX_CORES = "cluster-manager.container.cpu.cores";
    private static final int DEFAULT_CPU_CORES = 1;
    public static final String CONTAINER_MAX_MEMORY_MB = "yarn.container.memory.mb";
    public static final String CLUSTER_MANAGER_MEMORY_MB = "cluster-manager.container.memory.mb";
    private static final int DEFAULT_CONTAINER_MEM = 1024;
    public static final String CONTAINER_RETRY_WINDOW_MS = "yarn.container.retry.window.ms";
    public static final String CLUSTER_MANAGER_RETRY_WINDOW_MS = "cluster-manager.container.retry.window.ms";
    private static final int DEFAULT_CONTAINER_RETRY_WINDOW_MS = 300000;
    public static final String CONTAINER_RETRY_COUNT = "yarn.container.retry.count";
    public static final String CLUSTER_MANAGER_CONTAINER_RETRY_COUNT = "cluster-manager.container.retry.count";
    private static final int DEFAULT_CONTAINER_RETRY_COUNT = 8;
    public static final String CLUSTER_MANAGER_SLEEP_MS = "cluster-manager.jobcoordinator.sleep.interval.ms";
    private static final int DEFAULT_CLUSTER_MANAGER_SLEEP_MS = 1000;
    private static final String JOB_JMX_ENABLED = "job.jmx.enabled";
    private static final String AM_JMX_ENABLED = "yarn.am.jmx.enabled";
    private static final String CLUSTER_MANAGER_JMX_ENABLED = "cluster-manager.jobcoordinator.jmx.enabled";

    public ClusterManagerConfig(Config config) {
        super((Map)config);
    }

    public int getAllocatorSleepTime() {
        if (this.containsKey(ALLOCATOR_SLEEP_MS)) {
            return this.getInt(ALLOCATOR_SLEEP_MS);
        }
        if (this.containsKey(YARN_ALLOCATOR_SLEEP_MS)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)YARN_ALLOCATOR_SLEEP_MS, (Object)ALLOCATOR_SLEEP_MS);
            return this.getInt(YARN_ALLOCATOR_SLEEP_MS);
        }
        return 3600;
    }

    public int getNumCores() {
        if (this.containsKey(CLUSTER_MANAGER_MAX_CORES)) {
            return this.getInt(CLUSTER_MANAGER_MAX_CORES);
        }
        if (this.containsKey(CONTAINER_MAX_CPU_CORES)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)CONTAINER_MAX_CPU_CORES, (Object)CLUSTER_MANAGER_MAX_CORES);
            return this.getInt(CONTAINER_MAX_CPU_CORES);
        }
        return 1;
    }

    public int getContainerMemoryMb() {
        if (this.containsKey(CLUSTER_MANAGER_MEMORY_MB)) {
            return this.getInt(CLUSTER_MANAGER_MEMORY_MB);
        }
        if (this.containsKey(CONTAINER_MAX_MEMORY_MB)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)CONTAINER_MAX_MEMORY_MB, (Object)CLUSTER_MANAGER_MEMORY_MB);
            return this.getInt(CONTAINER_MAX_MEMORY_MB);
        }
        return 1024;
    }

    public boolean getHostAffinityEnabled() {
        if (this.containsKey(CLUSTER_MANAGER_HOST_AFFINITY_ENABLED)) {
            return this.getBoolean(CLUSTER_MANAGER_HOST_AFFINITY_ENABLED);
        }
        if (this.containsKey(HOST_AFFINITY_ENABLED)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)HOST_AFFINITY_ENABLED, (Object)CLUSTER_MANAGER_HOST_AFFINITY_ENABLED);
            return this.getBoolean(HOST_AFFINITY_ENABLED);
        }
        return false;
    }

    public int getContainerRequestTimeout() {
        if (this.containsKey(CLUSTER_MANAGER_REQUEST_TIMEOUT_MS)) {
            return this.getInt(CLUSTER_MANAGER_REQUEST_TIMEOUT_MS);
        }
        if (this.containsKey(CONTAINER_REQUEST_TIMEOUT_MS)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)CONTAINER_REQUEST_TIMEOUT_MS, (Object)CLUSTER_MANAGER_REQUEST_TIMEOUT_MS);
            return this.getInt(CONTAINER_REQUEST_TIMEOUT_MS);
        }
        return 5000;
    }

    public int getContainerRetryCount() {
        if (this.containsKey(CLUSTER_MANAGER_CONTAINER_RETRY_COUNT)) {
            return this.getInt(CLUSTER_MANAGER_CONTAINER_RETRY_COUNT);
        }
        if (this.containsKey(CONTAINER_RETRY_COUNT)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)CONTAINER_RETRY_COUNT, (Object)CLUSTER_MANAGER_CONTAINER_RETRY_COUNT);
            return this.getInt(CONTAINER_RETRY_COUNT);
        }
        return 8;
    }

    public int getContainerRetryWindowMs() {
        if (this.containsKey(CLUSTER_MANAGER_RETRY_WINDOW_MS)) {
            return this.getInt(CLUSTER_MANAGER_RETRY_WINDOW_MS);
        }
        if (this.containsKey(CONTAINER_RETRY_WINDOW_MS)) {
            log.info("Configuration {} is deprecated. Please use {}", (Object)CONTAINER_RETRY_WINDOW_MS, (Object)CLUSTER_MANAGER_RETRY_WINDOW_MS);
            return this.getInt(CONTAINER_RETRY_WINDOW_MS);
        }
        return 300000;
    }

    public int getJobCoordinatorSleepInterval() {
        return this.getInt(CLUSTER_MANAGER_SLEEP_MS, 1000);
    }

    public String getContainerManagerClass() {
        return this.get(CLUSTER_MANAGER_FACTORY, CLUSTER_MANAGER_FACTORY_DEFAULT);
    }

    public boolean getJmxEnabledOnJobCoordinator() {
        if (this.containsKey(CLUSTER_MANAGER_JMX_ENABLED)) {
            log.warn("Configuration {} is deprecated. Please use {}", (Object)CLUSTER_MANAGER_JMX_ENABLED, (Object)JOB_JMX_ENABLED);
            return this.getBoolean(CLUSTER_MANAGER_JMX_ENABLED);
        }
        if (this.containsKey(AM_JMX_ENABLED)) {
            log.warn("Configuration {} is deprecated. Please use {}", (Object)AM_JMX_ENABLED, (Object)JOB_JMX_ENABLED);
            return this.getBoolean(AM_JMX_ENABLED);
        }
        if (this.containsKey(JOB_JMX_ENABLED)) {
            return this.getBoolean(JOB_JMX_ENABLED);
        }
        return true;
    }
}

